package com.ozacc.mail.impl;

import java.io.File;

import javax.mail.internet.InternetAddress;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;
import org.apache.velocity.VelocityContext;

import com.ozacc.mail.Mail;
import com.ozacc.mail.VelocityMailBuilder;
import com.ozacc.mail.impl.JDomXMLMailBuilderTest.Customer;

/**
 * 
 * @since 1.0.1
 * @author Tomohiro Otsuka
 * @version $Id: XMLVelocityMailBuilderImplTest.java,v 1.3 2004/10/22 00:50:38 otsuka Exp $
 */
public class XMLVelocityMailBuilderImplTest extends TestCase {

	private VelocityMailBuilder builder;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		BasicConfigurator.configure();
		builder = new XMLVelocityMailBuilderImpl();
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		BasicConfigurator.resetConfiguration();
	}

	public void testBuildMailFromFile() throws Exception {
		String path = "src/test/com/ozacc/mail/test-mail3-velocity.xml";
		File file = new File(path);

		String name = "";
		String email = "misaki@example.com";
		Customer customer = new Customer(name, email);
		String item = "GIVE&TAKE (Beige)";

		InternetAddress from = new InternetAddress("shop@example.com", "XMLMailBuilder饤󥷥å");
		InternetAddress to = new InternetAddress(email, name);

		String subject = "XMLMailBuilder饤󥷥å - ʸγǧ";
		String text = name + "\n\n㤤夲꤬Ȥޤ\n\nGIVE&TAKE (Beige)";

		VelocityContext context = new VelocityContext();
		context.put("customer", customer);
		context.put("item", item);

		// ᡼¹
		Mail result = builder.buildMail(file, context);

		assertEquals(from, result.getFrom());
		assertEquals(to, result.getTo()[0]);
		assertEquals(subject, result.getSubject());
		assertEquals(text, result.getText());
	}

	public final void testBuildMailStringVelocityContext() throws Exception {
		String classPath = "/com/ozacc/mail/test-mail3-velocity.xml";

		String name = "";
		String email = "misaki@example.com";
		Customer customer = new Customer(name, email);
		String item = "GIVE&TAKE (Beige)";

		InternetAddress from = new InternetAddress("shop@example.com", "XMLMailBuilder饤󥷥å");
		InternetAddress to = new InternetAddress(email, name);

		String subject = "XMLMailBuilder饤󥷥å - ʸγǧ";
		String text = name + "\n\n㤤夲꤬Ȥޤ\n\nGIVE&TAKE (Beige)";

		VelocityContext context = new VelocityContext();
		context.put("customer", customer);
		context.put("item", item);

		// ᡼¹
		Mail result = builder.buildMail(classPath, context);

		assertEquals(from, result.getFrom());
		assertEquals(to, result.getTo()[0]);
		assertEquals(subject, result.getSubject());
		assertEquals(text, result.getText());
	}

	public final void testBuildMailStringVelocityContextWithCache() throws Exception {
		builder.setCacheEnabled(true);

		String classPath = "/com/ozacc/mail/test-mail3-velocity.xml";

		String name = "";
		String email = "misaki@example.com";
		Customer customer = new Customer(name, email);
		String item = "GIVE&TAKE (Beige)";

		InternetAddress from = new InternetAddress("shop@example.com", "XMLMailBuilder饤󥷥å");
		InternetAddress to = new InternetAddress(email, name);
		String subject = "XMLMailBuilder饤󥷥å - ʸγǧ";
		String text = name + "\n\n㤤夲꤬Ȥޤ\n\nGIVE&TAKE (Beige)";

		VelocityContext context = new VelocityContext();
		context.put("customer", customer);
		context.put("item", item);

		// ᡼¹
		Mail result = builder.buildMail(classPath, context);
		Mail result2 = builder.buildMail(classPath, context);
		builder.clearCache();
		Mail result3 = builder.buildMail(classPath, context);

		assertEquals(from, result.getFrom());
		assertEquals(to, result.getTo()[0]);
		assertEquals(subject, result.getSubject());
		assertEquals(text, result.getText());
	}
}