package com.ozacc.mail.mock;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;

import com.ozacc.mail.fetch.ReceivedMail;

/**
 * MockFetchMailΥƥȥ
 * 
 * @author Tomohiro Otsuka
 * @version $Id: MockFetchMailTest.java,v 1.1.2.2 2005/02/05 09:28:58 otsuka Exp $
 */
public class MockFetchMailTest extends TestCase {

	MockFetchMail mockFetchMail;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		BasicConfigurator.configure();
		mockFetchMail = new MockFetchMail();
	}

	/*
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		BasicConfigurator.resetConfiguration();
	}

	public final void testGetMailsReturnZero() {
		ReceivedMail[] mails = mockFetchMail.getMails();
		assertEquals(0, mails.length);
	}

	public final void testGetMails() {
		ReceivedMail expectedMail = new ReceivedMail();
		expectedMail.setFrom("from@example.net", "п");
		expectedMail.addTo("to@example.com", "̾");
		expectedMail.setSubject("MockFetchMailTest");
		expectedMail.setText("ʸ");

		mockFetchMail.setupGetMails(expectedMail);

		ReceivedMail[] mails = mockFetchMail.getMails();
		assertEquals("1̼", 1, mails.length);

		ReceivedMail mail = mails[0];
		assertEquals("п", "п", mail.getFrom().getPersonal());
		assertEquals("пͥɥ쥹", "from@example.net", mail.getFrom().getAddress());
		assertEquals("1", 1, mail.getTo().length);
		assertEquals("̾", "to@example.com", (mail.getTo()[0]).getAddress());
		assertEquals("̾", "MockFetchMailTest", mail.getSubject());
		assertEquals("ʸ", "ʸ", mail.getText());
	}

}