/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch.impl;

import com.ozacc.mail.MailAuthenticationException;
import com.ozacc.mail.MailException;
import com.ozacc.mail.NotConnectedException;
import com.ozacc.mail.fetch.FetchMailPro;
import com.ozacc.mail.fetch.MailFetchException;
import com.ozacc.mail.fetch.ReceivedMail;
import com.ozacc.mail.fetch.impl.MailConverter;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FetchMailProImpl
implements FetchMailPro {
    private static Log log;
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PROTOCOL = "pop3";
    public static final int DEFAULT_PORT = -1;
    private static final String INBOX_NAME = "INBOX";
    private String host = "localhost";
    private String protocol = "pop3";
    private int port = -1;
    private String username;
    private String password;
    private boolean javaMailLogEnabled;
    private Store store;
    private Folder currentFolder;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.mail.fetch.impl.FetchMailProImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public FetchMailProImpl() {
        System.setProperty("mail.mime.multipart.ignoremissingendboundary", "true");
    }

    public synchronized void connect() throws MailException {
        if (this.isConnected()) {
            log.warn((Object)("\u65e2\u306b\u30b5\u30fc\u30d0[" + this.host + "]\u306b\u63a5\u7d9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u518d\u63a5\u7d9a\u3059\u308b\u306b\u306f\u5148\u306b\u63a5\u7d9a\u3092\u5207\u65ad\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002"));
            return;
        }
        log.debug((Object)(String.valueOf(this.protocol.toUpperCase()) + "\u30b5\u30fc\u30d0[" + this.host + "]\u306b\u63a5\u7d9a\u3057\u307e\u3059\u3002"));
        Session session = Session.getInstance((Properties)this.createProperties(), null);
        if (this.javaMailLogEnabled) {
            session.setDebug(true);
        }
        try {
            this.store = session.getStore(this.protocol);
            this.store.connect(this.host, this.port, this.username, this.password);
        }
        catch (NoSuchProviderException e) {
            log.error((Object)("\u6307\u5b9a\u3055\u308c\u305f\u30d7\u30ed\u30c8\u30b3\u30eb[" + this.protocol + "]\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002"), (Throwable)e);
            throw new MailException("\u6307\u5b9a\u3055\u308c\u305f\u30d7\u30ed\u30c8\u30b3\u30eb[" + this.protocol + "]\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", e);
        }
        catch (AuthenticationFailedException e) {
            log.error((Object)(String.valueOf(this.protocol.toUpperCase()) + "\u30b5\u30fc\u30d0[" + this.host + "]\u3078\u306e\u63a5\u7d9a\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (Throwable)e);
            throw new MailAuthenticationException(String.valueOf(this.protocol.toUpperCase()) + "\u30b5\u30fc\u30d0[" + this.host + "]\u3078\u306e\u63a5\u7d9a\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        catch (MessagingException e) {
            log.error((Object)(String.valueOf(this.protocol.toUpperCase()) + "\u30b5\u30fc\u30d0[" + this.host + "]\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (Throwable)e);
            throw new MailException(String.valueOf(this.protocol.toUpperCase()) + "\u30b5\u30fc\u30d0[" + this.host + "]\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        log.info((Object)(String.valueOf(this.protocol.toUpperCase()) + "\u30b5\u30fc\u30d0[" + this.host + "]\u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f\u3002"));
        this.changeFolder(INBOX_NAME);
    }

    private Properties createProperties() {
        Properties prop = new Properties();
        if ("apop".equalsIgnoreCase(this.protocol)) {
            prop.put("mail.pop3.apop.enable", "true");
        }
        return prop;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void disconnect() throws MailException {
        block6: {
            try {
                this.closeCurrentFolderIfOpen();
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                if (!this.isConnected()) throw throwable;
                log.debug((Object)(String.valueOf(this.protocol.toUpperCase()) + "\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3057\u307e\u3059\u3002"));
                try {
                    this.store.close();
                    this.store = null;
                    throw throwable;
                }
                catch (MessagingException e) {
                    throw new MailException("\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u5207\u65ad\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                }
            }
            {
                Object var1_3 = null;
                if (!this.isConnected()) break block6;
            }
            log.debug((Object)(String.valueOf(this.protocol.toUpperCase()) + "\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3057\u307e\u3059\u3002"));
            try {}
            catch (MessagingException e) {
                throw new MailException("\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u5207\u65ad\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
            this.store.close();
            this.store = null;
        }
        log.info((Object)(String.valueOf(this.protocol.toUpperCase()) + "\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3057\u307e\u3057\u305f\u3002"));
    }

    private void closeCurrentFolderIfOpen() throws MailException {
        if (this.currentFolder != null && this.currentFolder.isOpen()) {
            log.debug((Object)("\u30e1\u30c3\u30bb\u30fc\u30b8\u30d5\u30a9\u30eb\u30c0[" + this.currentFolder.getName() + "]\u3092\u30af\u30ed\u30fc\u30ba\u3057\u307e\u3059\u3002"));
            try {
                this.currentFolder.close(true);
            }
            catch (MessagingException e) {
                log.error((Object)("\u30e1\u30c3\u30bb\u30fc\u30b8\u30d5\u30a9\u30eb\u30c0[" + this.currentFolder.getName() + "]\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (Throwable)e);
                throw new MailException("\u30e1\u30c3\u30bb\u30fc\u30b8\u30d5\u30a9\u30eb\u30c0[" + this.currentFolder.getName() + "]\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
            log.debug((Object)("\u30e1\u30c3\u30bb\u30fc\u30b8\u30d5\u30a9\u30eb\u30c0[" + this.currentFolder.getName() + "]\u3092\u30af\u30ed\u30fc\u30ba\u3057\u307e\u3057\u305f\u3002"));
            this.currentFolder = null;
        }
    }

    public synchronized void changeFolder(String folderName) throws MailException {
        if (!this.isConnected()) {
            log.warn((Object)"\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        this.closeCurrentFolderIfOpen();
        log.debug((Object)("\u30e1\u30c3\u30bb\u30fc\u30b8\u30d5\u30a9\u30eb\u30c0[" + folderName + "]\u3092\u30aa\u30fc\u30d7\u30f3\u3057\u307e\u3059\u3002"));
        try {
            this.currentFolder = this.store.getFolder(folderName);
            this.currentFolder.open(2);
        }
        catch (MessagingException e) {
            log.error((Object)("\u30e1\u30c3\u30bb\u30fc\u30b8\u30d5\u30a9\u30eb\u30c0[" + folderName + "]\u306e\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (Throwable)e);
            throw new MailException("\u30e1\u30c3\u30bb\u30fc\u30b8\u30d5\u30a9\u30eb\u30c0[" + folderName + "]\u306e\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        log.debug((Object)("\u30e1\u30c3\u30bb\u30fc\u30b8\u30d5\u30a9\u30eb\u30c0[" + folderName + "]\u3092\u30aa\u30fc\u30d7\u30f3\u3057\u307e\u3057\u305f\u3002"));
    }

    public int getMailCount() throws MailException {
        this.checkIfCurrentFolderIsOpen();
        try {
            return this.currentFolder.getMessageCount();
        }
        catch (MessagingException e) {
            throw new MailFetchException("\u30e1\u30fc\u30eb\u6570\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    private void checkIfCurrentFolderIsOpen() throws NotConnectedException {
        if (this.currentFolder == null || !this.currentFolder.isOpen()) {
            throw new NotConnectedException(String.valueOf(this.protocol.toUpperCase()) + "\u30b5\u30fc\u30d0[" + this.host + "]\u306b\u63a5\u7d9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
    }

    public ReceivedMail getMail(int num) throws MailException {
        MimeMessage mimeMessage = this.getMessage(num);
        MailConverter converter = new MailConverter(mimeMessage);
        return converter.convertIntoMails()[0];
    }

    public ReceivedMail[] getMails(boolean delete) throws MailException {
        MimeMessage[] mimeMessages = this.getMessages(delete);
        MailConverter converter = new MailConverter(mimeMessages);
        return converter.convertIntoMails();
    }

    public synchronized MimeMessage getMessage(int num) throws MailException {
        this.checkIfCurrentFolderIsOpen();
        try {
            return (MimeMessage)this.currentFolder.getMessage(num);
        }
        catch (MessagingException e) {
            log.error((Object)"\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            throw new MailFetchException("\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public synchronized MimeMessage[] getMessages(boolean delete) throws MailException {
        this.checkIfCurrentFolderIsOpen();
        try {
            Message[] messages = this.currentFolder.getMessages();
            if (log.isInfoEnabled()) {
                if (messages.length > 0) {
                    log.info((Object)(String.valueOf(messages.length) + "\u901a\u306e\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3057\u307e\u3059\u3002"));
                } else {
                    log.info((Object)"\u53d7\u4fe1\u3059\u308b\u30e1\u30fc\u30eb\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
                }
            }
            this.currentFolder.setFlags(messages, new Flags(Flags.Flag.SEEN), true);
            if (delete) {
                this.currentFolder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
            }
            MimeMessage[] mimeMessages = new MimeMessage[messages.length];
            int i = 0;
            while (i < messages.length) {
                mimeMessages[i] = (MimeMessage)messages[i];
                ++i;
            }
            return mimeMessages;
        }
        catch (MessagingException e) {
            log.error((Object)"\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            throw new MailFetchException("\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    public boolean isConnected() {
        return this.store != null && this.store.isConnected();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isJavaMailLogEnabled() {
        return this.javaMailLogEnabled;
    }

    public void setJavaMailLogEnabled(boolean javaMailLogEnabled) {
        this.javaMailLogEnabled = javaMailLogEnabled;
    }
}

