/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch.impl.sk_jp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

class CorrectedContentTypeDataSource
implements DataSource,
MessageAware {
    protected DataSource source;
    protected String defaultCharset;
    protected String forceCharset;

    public CorrectedContentTypeDataSource() {
    }

    public CorrectedContentTypeDataSource(DataSource dataSource, String defaultCharset) {
        this.setDataSource(dataSource);
        this.setDefaultCharset(defaultCharset);
    }

    public CorrectedContentTypeDataSource(Part part, String defaultCharset) throws MessagingException {
        this.setPart(part);
        this.setDefaultCharset(defaultCharset);
    }

    public void setPart(Part part) throws MessagingException {
        this.setDataSource(part.getDataHandler().getDataSource());
    }

    public void setDataSource(DataSource newSource) {
        this.source = newSource;
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public void setForceCharset(String forceCharset) {
        this.forceCharset = forceCharset;
    }

    public String getContentType() {
        ContentType contentType = null;
        try {
            contentType = new ContentType(this.source.getContentType());
        }
        catch (ParseException e) {
            return "text/plain; charset=" + this.defaultCharset;
        }
        String specifiedCharset = contentType.getParameter("charset");
        if (specifiedCharset == null) {
            contentType.setParameter("charset", this.defaultCharset);
        } else if (this.forceCharset != null) {
            contentType.setParameter("charset", this.forceCharset);
        }
        return contentType.toString();
    }

    public String getName() {
        return this.source.getName();
    }

    public InputStream getInputStream() throws IOException {
        return this.source.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.source.getOutputStream();
    }

    public synchronized MessageContext getMessageContext() {
        if (this.source instanceof MessageAware) {
            return ((MessageAware)this.source).getMessageContext();
        }
        throw new RuntimeException(this.source + " isn't MessageAware.");
    }
}

