package com.ozacc.mail.mock;

import java.util.ArrayList;
import java.util.List;

import com.ozacc.mail.MailException;
import com.ozacc.mail.fetch.FetchMail;
import com.ozacc.mail.fetch.ReceivedMail;

/**
 * 
 * @author Tomohiro Otsuka
 * @version $Id: MockFetchMail.java,v 1.1.2.1 2004/10/24 10:18:41 otsuka Exp $
 */
public class MockFetchMail implements FetchMail {

	/** ǥեȤSMTPСlocalhost */
	public static final String DEFAULT_HOST = "localhost";

	/** ǥեȤΥץȥ롣pop3 */
	public static final String DEFAULT_PROTOCOL = "pop3";

	/**
	 * ǥեȤΥݡȡ-1<br>
	 * -1ϥץȥ˱ŬڤʥݡȤꤹ̤͡
	 */
	public static final int DEFAULT_PORT = -1;

	private static final String INBOX_NAME = "INBOX";

	private String host = DEFAULT_HOST;

	private String protocol = DEFAULT_PROTOCOL;

	private int port = DEFAULT_PORT;

	private String username;

	private String password;

	private List expectedMails;

	/**
	 * 󥹥ȥ饯
	 */
	public MockFetchMail() {
		super();
		expectedMails = new ArrayList();
	}

	public void addExcpectedReceivedMail(ReceivedMail expectedMail) {
		expectedMails.add(expectedMail);
	}

	public void addExcpectedReceivedMails(ReceivedMail[] expectedMails) {
		for (int i = 0; i < expectedMails.length; i++) {
			ReceivedMail mail = expectedMails[i];
			addExcpectedReceivedMail(mail);
		}
	}

	/**
	 * @see com.ozacc.mail.fetch.FetchMail#getMails()
	 */
	public ReceivedMail[] getMails() throws MailException {
		return (ReceivedMail[])expectedMails.toArray(new ReceivedMail[expectedMails.size()]);
	}

	/**
	 * @see com.ozacc.mail.fetch.FetchMail#getMails(boolean)
	 */
	public ReceivedMail[] getMails(boolean delete) throws MailException {
		ReceivedMail[] result = getMails();
		if (delete) {
			expectedMails.clear();
		}
		return result;
	}

	/**
	 * @return Returns the host.
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @param host The host to set.
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return Returns the password.
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @param password The password to set.
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @return Returns the port.
	 */
	public int getPort() {
		return port;
	}

	/**
	 * @param port The port to set.
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * @return Returns the protocol.
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * @param protocol The protocol to set.
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * @return Returns the username.
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @param username The username to set.
	 */
	public void setUsername(String username) {
		this.username = username;
	}
}