package com.ozacc.mail.mailet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.ozacc.mail.fetch.FetchMailPro;
import com.ozacc.mail.fetch.ReceivedMail;

/**
 * 
 * @author Tomohiro Otsuka
 * @version $Id: MailetRunner.java,v 1.1.2.2 2005/01/18 07:22:20 otsuka Exp $
 */
public class MailetRunner {

	private List mailetWrapperList;

	private FetchMailPro fetchMailPro;

	/**
	 * 󥹥ȥ饯
	 */
	public MailetRunner() {
		mailetWrapperList = new ArrayList();
	}

	public void run() {
		fetchMailPro.connect();
		try {
			int count = fetchMailPro.getMailCount();
			for (int i = 1; i <= count; i++) {
				ReceivedMail mail = fetchMailPro.getMail(i);
				processMail(mail);
			}
		} finally {
			if (fetchMailPro.isConnected()) {
				fetchMailPro.disconnect();
			}
		}
	}

	/**
	 * ꤵ줿᡼ФMailetŬѤޤ
	 * 
	 * @param mail MailetUnitϤ᡼
	 */
	private void processMail(ReceivedMail mail) {
		for (Iterator itr = mailetWrapperList.iterator(); itr.hasNext();) {
			MailetWrapper mailetUnit = (MailetWrapper)itr.next();
			mailetUnit.execute(mail);
		}
	}

	/**
	 * @param fetchMailPro The fetchMailPro to set.
	 */
	public void setFetchMailPro(FetchMailPro fetchMailPro) {
		this.fetchMailPro = fetchMailPro;
	}

	/**
	 * @param mailetWrapperList
	 */
	public void setMailetWrapperList(List mailetWrapperList) {
		this.mailetWrapperList = mailetWrapperList;
	}
}