package com.ozacc.mail.fetch.impl;

import com.ozacc.mail.MailException;
import com.ozacc.mail.fetch.FetchMail;
import com.ozacc.mail.fetch.ReceivedMail;

/**
 * <code>FetchMail</code>󥿡եμ饹
 * <p>
 * <code>FetchMailProImpl</code>饹˽ѾƤޤ
 * 
 * @since 1.2
 * @see FetchMailProImpl
 * 
 * @author Tomohiro Otsuka
 * @version $Id: FetchMailImpl.java,v 1.1.2.5 2005/01/18 16:42:00 otsuka Exp $
 */
public class FetchMailImpl implements FetchMail {

	//private FetchMailProImpl fetchMailProImpl;
	/** ǥեȤSMTPСlocalhost */
	public static final String DEFAULT_HOST = "localhost";

	/** ǥեȤΥץȥ롣pop3 */
	public static final String DEFAULT_PROTOCOL = "pop3";

	/**
	 * ǥեȤΥݡȡ-1<br>
	 * -1ϥץȥ˱ŬڤʥݡȤꤹ̤͡
	 */
	public static final int DEFAULT_PORT = -1;

	private static final String INBOX_NAME = "INBOX";

	private String host = DEFAULT_HOST;

	private String protocol = DEFAULT_PROTOCOL;

	private int port = DEFAULT_PORT;

	private String username;

	private String password;

	/**
	 * 󥹥ȥ饯
	 */
	public FetchMailImpl() {}

	/**
	 * @see com.ozacc.mail.fetch.FetchMail#getMails()
	 */
	public ReceivedMail[] getMails() throws MailException {
		return getMails(false);
	}

	/**
	 * @see com.ozacc.mail.fetch.FetchMail#getMails(boolean)
	 */
	public ReceivedMail[] getMails(boolean delete) throws MailException {
		FetchMailProImpl fetchMailProImpl = createFetchMailProImpl();
		fetchMailProImpl.connect();
		try {
			ReceivedMail[] mails = fetchMailProImpl.getMails(delete);
			return mails;
		} finally {
			fetchMailProImpl.disconnect();
		}
	}

	/**
	 * о򥻥åȤFetchMailProImpl󥹥󥹤ޤ
	 * 
	 * @return о򥻥åȤFetchMailProImpl󥹥
	 */
	private FetchMailProImpl createFetchMailProImpl() {
		FetchMailProImpl fmp = new FetchMailProImpl();
		fmp.setHost(host);
		fmp.setPort(port);
		fmp.setProtocol(protocol);
		fmp.setUsername(username);
		fmp.setPassword(password);
		return fmp;
	}

	/**
	 * ᡼륵ФΥۥ̾ޤIPɥ쥹򥻥åȤޤ
	 * ǥեȤ localhost Ǥ
	 * 
	 * @param host ᡼륵ФΥۥ̾ޤIPɥ쥹
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * ᡼륵Фǧڥѥ̾򥻥åȤޤ
	 * 
	 * @param password ᡼륵Фǧڥѥ
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * ᡼˻Ѥݡֹ򥻥åȤޤ
	 * ץȥ˱ݡֹ椬ưŪ˻ѤޤΤǡ̾盧ǥݡֹ򥻥åȤɬפϤޤ
	 * 
	 * @param port ݡֹ
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * ᡼˻Ѥץȥ򥻥åȤޤ
	 * ߥݡȤƤץȥϡpop3פȡimapפĤǤ
	 * ǥեȤϡpop3פǤ
	 * <p>
	 * POP3ФؤǧڤAPOPǹԤϡץȥ̾ǤϤޤ󤬡
	 * apopפꤷƤAPOPǧڤѤˤϡJavaMail 1.3.2ʹߤɬפǤ
	 * 
	 * @param protocol ץȥ
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * ᡼륵Фǧڥ桼̾򥻥åȤޤ
	 * 
	 * @param username ᡼륵Фǧڥ桼̾
	 */
	public void setUsername(String username) {
		this.username = username;
	}

	/**
	 * ᡼륵ФΥۥ̾ޤIPɥ쥹֤ޤ
	 * 
	 * @return ᡼륵ФΥۥ̾ޤIPɥ쥹
	 */
	public String getHost() {
		return host;
	}

	/**
	 * ᡼륵Фǧڥѥɤ֤ޤ
	 * 
	 * @return ᡼륵Фǧڥѥ
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @return ݡֹ
	 */
	public int getPort() {
		return port;
	}

	/**
	 * ᡼˻Ѥץȥ򥻥åȤޤ
	 * 
	 * @return ץȥ
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * ᡼륵Фǧڥ桼֤̾ޤ
	 * 
	 * @return ᡼륵Фǧڥ桼̾
	 */
	public String getUsername() {
		return username;
	}
}