/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.trackback.impl;

import com.ozacc.blog.trackback.TrackBackExtractor;
import com.ozacc.blog.trackback.TrackBackPing;
import com.ozacc.blog.trackback.TrackBackUtils;
import com.ozacc.blog.trackback.support.CharsetResolver;
import com.ozacc.blog.trackback.support.impl.DefaultCharsetResolver;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrackBackExtractorImpl
implements TrackBackExtractor {
    private static Log log;
    private List charsetResolvers;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.blog.trackback.impl.TrackBackExtractorImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public TrackBackExtractorImpl() {
    }

    public TrackBackExtractorImpl(List charsetResolvers) {
        this();
        this.setCharsetResolvers(charsetResolvers);
    }

    public void setCharsetResolvers(List charsetResolvers) {
        this.charsetResolvers = charsetResolvers;
    }

    public TrackBackPing getTrackBackPingFromRequest(HttpServletRequest request) {
        if (log.isDebugEnabled()) {
            TrackBackExtractorImpl.logReceivedRequest(request);
        }
        String encoding = request.getCharacterEncoding();
        log.debug((Object)("characterEncoding='" + encoding + "'"));
        TrackBackPing ping = TrackBackUtils.getTrackBackPingFromRequest(request);
        if (this.isEmpty(encoding)) {
            if (this.isCharsetEmpty(ping)) {
                this.resolveCharset(ping, request);
            }
            try {
                ping.setExcerpt(TrackBackUtils.convertCharset(ping.getCharset(), ping.getExcerpt()));
                ping.setBlogName(TrackBackUtils.convertCharset(ping.getCharset(), ping.getBlogName()));
                ping.setTitle(TrackBackUtils.convertCharset(ping.getCharset(), ping.getTitle()));
                ping.setUrl(TrackBackUtils.convertCharset(ping.getCharset(), ping.getUrl()));
            }
            catch (UnsupportedEncodingException e) {}
        } else if (this.isCharsetEmpty(ping)) {
            ping.setCharset(encoding);
        }
        return ping;
    }

    private boolean isCharsetEmpty(TrackBackPing ping) {
        return ping.getCharset() == null || ping.getCharset().length() == 0;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private void resolveCharset(TrackBackPing ping, HttpServletRequest request) {
        if (this.charsetResolvers != null) {
            Iterator itr = this.charsetResolvers.iterator();
            while (itr.hasNext()) {
                CharsetResolver resolver = (CharsetResolver)itr.next();
                String charset = resolver.resolveCharset((TrackBackPing)ping.clone(), request);
                if (this.isEmpty(charset)) continue;
                ping.setCharset(charset);
                return;
            }
        }
        DefaultCharsetResolver resolver = new DefaultCharsetResolver();
        String charset = resolver.resolveCharset(ping, request);
        ping.setCharset(charset);
    }

    private static void logReceivedRequest(HttpServletRequest request) {
        StringBuffer buf = new StringBuffer();
        buf.append("\u53d7\u4fe1\u3057\u305f\u30ea\u30af\u30a8\u30b9\u30c8\u306e\u30d8\u30c3\u30c0\u3068\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u4e00\u89a7\u3092\u51fa\u529b\u3057\u307e\u3059\u3002");
        buf.append("----------------------------------------\n");
        buf.append("\u30ea\u30af\u30a8\u30b9\u30c8\u30d8\u30c3\u30c0\n");
        buf.append("----------------------------------------\n");
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            String headerValue = request.getHeader(headerName);
            buf.append(headerName).append("='").append(headerValue).append("'\n");
        }
        buf.append("----------------------------------------\n");
        buf.append("\u30ea\u30af\u30a8\u30b9\u30c8\u30d1\u30e9\u30e1\u30fc\u30bf\n");
        buf.append("----------------------------------------\n");
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            String paramValue = request.getParameter(paramName);
            buf.append(paramName).append("='").append(paramValue).append("'\n");
        }
        buf.append("----------------------------------------\n");
        log.debug((Object)buf.toString());
    }
}

