package com.ozacc.mail.impl;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.log.LogSystem;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.VelocityMailBuilder;

/**
 * XMLեɤ߹ߡVelocityϢȤưŪ˥᡼ǡΥǡMail󥹥󥹤륯饹
 * 
 * @since 1.0.1
 * @author Tomohiro Otsuka
 * @version $Id: XMLVelocityMailBuilderImpl.java,v 1.4 2004/09/17 19:23:25 otsuka Exp $
 */
public class XMLVelocityMailBuilderImpl extends XMLMailBuilderImpl implements VelocityMailBuilder {

	private static Log log = LogFactory.getLog(XMLVelocityMailBuilderImpl.class);

	private String charset = "UTF-8";

	private LogSystem velocityLogSystem = new VelocityLogSystem();

	/**
	 * @see com.ozacc.mail.VelocityMailBuilder#buildMail(java.lang.String, org.apache.velocity.VelocityContext)
	 */
	public Mail buildMail(String classPath, VelocityContext context) throws MailBuildException {
		Document doc;
		try {
			// VelocityޡXMLǤϥȤĤ
			doc = getDocumentFromClassPath(classPath, false);
		} catch (SAXException e) {
			throw new MailBuildException("XMLΥѡ˼Ԥޤ" + e.getMessage(), e);
		} catch (IOException e) {
			throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
		}

		try {
			return build(doc, context);
		} catch (Exception e) {
			throw new MailBuildException("᡼˼Ԥޤ", e);
		}
	}

	/**
	 * @see com.ozacc.mail.VelocityMailBuilder#buildMail(java.io.File, org.apache.velocity.VelocityContext)
	 */
	public Mail buildMail(File file, VelocityContext context) throws MailBuildException {
		Document doc;
		try {
			// VelocityޡXMLǤϥȤĤ
			doc = getDocumentFromFile(file, false);
		} catch (SAXException e) {
			throw new MailBuildException("XMLΥѡ˼Ԥޤ" + e.getMessage(), e);
		} catch (IOException e) {
			throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
		}

		try {
			return build(doc, context);
		} catch (Exception e) {
			throw new MailBuildException("᡼˼Ԥޤ", e);
		}
	}

	/**
	 * @param doc
	 * @param context
	 * @throws TransformerFactoryConfigurationError
	 * @throws Exception
	 * @throws ParseErrorException
	 * @throws MethodInvocationException
	 * @throws ResourceNotFoundException
	 * @throws IOException 
	 */
	private Mail build(Document doc, VelocityContext context)
																throws TransformerFactoryConfigurationError,
																Exception, ParseErrorException,
																MethodInvocationException,
																ResourceNotFoundException,
																IOException {
		String xmlContent = convertDocumentIntoString(doc);

		if (log.isDebugEnabled()) {
			log.debug("Source XML Mail Data\n" + xmlContent);
		}

		Velocity.setProperty(Velocity.RUNTIME_LOG_LOGSYSTEM, velocityLogSystem);
		Velocity.init();
		StringWriter w = new StringWriter();
		Velocity.evaluate(context, w, "XML Mail Data", xmlContent);
		StringReader reader = new StringReader(w.toString());

		DocumentBuilder db = createDocumentBuilder();
		InputSource source = new InputSource(reader);
		Document newDoc = db.parse(source);

		if (log.isDebugEnabled()) {
			String newXmlContent = convertDocumentIntoString(newDoc);
			log.debug("VelocityContext-merged XML Mail Data\n" + newXmlContent);
		}

		return buildMail(newDoc);
	}

	/**
	 * ꤵ줿DOM DocumentʸѴޤ
	 * 
	 * @param doc
	 * @return XMLɥȤʸ
	 * @throws TransformerFactoryConfigurationError 
	 */
	private String convertDocumentIntoString(Document doc)
															throws TransformerFactoryConfigurationError {
		TransformerFactory tf = TransformerFactory.newInstance();
		Transformer t;
		try {
			t = tf.newTransformer();
		} catch (TransformerConfigurationException e) {
			throw new MailBuildException(e.getMessage(), e);
		}
		t.setOutputProperties(getOutputProperties());

		DOMSource source = new DOMSource(doc);
		StringWriter w = new StringWriter();
		StreamResult result = new StreamResult(w);
		try {
			t.transform(source, result);
		} catch (TransformerException e) {
			throw new MailBuildException(e.getMessage(), e);
		}

		return w.toString();
	}

	/**
	 * ϥץѥƥ
	 * @return ϥץѥƥꤷProperties󥹥
	 */
	private Properties getOutputProperties() {
		Properties p = new Properties();
		p.put(OutputKeys.ENCODING, charset);
		p.put(OutputKeys.DOCTYPE_PUBLIC, Mail.DOCTYPE_PUBLIC);
		p.put(OutputKeys.DOCTYPE_SYSTEM, Mail.DOCTYPE_SYSTEM);
		return p;
	}

}