/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MultipartMail;
import com.ozacc.mail.impl.Cp932;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;

public class MimeMessageBuilder {
    private MimeMessage mimeMessage;
    private String charset = "ISO-2022-JP";
    private boolean hasRecipient = false;
    private MimeMultipart mimeMultipart;

    public MimeMessageBuilder(MimeMessage mimeMessage) {
        this.mimeMessage = mimeMessage;
    }

    public MimeMessageBuilder(MimeMessage mimeMessage, String charset) {
        this.mimeMessage = mimeMessage;
        this.charset = charset;
    }

    public MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    public void buildMimeMessage(Mail mail) throws UnsupportedEncodingException, MessagingException {
        this.setTo(mail);
        this.setCc(mail);
        this.setBcc(mail);
        if (!this.hasRecipient) {
            throw new MessagingException("\u5b9b\u5148\u306e\u6307\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093\u3002To\u3001Cc\u3001Bcc\u306e\u3044\u305a\u308c\u304b\u4e00\u3064\u306f\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        this.setFrom(mail);
        this.setSubject(mail);
        this.setReplyTo(mail);
        this.setXHeaders(mail);
        this.setImportance(mail);
        if (mail instanceof MultipartMail) {
            MultipartMail mm = (MultipartMail)mail;
            if (mm.getAttachmentFiles().length == 0 && mm.isHtmlMail()) {
                MimeMultipart textAndHtmlMultipart = new MimeMultipart("alternative");
                this.setPlainText(mm, textAndHtmlMultipart);
                this.setHtmlText(mm, textAndHtmlMultipart);
                this.mimeMessage.setContent((Multipart)textAndHtmlMultipart);
            } else if (mm.getAttachmentFiles().length > 0 && mm.isHtmlMail()) {
                MimeMultipart textAndHtmlMultipart = new MimeMultipart("alternative");
                this.setPlainText(mm, textAndHtmlMultipart);
                this.setHtmlText(mm, textAndHtmlMultipart);
                MimeMultipart containingMultipart = new MimeMultipart();
                MimeBodyPart textBodyPart = this.createMimeBodyPart(containingMultipart);
                textBodyPart.setContent((Multipart)textAndHtmlMultipart);
                this.setAttachmentFiles(mm, containingMultipart);
                this.mimeMessage.setContent((Multipart)containingMultipart);
            } else {
                MimeMultipart mimeMultipart = new MimeMultipart();
                this.setPlainText(mm, mimeMultipart);
                this.setAttachmentFiles(mm, mimeMultipart);
                this.mimeMessage.setContent((Multipart)mimeMultipart);
            }
        } else {
            this.setText(mail.getText(), (MimePart)this.mimeMessage);
        }
    }

    private void setAttachmentFiles(MultipartMail mm, MimeMultipart mimeMultipart) throws MessagingException, UnsupportedEncodingException {
        MultipartMail.AttachmentFile[] files = mm.getAttachmentFiles();
        int i = 0;
        while (i < files.length) {
            MimeBodyPart bodyPart = this.createMimeBodyPart(mimeMultipart);
            MultipartMail.AttachmentFile attachmentFile = files[i];
            this.addAttachment(attachmentFile.getName(), (DataSource)new FileDataSource(attachmentFile.getFile()), bodyPart);
            ++i;
        }
    }

    private void setHtmlText(MultipartMail mm, MimeMultipart mimeMultipart) throws MessagingException {
        if (mm.isHtmlMail()) {
            MimeBodyPart bodyPart = this.createMimeBodyPart(mimeMultipart);
            this.setHtmlText(mm.getHtmlText(), bodyPart);
        }
    }

    private void setPlainText(MultipartMail mm, MimeMultipart mimeMultipart) throws MessagingException {
        if (mm.getText() != null && mm.getText().length() > 0) {
            MimeBodyPart bodyPart = this.createMimeBodyPart(mimeMultipart);
            this.setText(mm.getText(), (MimePart)bodyPart);
        }
    }

    private MimeBodyPart createMimeBodyPart(MimeMultipart mm) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        mm.addBodyPart((BodyPart)bodyPart);
        return bodyPart;
    }

    private void setHtmlText(final String htmlText, MimeBodyPart bodyPart) throws MessagingException {
        bodyPart.setDataHandler(new DataHandler(new DataSource(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(MimeMessageBuilder.this.charset != null ? htmlText.getBytes(MimeMessageBuilder.this.charset) : htmlText.getBytes());
            }

            public OutputStream getOutputStream() throws IOException {
                throw new UnsupportedOperationException("Read-only javax.activation.DataSource");
            }

            public String getContentType() {
                return MimeMessageBuilder.this.charset == null ? "text/html" : "text/html; charset=" + MimeMessageBuilder.this.charset;
            }

            public String getName() {
                return "text";
            }
        }));
        bodyPart.setHeader("Content-Transfer-Encoding", "7bit");
    }

    private void setXHeaders(Mail mail) throws MessagingException {
        Map headers = mail.getXHeaders();
        if (headers == null) {
            return;
        }
        Iterator itr = headers.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            String value = (String)headers.get(key);
            this.mimeMessage.setHeader(key, value);
        }
    }

    private void setImportance(Mail mail) throws MessagingException {
        if (mail.getImportance() != null) {
            this.mimeMessage.setHeader("Importance", mail.getImportance());
            int level = 3;
            if ("high".equals(mail.getImportance())) {
                level = 1;
            } else if ("low".equals(mail.getImportance())) {
                level = 5;
            }
            this.mimeMessage.setHeader("X-Priority", String.valueOf(level));
        }
    }

    private void setReplyTo(Mail mail) throws MessagingException {
        if (mail.getReplyTo() != null) {
            this.mimeMessage.setReplyTo((Address[])new InternetAddress[]{mail.getReplyTo()});
        }
    }

    private void setBcc(Mail mail) throws MessagingException {
        if (mail.getBcc().length > 0) {
            this.mimeMessage.setRecipients(MimeMessage.RecipientType.BCC, (Address[])mail.getBcc());
            this.hasRecipient = true;
        }
    }

    private void setCc(Mail mail) throws MessagingException {
        if (mail.getCc().length > 0) {
            this.mimeMessage.setRecipients(MimeMessage.RecipientType.CC, (Address[])mail.getCc());
            this.hasRecipient = true;
        }
    }

    private void setTo(Mail mail) throws MessagingException {
        if (mail.getTo().length > 0) {
            this.mimeMessage.setRecipients(MimeMessage.RecipientType.TO, (Address[])mail.getTo());
            this.hasRecipient = true;
        }
    }

    private void setText(String text, MimePart mimePart) throws MessagingException {
        if (this.charset != null) {
            if (this.charset.equalsIgnoreCase("ISO-2022-JP")) {
                mimePart.setText(String.valueOf(Cp932.toJIS(text)) + "\n", this.charset);
            } else {
                mimePart.setText(String.valueOf(text) + "\n", this.charset);
            }
        } else {
            mimePart.setText(text);
        }
        mimePart.setHeader("Content-Transfer-Encoding", "7bit");
    }

    private void setSubject(Mail mail) throws UnsupportedEncodingException, MessagingException {
        if (this.charset != null) {
            if (this.charset.equalsIgnoreCase("ISO-2022-JP")) {
                String subject = Cp932.toJIS(mail.getSubject());
                this.mimeMessage.setSubject(MimeUtility.encodeText((String)subject, (String)this.charset, (String)"B"));
            } else {
                this.mimeMessage.setSubject(mail.getSubject(), this.charset);
            }
        } else {
            this.mimeMessage.setSubject(mail.getSubject());
        }
    }

    private void setFrom(Mail mail) throws MessagingException {
        this.mimeMessage.setFrom((Address)mail.getFrom());
    }

    private void addAttachment(String fileName, DataSource dataSource, MimeBodyPart mimeBodyPart) throws UnsupportedEncodingException, MessagingException {
        if (this.charset != null) {
            mimeBodyPart.setFileName(MimeUtility.encodeText((String)fileName, (String)this.charset, (String)"B"));
        } else {
            mimeBodyPart.setFileName(fileName);
        }
        mimeBodyPart.setDataHandler(new DataHandler(dataSource));
    }
}

