/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail;

import com.ozacc.mail.Mail;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MultipartMail
extends Mail {
    private String htmlText;
    private List attachmentFiles;

    public MultipartMail() {
    }

    public MultipartMail(String charset) {
        super(charset);
    }

    public MultipartMail(Mail original) {
        super(original);
    }

    public MultipartMail(MultipartMail original) {
        super(original);
        this.htmlText = original.htmlText;
        this.attachmentFiles = original.attachmentFiles;
    }

    public void setHtmlText(String htmlText) {
        this.htmlText = htmlText;
    }

    public String getHtmlText() {
        return this.htmlText;
    }

    public void addFile(File file) {
        this.addFile(file, file.getName());
    }

    public void addFile(File file, String fileName) {
        if (this.attachmentFiles == null) {
            this.attachmentFiles = new ArrayList();
        }
        this.attachmentFiles.add(new AttachmentFile(fileName, file));
    }

    public AttachmentFile[] getAttachmentFiles() {
        if (this.attachmentFiles == null) {
            return new AttachmentFile[0];
        }
        return this.attachmentFiles.toArray(new AttachmentFile[this.attachmentFiles.size()]);
    }

    public boolean isHtmlMail() {
        return this.htmlText != null;
    }

    public static class AttachmentFile {
        private String name;
        private File file;

        public AttachmentFile(String name, File file) {
            this.name = name;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public String getName() {
            return this.name;
        }
    }
}

