package com.ozacc.mail;

import java.io.File;

import org.apache.velocity.VelocityContext;

import com.ozacc.mail.impl.JDomXMLMailBuilder;

/**
 * XMLե뤫Mail󥹥󥹤륯饹δݥ饹
 *
 * @author Tomohiro Otsuka
 * @version $Id: XMLMailBuilder.java,v 1.3 2004/09/04 13:55:51 otsuka Exp $
 */
public abstract class XMLMailBuilder implements VelocityMailBuilder {

	/**
	 * ǥեȤXMLMailBuilder饹Υ󥹥󥹤֤ޤ
	 * ߤϡJDomXMLMailBuilderǥեȼ饹Ǥ
	 * 
	 * @see com.ozacc.mail.impl.JDomXMLMailBuilder
	 * 
	 * @return XMLMailBuilder饹Υ󥹥
	 */
	public static XMLMailBuilder getInstance() {
		return new JDomXMLMailBuilder();
	}

	/**
	 * ꤵ줿饹ѥXMLե뤫Mail󥹥󥹤ޤ
	 * 
	 * @param classPath ᡼Ƥ򵭽ҤXMLեΥѥ
	 * @return 줿Mail󥹥
	 * @throws MailBuildException Mail󥹥󥹤˼Ԥ
	 */
	public abstract Mail buildMail(String classPath) throws MailBuildException;

	/**
	 * ꤵ줿饹ѥXMLե뤫Mail󥹥󥹤ޤ
	 * ꤵ줿VelocityContextȤäơXMLեƤưŪǤޤ
	 * 
	 * @param classPath ᡼Ƥ򵭽ҤXMLեΥѥ
	 * @param context VelocityContext
	 * @return 줿Mail󥹥
	 * @throws MailBuildException Mail󥹥󥹤˼Ԥ
	 */
	public abstract Mail buildMail(String classPath, VelocityContext context)
																				throws MailBuildException;

	/**
	 * ꤵ줿XMLե뤫Mail󥹥󥹤ޤ
	 * 
	 * @param file ᡼Ƥ򵭽ҤXMLե
	 * @return 줿Mail󥹥
	 * @throws MailBuildException Mail󥹥󥹤˼Ԥ
	 */
	public abstract Mail buildMail(File file) throws MailBuildException;

	/**
	 * ꤵ줿XMLե뤫Mail󥹥󥹤ޤ
	 * ꤵ줿VelocityContextȤäơXMLեƤưŪǤޤ
	 * 
	 * @param file ᡼Ƥ򵭽ҤXMLե
	 * @param context VelocityContext
	 * @return 줿Mail󥹥
	 * @throws MailBuildException Mail󥹥󥹤˼Ԥ
	 */
	public abstract Mail buildMail(File file, VelocityContext context) throws MailBuildException;

}