/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.springframework.mail.javamail;

import com.ozacc.springframework.mail.VelocityMailMessage;
import com.ozacc.springframework.mail.javamail.IntlJavaMailSenderImpl;
import com.ozacc.springframework.mail.javamail.VelocityJavaMailSender;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.ui.velocity.VelocityEngineFactory;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class VelocityJavaMailSenderImpl
extends IntlJavaMailSenderImpl
implements VelocityJavaMailSender {
    private VelocityEngine velocityEngine;

    public void send(VelocityMailMessage velocityMailMessage) throws MailException {
        this.send(new VelocityMailMessage[]{velocityMailMessage});
    }

    public void send(VelocityMailMessage[] velocityMailMessages) throws MailException {
        if (this.velocityEngine == null) {
            try {
                this.velocityEngine = this.createDefaultVelocityEngine();
            }
            catch (Exception e) {
                throw new MailParseException("Fails to create a velocity engine.", (Throwable)e);
            }
        }
        try {
            this.setTextUsingVelocity(velocityMailMessages);
        }
        catch (VelocityException e) {
            throw new MailParseException("Fails to generate text using Velocity.", (Throwable)e);
        }
        super.send(velocityMailMessages);
    }

    private void setTextUsingVelocity(VelocityMailMessage[] velocityMailMessages) throws VelocityException {
        for (int i = 0; i < velocityMailMessages.length; ++i) {
            VelocityMailMessage msg = velocityMailMessages[i];
            if (!this.validate(msg)) {
                throw new MailParseException("Velocity template path and/or context is not set.");
            }
            String generatedText = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)msg.getTemplatePath(), (Map)msg.getContext());
            msg.setText(generatedText);
        }
    }

    private boolean validate(VelocityMailMessage velocityMailMessage) {
        String templatePath = velocityMailMessage.getTemplatePath();
        Map context = velocityMailMessage.getContext();
        return templatePath != null && templatePath.length() > 0 && context != null;
    }

    private VelocityEngine createDefaultVelocityEngine() throws IOException, VelocityException {
        VelocityEngineFactory factory = new VelocityEngineFactory();
        factory.setOverrideLogging(true);
        Properties props = new Properties();
        props.put("resource.loader", "class");
        props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        props.put("input.encoding", "UTF-8");
        props.put("output.encoding", "UTF-8");
        props.put("velocimacro.library", "");
        factory.setVelocityProperties(props);
        return factory.createVelocityEngine();
    }

    public void setVelocityEngine(VelocityEngine engine) {
        this.velocityEngine = engine;
    }
}

