/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.springframework.mail.javamail;

import com.ozacc.springframework.mail.PlainMailMessage;
import com.ozacc.springframework.mail.javamail.IntlJavaMailSender;
import com.ozacc.springframework.mail.javamail.IntlMimeMessageHelper;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class IntlJavaMailSenderImpl
extends JavaMailSenderImpl
implements IntlJavaMailSender {
    protected static final String JIS_ENCODING = "iso-2022-jp";
    protected String charset = "iso-2022-jp";

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void send(PlainMailMessage plainMessage) throws MailException {
        this.send(new PlainMailMessage[]{plainMessage});
    }

    public void send(PlainMailMessage[] plainMessages) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>();
            for (int i = 0; i < plainMessages.length; ++i) {
                PlainMailMessage plainMessage = plainMessages[i];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending email using the following mail properties [" + (Object)((Object)plainMessage) + "]"));
                }
                IntlMimeMessageHelper message = new IntlMimeMessageHelper(this.createMimeMessage(), this.charset);
                this.assembleMailHeader(plainMessage, message);
                this.setText(plainMessage, message);
                mimeMessages.add(message.getMimeMessage());
            }
            this.send(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]), (Object[])plainMessages);
        }
        catch (UnsupportedEncodingException ex) {
            throw new MailParseException((Throwable)ex);
        }
        catch (MessagingException ex) {
            throw new MailParseException((Throwable)ex);
        }
    }

    protected void setText(PlainMailMessage plainMessage, MimeMessageHelper message) throws MessagingException {
        if (plainMessage.getText() != null) {
            message.setText(plainMessage.getText() + "\n");
        }
    }

    protected void assembleMailHeader(PlainMailMessage plainMessage, MimeMessageHelper message) throws MessagingException, UnsupportedEncodingException, IllegalStateException {
        if (plainMessage.getFrom() != null && plainMessage.getFromName() != null) {
            message.setFrom(plainMessage.getFrom(), plainMessage.getFromName());
        } else if (plainMessage.getFrom() != null) {
            message.setFrom(plainMessage.getFrom());
        }
        if (plainMessage.getTo() != null && plainMessage.getToName() != null) {
            String[] personal;
            String[] to = plainMessage.getTo();
            if (to.length != (personal = plainMessage.getToName()).length) {
                throw new IllegalStateException("\u5b9b\u5148\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u3068\u5b9b\u540d\u306e\u6570\u304c\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093\u3002 [" + to.length + " emails / " + personal.length + " names]");
            }
            for (int j = 0; j < to.length; ++j) {
                message.addTo(to[j], personal[j]);
            }
        } else if (plainMessage.getTo() != null) {
            String[] to = plainMessage.getTo();
            for (int j = 0; j < to.length; ++j) {
                message.addTo(to[j]);
            }
        }
        if (plainMessage.getCc() != null) {
            message.setCc(plainMessage.getCc());
        }
        if (plainMessage.getBcc() != null) {
            message.setBcc(plainMessage.getBcc());
        }
        if (plainMessage.getReplyTo() != null) {
            message.setReplyTo(plainMessage.getReplyTo());
        }
        if (plainMessage.getSubject() != null) {
            message.setSubject(plainMessage.getSubject());
        }
        if (plainMessage.getSentDate() != null) {
            message.setSentDate(plainMessage.getSentDate());
        }
    }

    public void send(SimpleMailMessage[] simpleMessages) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>();
            for (int i = 0; i < simpleMessages.length; ++i) {
                SimpleMailMessage simpleMessage = simpleMessages[i];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Creating new MIME message using the following mail properties: " + simpleMessage));
                }
                IntlMimeMessageHelper message = new IntlMimeMessageHelper(this.createMimeMessage(), this.charset);
                if (simpleMessage.getFrom() != null) {
                    message.setFrom(simpleMessage.getFrom());
                }
                if (simpleMessage.getTo() != null) {
                    message.setTo(simpleMessage.getTo());
                }
                if (simpleMessage.getCc() != null) {
                    message.setCc(simpleMessage.getCc());
                }
                if (simpleMessage.getBcc() != null) {
                    message.setBcc(simpleMessage.getBcc());
                }
                if (simpleMessage.getReplyTo() != null) {
                    message.setReplyTo(simpleMessage.getReplyTo());
                }
                if (simpleMessage.getSentDate() != null) {
                    message.setSentDate(simpleMessage.getSentDate());
                }
                if (simpleMessage.getSubject() != null) {
                    message.setSubject(simpleMessage.getSubject());
                }
                if (simpleMessage.getText() != null) {
                    message.setText(simpleMessage.getText());
                }
                mimeMessages.add(message.getMimeMessage());
            }
            this.send(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]), simpleMessages);
        }
        catch (MessagingException ex) {
            throw new MailParseException((Throwable)ex);
        }
    }
}

