//nocopy ifdef applet
/*
 * Created on 2004/12/23
 *
 */
package ui;

import java.util.Hashtable;

import com.nttdocomo.ui.Display;
import com.nttdocomo.ui.Font;
import com.nttdocomo.ui.Frame;
import com.nttdocomo.ui.Graphics;
import com.nttdocomo.ui.Label;
import com.nttdocomo.ui.Panel;
import com.nttdocomo.ui.TextBox;
import com.nttdocomo.ui.UIException;


/**
 *  OtBbNX̐Ȃ܂
 *
 *  @author hoge1000
 */
/*
                  
   */
public class G {
    public static final int yPitch=14;
    public static ICWindow wnd;
    public static int sWidth=240,sHeight=256;
    /*public static void println(String s) {
        System.out.println(s);
    }*/
    public static void clearAllScreen() {
        setColor(255,255,255);
        fillRect(0,0,sWidth,sHeight);
    }
    public static Graphics gr;
    public static int fontType=Font.FACE_MONOSPACE | Font.SIZE_TINY;
    public static Font font;
    public static int stringWidth(String s) {
        return font.stringWidth(s);
    }
    public static void lock() {
        gr=wnd.getGraphics();
        gr.setFont(font);
        gr.lock();
    }
    public static void unlock() {
        gr.unlock(false);
    }
    public static void setColor(int r,int g,int b) {
    	if (r>255) r=255; if (r<0) r=0;
    	if (g>255) g=255; if (g<0) g=0;
    	if (b>255) b=255; if (b<0) b=0;

        gr.setColor(Graphics.getColorOfRGB(r,g,b));
    }
    public static void setColor(int i) {
        Integer c =(Integer)colors.get(new Integer(i));
        if (c!=null) {
            int ci=c.intValue();
            int r = ci & 255;
            ci/=256;
            int g = ci & 255;
            ci/=256;
            int b = ci & 255;
            //println(r+","+g+","+b);
            setColor(r,g,b);
        }
        
    }
    public static int drawString(String s,int x,int y) {
        gr.drawString(s,x,y);
        return stringWidth(s);
    }
    public static void drawRect(int x,int y,int w,int h) {
        if (w<0) {x+=w;w=-w;}
        if (h<0) {y+=h;h=-h;}
        gr.drawRect(x,y,w,h);
    }
    public static void drawLine(int x,int y,int w,int h) {
        gr.drawLine(x,y,x+w,y+h);
    }
    public static void fillRect(int x,int y,int w,int h) {
        if (w<0) {x+=w;w=-w;}
        if (h<0) {y+=h;h=-h;}
        gr.fillRect(x,y,w,h);
    }
    //----init
    /**
     * AvP[VJnƌĂ΂܂
     *
     */
    public static void start() {
        font=Font.getFont(fontType);
        sWidth=Display.getWidth();
        sHeight=Display.getHeight();
        wnd=new ICWindow();
        setMainMenu();
        input=new Panel();
        input.add(new Label("Press Select to input"));
        input.add(textBox=new TextBox("",20,1,TextBox.DISPLAY_ANY));
        textBox.setInputMode(TextBox.ALPHA);
        Display.setCurrent(wnd);
        for (int i=0 ; i<16 ;i++) {
            int r=(i & 1)*255;
            int g=(i & 2)*127;
            int b=(i & 4)*63;
            if (i>=8) {r/=2;g/=2;b/=2;}
            setColorPal(i,r,g,b);
        }
    }
    static Hashtable colors=new Hashtable();
    public static boolean init=false;
    /**
     * wnd \ƌĂяo܂
     */ 
    public static void paint() {
        if (!init) {
            init=true;
            lock();
            unlock();
            new Console();
            Console.current.draw();
            EventLoop.instance.startLoop();
        }
    }
    public static void setMainMenu() {
        wnd.setSoftLabel(Frame.SOFT_KEY_1 ,"P");
        wnd.setSoftLabel(Frame.SOFT_KEY_2 ,"");
    }
    public static void setInputMenu() {
        wnd.setSoftLabel(Frame.SOFT_KEY_1 ,"VP");
    }
    public static TextBox textBox;
    public static Panel input;
    /**
     * @param e
     */
    public static void printStackTrace(Exception e) {
        Console.current.print(e.getMessage()+"/"+e.toString());
    }
    //---- menu
    public static String[]menu;
    public static int menuColor;
    public static void showMenu(String[] m,int menuColor) {
        G.menuColor=menuColor;
        menu=m;
        redrawMenu();
    }
	public static void redrawMenu() {	
        try {
            lock();
            int bw=(sWidth/3),bh=yPitch;
            for (int i=0 ; i<12 ;i++) {
                int x=bw*(i%3);
                int y=(sHeight-bh*4)+(i/3)*bh;
                setColor(0,0,128) ;
                fillRect(x,y+2,bw,bh+1);
                setColor(255,255,255);
                if (i<menu.length && menu[i].length()>0) {
                   drawString(""+menu[i].substring(0),x+5,y+yPitch);
                }
            }
            unlock();
            //if (new G().instantCoffee!=null) println("a");
        } catch(UIException e) {
            e.printStackTrace();
        }
    }
    /**
     * 
     */
    public static void unlockForce() {
        gr.unlock(true);
    }
    
    public static void setColorPal(int n,int r,int g,int b) {
        colors.put(new Integer(n),new Integer(b*65536+g*256+r));
    }
}
