/*
 * Created on 2005/02/24
 *
 */
package ui;

import java.util.Enumeration;

import inter.Array;
import inter.BASICError;
import inter.Environment;
import inter.Interpreter;
import inter.StringTokenizer;
import inter.Variable;
import key.Dictionary;
import key.Key;
import key.KeyInput;
import util.Vector;

//ifndef applet
import com.nttdocomo.ui.Component;
import com.nttdocomo.ui.ComponentListener;
//endif applet
import com.nttdocomo.ui.Display;



/**
 * ʁiR\[j\܂B
 * 
 * @author hoge1000
 *
 */
public class Console extends G 
//ifndef applet
implements ComponentListener  
//endif applet
{
    /**
     * J[\xWł
     */
    public int x;
    /**
     * J[\̂Wł
     */
    public int y;
    //public int width=20;
    /**
     *@esɏꂽł
     */
    public String[] lines;
    /**
     *  s̍sƂȂĂ邩킵܂
     */
    public boolean[] connected;
    //public int fg,bg;
    /**
     * ݕ\ĂR\[ł
     */
    public static Console current;
    /**
     * inputɂ͑҂̏ꍇtrueɂȂ܂
     */
    public boolean inputMode=false;
    /**
     * inputɂ͑҂̏ꍇA͊Jnꏊ܂
     */
    public int inputX,inputY;
    /**
     * ̃R\[삷BASICł
     */
    public Environment env;
    /**
     * P̓[hɂȂĂꍇtrueł
     */
    public boolean imeMode=false;
    /**
     * s1sł
     */
    public static String BLANK_LINE;
    /**
     * R\[ׂ̕ď܂
     *
     */
    public void cls() {
        for (int i=0 ; i<lines.length ; i++) {
            lines[i]=BLANK_LINE;
            connected[i]=false;
        }
        y=0;x=0;
    }
    /**
     * R\[쐬܂B
     *
     */
    public Console() {
        BLANK_LINE="                                             "
            .substring(0,Display.getWidth()/6) ;
        current=this;
        //ifndef applet
        input.setComponentListener(this);
        //endif applet
        env=new Environment();
        lines=new String[sHeight/yPitch-4];
        connected=new boolean[lines.length];
        cls();
        y=0;x=0;
        print ("soyBasic Ver 0.1");
        print ("Copyright 2005 by Hoge- Ship");
        print ("Ok");
        funcKeys[FK_STMT]=stmtHeadDirect;
        keyPage=FK_STMT;
        showMenu(funcKeys[keyPage],200);
        initDict();
        //dispNonNumericKeys();
    }
    /**
     * P͂ɗp鎫܂BBASICŐ錾Ă
     * ϐ͎Iɒǉ܂B
     *
     */
    public void initDict() {
        dict=new Dictionary();
        dict.add("PRINT|?");
        dict.add("GOTO @:");
        dict.add("GOSUB @:");
        dict.add("CLS:");
        dict.add("DIM @():");
        dict.add("LIST @-");
        dict.add("INPUT @:");
        dict.add("AND @ ");
        dict.add("OR @ ");
        dict.add("IF @ THEN ");
        dict.add("RND(@)");
        dict.add("RETURN:");
        dict.add("LOCK:");
        dict.add("LOCATE @,:");
        dict.add("STEP ");
        dict.add("UNLOCK:");
        dict.add("GPRINT @:");
        dict.add("STRIG(@)");
        dict.add("COLOR=(@,,,):");
        dict.add("SEMICOLON|;");
        dict.add("REM|'");
        dict.add("SYNC @:");
        dict.add("TIME");
        dict.add("WIDTH");
        dict.add("HEIGHT");
        dict.add("MOD @ ");
        dict.add("ABS(@)");
        dict.add("LOAD\"@\"");
        dict.add("SAVE\"@\"");
    	Enumeration e=env.variables.keys();
    	while (e.hasMoreElements()) {
    	    Object name=e.nextElement();
    	    dict.add(""+name);
    	}
    }
    /**
     * ̍sĕ`悵܂
     * @param y ĕ`悷s̈ʒuB0ŏiiysڂĕ`悷j
     */
    public void draw(int y) {
        lock();
        setColor(255,255,255);
        fillRect(0,y*yPitch,sWidth,yPitch);
        setColor(0,0,0);
        drawString(lines[y],0,yPitch*y+yPitch);
        //if (lines[y].length()<BLANK_LINE.length()) println("CON:DRAW ??? "+y);
        unlock();
    }
    /**
     * ׂĂ̍sĕ`悵܂
     *
     */
    public void draw() {
        lock();
        setColor(255,255,255);
        fillRect(0,0,sWidth,yPitch*lines.length+3);
        setColor(0,0,0);
        for (int i=0 ; i<lines.length ; i++) {
            drawString(lines[i],0,yPitch*i+yPitch);
        }
        showCursor(0);
        unlock();
    }
    /**
     * ݑIĂt@NVL[̃y[Wԍł
     */
    int keyPage=2;
    public static final int 
      /**
       * gp
       */
       FK_EXPR=0,
      /**
       * ̓y[W
       */ 
       FK_NUM=0,
       /**
        * L̓y[W
        */
       FK_OPR=1,
       /**
        * ߓ̓y[WFReLXgɉstmtHeadProgstmtHeadDirect؂ւ܂
        */
       FK_STMT=2;
    public static final String CMDBS="[BS]",CMDSPC="[SPC]"
    ;
    /**
     * t@NVL[̓eꗗł
     */
    String [][]funcKeys={
/*            {
                "1", "RND(@)" ,"STICK(@)",
                "STRIG(@)","A" ,"I",
                "J" ,"X","Y",
                CMDBS,"(@)","\"@\""
            },*/

            {
                "1","2","3","4","5","6","7","8","9",CMDBS,"0","."
            },
            {
                "+","-","*",
                "/","=",">",
                "<","(@)",":",
                CMDBS,",","\"@\""
            },
            {   
            }
            
    };
    /**
     * vO[hReLXgɂt@NVL[̓e킵܂
     */
    String []stmtHeadProg= {
                "?@:","IF @ THEN ","GOTO @:"
                ,"?@;:","RETURN:","GOSUB @:"
                ,"FOR @= TO :","PSET(@,),:","LINE(@,)-(,),,BF:"
                ,CMDBS,CMDSPC,"NEXT:"    
            };
    /**
     * _CNg[hReLXgɂt@NVL[̓e킵܂
     */
    String []stmtHeadDirect= {
                "?@:","","GOTO @:"
                ,"LIST @-","RUN","GOSUB @:"
                ,"","LOAD\"@\"","SAVE\"@\""
                ,CMDBS,CMDSPC,""    
    };
    // expr, num ,  opr  , <non-direct-stmt , directstmt>
    /* (non-Javadoc)
     * @see key.in.CellarKeyListener#onKeyType(key.Key)
     */
    public void onKeyType(Key key) {
        if (imeMode) {
            onIMEKeyType(key);
            return ;
        }
        switch(key.keyCode) {
        case Display.KEY_UP:
            locate(x,y-1);
        	break;
        case Display.KEY_DOWN:
            locate(x,y+1);
        	break;
        case Display.KEY_LEFT:
            locate(x-1,y);
        	break;
        case Display.KEY_RIGHT:
            locate(x+1,y);
        	break;
        case Display.KEY_SOFT1:	
            startIME();
            break;
        case Display.KEY_SOFT2:
            keyPage=(keyPage+1) % funcKeys.length;
        	showMenu(funcKeys[keyPage],200);
            break;
        case Display.KEY_SELECT:
            exec();
        	break;
        default:
            int im=key.menuOffset;
            if (menu!=null && im>=0 &&
                im<menu.length && menu[im].length()>0) {
                insert(menu[im]);
            }            
        }
    }
    /**
     * P̓[hŗp鎫ł
     */
    Dictionary dict=new Dictionary();
    
    /**
     * ݂̃J[\ʒuɕ}܂
     *   
     * @param s }镶
     *     s=CMDBS̏ꍇAJ[\̂PO̕폜܂
     *     s"@"܂܂ꍇA}A@̏ꏊɃJ[\ړ܂B
     */
    public void insert(String s) {
        if (s.length()==0) return;
        if (s.equals(CMDSPC)) s=" ";
        if (s.equals(CMDBS)) {
            backSpace(x,y);
            if (x>0 || (y>0 && connected[y-1]) )
                locate(x-1,y);
            refreshContext();
        } else {
            //ifndef applet
            switch (s.charAt(s.length()-1)) {
            case '+':case '-':case '/':case '*':
            case '=':case '>':case '<':case '(':case ',':case '?':
                keyPage=FK_EXPR;
                showMenu(funcKeys[keyPage],170);
                break;
            default:
                int ctx=getContext();
            	if ((ctx & CTX_STMTHEAD)>0 || (ctx & CTX_DIRECT)>0) {
            	    Variable v=env. getVarWithoutCreation(s);
            	    if (v!=null) {
            	        if (v instanceof Array) {
            	            s=s+"(@)=:";
            	        } else {
            	            s=s+"=@:";
            	        }
            	        //addLRU(s);
            	    }
            	} else 
            	if ((ctx & CTX_EXPRHEAD)>0) {
            	    Variable v=env. getVarWithoutCreation(s);
            	    if (v instanceof Array) {
            	        s=s+"(@)";
            	    }
            	    //if (v!=null) addLRU(s);
            	}
            }
            //endif applet
            int insPnt=s.indexOf("@");
            if (insPnt>=0) {
                s=s.substring(0,insPnt)+s.substring(insPnt+1);
            } else {
                insPnt=s.length();
            }
            lines[y]=lines[y].substring(0,x)+
                     s+lines[y].substring(x,lines[y].length());
            checkLineInsertion(y);
            //lines[y]=lines[y].substring(0,orgLen);
            locate( x+insPnt,y);
            if (insPnt<s.length() || isAlpha(s.charAt(0)) || s.charAt(0)==':' ) {
                // ͂̍ۂ̓ReLXgXVȂ
                refreshContext();
            }
            
        }
    }
    /*private void addLRU(String s) {
        for (int i=0 ; i<9 ; i++) {
            if (funcKeys[FK_EXPR][i].equals(s)) return;
        }
        for (int i=8 ; i>0 ; i--) {
            funcKeys[FK_EXPR][i]=funcKeys[FK_EXPR][i-1];
        }
        funcKeys[FK_EXPR][0]=s;
    }*/
    /**
     * obNXy[Xi1폜j܂
     * @param x 폜ꏊ
     * @param y 폜ꏊ
     */
    private void backSpace(int x,int y) {
        while (true) {
            if (x==0 && y>0 && connected[y-1]) {
                lines[y-1]=lines[y-1].substring(0,lines[y-1].length()-1)
                          +lines[y  ].charAt(0);
                draw(y-1);
                lines[y  ]=lines[y  ].substring(1,lines[y  ].length());
            } else  if (x>0) {
                lines[y]=lines[y].substring(0,x-1)+lines[y].substring(x);
            } else {
                lines[y]=lines[y].substring(1);
            }
            lines[y]+=" ";
            if (!connected[y]) {
                draw(y);
                return;
            }
            x=0;y++;
        }
    }
    /**
     * s݂͂
     * iw肳ꂽs̍s𒴂ꍇA̍sɁA
     * ݂͂}j܂
     * 
     * @param y s݂͂s
     */
    private void checkLineInsertion(int y) {
        while (true) {
            String hmd=lines[y].substring(BLANK_LINE.length());
            lines[y]=lines[y].substring(0,BLANK_LINE.length());
            draw(y);
            if (!connected[y]) {
                if (chomp(hmd,false).length()>0 || 
                        lines[y].charAt((lines[y]).length()-1)!=' ') {
                    connected[y]=true;
                    if (y<lines.length-1) {
                        for (int j=lines.length-1; j>y+1 ; j--) {
                            lines[j]=lines[j-1];
                            connected[j]=connected[j-1];
                        }
                        lines[y+1]=(hmd+BLANK_LINE).substring(0,BLANK_LINE.length());
                        connected[y+1]=false;
                        draw();
                    } else {
                        scroll();
                        lines[y]=(hmd+BLANK_LINE).substring(0,BLANK_LINE.length());
                    }
                }
                return;
            }
            y++;
            lines[y]=(hmd+lines[y]);
        }
    }
    /**
     * pǂf܂
     * @param c f镶
     * @return cpȂtrue
     */
    private boolean isAlpha(char c) {
        return (c>='A' && c<='Z') || (c>='a' && c<='z');
    }
    /**
     * J[\\sꍇtrueł
     */
    public boolean showCursor=true;
    /**
     * J[\w肳ꂽꏊɈړ܂B
     * @param x ꏊ
     * @param y ꏊ
     */
    public void locate(int x,int y) {
        if (showCursor) {
            //println(x+","+y);
            showCursor(255);
        }
        if (x<0) {
            if (y<=0) x=0;
            else {
                y=y-1;
                x=lines[y].length()-1;
            }
        }
        if (y<0) y=0;
        if (y>=lines.length) {
            y=lines.length-1;
            scroll();
        }
        if (x>=lines[y].length()) {
            if (y<lines.length-1) {
                x=0;
                y++;
            } else {
                x=lines[y].length()-1;
            }
        }
        this.x=x;
        this.y=y;
        if (showCursor) showCursor(0);
    }
    /**
     *@1sXN[܂
     */
    private void scroll() {
        for (int i=1 ; i<lines.length ; i++) {
            lines[i-1]=lines[i];
            connected[i-1]=connected[i];
        }
        lines[lines.length-1]=BLANK_LINE;
        connected[lines.length-1]=false;
        draw();
    }
    /**
     * J[\̕\ݒs܂
     * @param col F 255:\ 0F\
     */
    private void showCursor(int col) {
        int px=xPixel(x,y);
        int py=yPixel(y);
        int w=cWidth(x,y);
        setColor(col,col,255);
        fillRect(px,py+yPitch,w,2);
    }
    /**
     * w肳ꂽs̎w肳ꂽ̕Ԃ܂
     * @param curX CfbNX
     * @param curY s
     * @return cugYsځAcurXڂ̕̕
     */
    private int cWidth(int curX,int curY) {
        return stringWidth( lines[curY].substring(curX,curX+1));
    }
    /**
     * w肳ꂽs̏[̃sNZԂ܂
     * @param curY s
     * @return cugYsڂ̏[̃sNZԂ܂
     */
    public int yPixel(int curY) {
        return curY*yPitch;
    }
    /**
     * w肳ꂽs̎w肳ꂽꏊ́A[̃sNZԂ܂
     * @param curX CfbNX
     * @param curY s
     * @return cugYsځAcurXڂ\Ăꏊ́A[̃sNZ
     */
    public int xPixel(int curX,int curY) {
        return stringWidth(lines[curY].substring(0,curX));
    }
    /**
     * L[ꂽƂA̎svOs̍XVs܂
     *
     */
    public void exec() {
        Interpreter i=null;
        try {
            showCursor(255);
            showCursor=false;
            while (y>0 && connected[y-1]) y--;
            String inp=lines[y];
            while (y<lines.length-1 && connected[y]) {
                y++;
                inp+=lines[y];
            }
            int nextY=y+1;
            if (inputMode) {
                // input̓͂Ƃ̏
                if (inputY==y) {
                    inp=inp.substring(inputX);
                }
                inp=chomp(inp,false);
                //println("inp = "+inp);
                EventLoop.instance.aborter=inp;
                inputMode=false;
                locate(0,nextY);
                return;
            }
            String chompL=chomp(inp,true);
            if (chompL.length()==0) {
                locate(0,nextY);
                showCursor=true;
                showCursor(0);
                return;
            }
            StringTokenizer token=new StringTokenizer(chompL);
            int s=token.savePoint();
            String ln=token.nextToken();
            if (token.tokenType()==StringTokenizer.TNUM) {
                //@擪sԍ̂Ƃ
                showCursor=true;
                locate(0,nextY);
                env.addLine(Integer.parseInt(ln),
                        chomp(token.restString(),true) );
                return;
            }
            // _CNg[h
            token.restorePoint(s);
            
            i=new Interpreter(token,env);
            locate(0,nextY);
            i.parseStatements();
            
            //i.dispCode();
            i.exe(i.code,0);
        } catch (Exception e) {
            //ifndef applet
            /*
            //endif applet
            G.waitInput=true; 
            //ifndef applet
            */
            //endif applet
            unlockForce();
            if (i!=null && i.curLine!=null) {
                print(e+" in "+i.curLine.lineNo);
            } else {
                print(e+"");
            }
           //e.printStackTrace();
        }
        showCursor=true;
        print("Ok");
    }
    public void print(String s) {
        print(s,true);
    }
    /**
     * ݂̃J[\ʒuɕ㏑܂BJ[\͎̍sɈړ܂
     * @param s ㏑镶
     */
    public void print(String s,boolean br) {
        while (true) {
            if (s.length()+x<BLANK_LINE.length()) {
                lines[y]=lines[y].substring(0,x)+
                     s+lines[y].substring(x+s.length());
                draw(y);
                if (br) locate( 0,y+1);
                else locate(x+s.length(),y);
                return;
            }
            connected[y]=true;
            lines[y]=lines[y].substring(0,x)+s;
            s=lines[y].substring(BLANK_LINE.length());
            lines[y]=lines[y].substring(0,BLANK_LINE.length());
            draw(y);
            locate(0,y+1);
        }
        
    }	
    /**
     * Oォ󔒂菜܂B:菜܂
     * @param s 
     * @param trailSemicolon :菜ꍇtrue
     * @return 菜ꂽ
     */
    public static String chomp(String s,boolean trailSemicolon) {
        int b;
        for (b=0 ; b<s.length();b++) {
            if (s.charAt(b)!=' ') break;
        }
        if (b==s.length()) return "";
        int e;
        for (e=s.length()-1; e>b ; e--) {
            if (!( 
              s.charAt(e)==' ' || (trailSemicolon && s.charAt(e)==':')
            )) break;
        }
        return s.substring(b,e+1);
    }
    public static final int
      CTX_EXPRHEAD=1,CTX_EXPRTAIL=2,
      CTX_STMTHEAD=4,CTX_STMTTAIL=8,
      CTX_DIRECT=16,CTX_LINENO=32;
    /**
     * J[\ʒũReLXg𔻕ʂ܂B
     *  
     * @return ̂ꂼ̃tO̘_a<BR>
     * CTX_EXPRHEAD ̐擪<BR>
     * CTX_EXPRTAIL ̐擪<BR>
     * CTX_STMTHEAD ̐擪<BR>
     * CTX_STMTTAIL ̐擪<BR>
     * CTX_DIRECT _CNg[h̐̕擪<BR>
     * CTX_LINENO GOTO,GOSUB̒<BR>
     */
    public int getContext() {
        //println ("CTX...");
        //if (x==0) return CTX_DIRECT;
        //int xx=x-1;
        StringBuffer sb=new StringBuffer();
        int yy=y;
        do {
            sb.insert(0,lines[yy]);
            yy--;
        } while (yy>=0 && connected[yy]);
        String s= chomp(sb.toString().toUpperCase()
                .substring(0,x+(y-yy-1)*BLANK_LINE.length()),false);
        int xx=s.length()-1;
        if (xx<0) return CTX_DIRECT;
        //chkBounds(s,xx,"A");
        //println("XXA="+xx+"!"+s.length());
        char t=s.charAt(xx);
        //int tx=xx+1;
        String before;
        
        int beforeType;
        //if (t>='a' && t<='z') t+='A'-'a';
        // before ɒÕg[N
        //println("XXB="+xx+s.length());
        if ( (t>='A' && t<='Z') || (t>='0' && t<='9') || t=='.') {
            //println("XXC="+xx+s.length());
            //          ʎq܂͐l擾
            while (xx>=0) {
                t=s.charAt(xx);
                if (!( (t>='A' && t<='Z')
                     || (t>='0' && t<='9') 
                     || t=='.'
                )) {
                    break;
                }
                xx--;
            }
            xx++;
            //println("XXD="+xx+s.length());
            //chkBounds(s,xx,"B");
            t=s.charAt(xx);
            beforeType=( (t>='A' && t<='Z') ? StringTokenizer.TVARNAME : StringTokenizer.TNUM);
            //chkBounds(s,xx,"C");
            //println("XXE="+xx+s.length());
            before=s.substring(xx);
            if (xx==0 && beforeType==StringTokenizer.TNUM) 
                return CTX_STMTHEAD;
        } else {
            // L擾
            before=t+"";
            beforeType=StringTokenizer.TDELIM;
        }
        switch (beforeType) {
        case StringTokenizer.TDELIM:
            switch (before.charAt(0)) {
            case '+':case '-':case '/':case '*':
            case '=':case '>':case '<':case '(':case ',':case '?':
                return CTX_EXPRHEAD;
            case ')':
                return CTX_EXPRTAIL | CTX_STMTTAIL;
            case ':':
                return CTX_STMTHEAD;
            }
        case StringTokenizer.TVARNAME:
        case StringTokenizer.TNUM:
            if (before.equals("GOTO") || before.equals("GOSUB")|| before.equals("LIST")) {
                //println("GOTO!!");
                return CTX_LINENO;
                
            }
            if (before.equals("IF") || before.equals("TO") 
                    || before.equals("AND") || before.equals("OR")
                    || before.equals("SYNC") || before.equals("LOCATE")) 
                 return CTX_EXPRHEAD;
            if (before.equals("THEN")) return CTX_STMTHEAD;
            return CTX_EXPRTAIL | CTX_STMTTAIL;
        }
    	return CTX_STMTHEAD;
    }
    /*
     * @param s
     * @param xx
     * @param string
     *
    private void chkBounds(String s,int xx,String string) {
        if (xx<0 || xx>=s.length()) {
            println("STRERRR! ["+string+"] " + s +"//"+xx );
        }
    }*/
    /**
     * INPUTɂ͑҂Jn܂
     */
    public void startInput() {
        EventLoop.instance.clear();
        showCursor=true;
        insert("? ");
        inputMode=true;
        inputX=x;inputY=y;
    }
    /* (non-Javadoc)
     * @see key.in.CellarKeyListener#onKeyRelease(key.Key)
     */
    public void onKeyRelease(Key key) {
        if (imeMode) return;
        switch (key.keyCode) {
        case Display.KEY_LEFT:
        case Display.KEY_RIGHT:
        case Display.KEY_UP:
        case Display.KEY_DOWN:
            refreshContext();
        	break;
        }
    }
    /**
     * ݂̃J[\ʒũReLXgɂƂÂAt@NVL[̃y[W؂ւ܂
     *
     */
    public void refreshContext() {
        int ctx=getContext();
        if ((ctx & CTX_EXPRTAIL)>0) {
            keyPage=FK_OPR;
            showMenu(funcKeys[keyPage],150);
        }
        if ((ctx & CTX_DIRECT)>0) {
            funcKeys[FK_STMT]=stmtHeadDirect;
            keyPage=FK_STMT;
            showMenu(funcKeys[keyPage],100);
        } else
        if ((ctx & CTX_STMTHEAD)>0) {
            funcKeys[FK_STMT]=stmtHeadProg;
            keyPage=FK_STMT;
            showMenu(funcKeys[keyPage],100);
        }
        if ((ctx & CTX_EXPRHEAD)>0) {
            keyPage=FK_EXPR;
            showMenu(funcKeys[keyPage],170);
        }
        if ((ctx & CTX_LINENO)>0) {
            keyPage=FK_NUM;
            showMenu(funcKeys[keyPage],170);
        }
        
        
    }
    
    //------ IME ----------------------
    /**
     * IME(P̓[h)Jn܂
     */
    public void startIME() {
        candidates=new Vector();
        in=new KeyInput();
        drawCandidates();
        imeMode=true;
        setInputMenu();
    }
    /**
     * IMENA͂ꂽL[̗ł
     */
    KeyInput in;
    /**
     * ⊮ł
     */
    Vector candidates;
    //String decidedWord;
    /**
     * \ۂ1₠̕ł
     */
    public static int IMEw;
    /**
     * ⊮ׂĕ`悵܂
     *
     */
    public void drawCandidates() {
        IMEw=sWidth/2;
        setColor(0,0,0);
        fillRect(0,sHeight-yPitch*4,sWidth,yPitch*4);
        candidates=dict.getSetStartsWith(in);
        int yMax=candidates.size();
        if (IMEy>=yMax) IMEy=yMax-1;
        for (int i=0 ; i<candidates.size() ; i++ ) {
            drawCandidate(i);
        }
    }
    /**
     * ⊮`悵܂
     * @param idx ⊮̃CfbNX
     */
    void drawCandidate(int idx) {
        if (idx<0) return;
        int x=idx/4*IMEw+5,
            y=sHeight-yPitch*4+ idx%4*yPitch;
        String e = (String) candidates.get(idx);
        int col=(idx==IMEy ? 255 : 0);
        setColor(col,col,col);
        fillRect(x,y,IMEw,yPitch);
        setColor(255-col,255-col,255-col);
        drawString(e,x,y+yPitch);
    }
    /**
     * Cӂ͂̕郂[hiCӓ̓[hjɈڍsۂ
     * p镶ł
     */
    public static final String DIRECT="__DIRECTINPUT";

    /**
     * IMENɃL[͂ƂɌĂ΂܂
     * @param key ͂ꂽL[
     */
    public void onIMEKeyType(Key key) {
        //println("IME:onKeyType");
        moveY(0);
        switch (key.keyCode) {
        case Display.KEY_SOFT1:	
            candidates.insertElementAt(DIRECT,0);
        	IMEy=0;
            endIME();
            return;
        case Display.KEY_POUND:
        case Display.KEY_SELECT:
            endIME();
            return;
        case Display.KEY_ASTERISK:
        case Display.KEY_LEFT:
            in.removeLast();
            drawCandidates();
            return;
        case Display.KEY_DOWN:
            moveY(1);
        	break;
        case Display.KEY_UP:
            moveY(-1);
        	break;
        case Display.KEY_RIGHT:
            moveY(4);
        	break;
        }
        if (key.representChar()==0) return;
        in.add(key);
        drawCandidates();
    }
    /**
     * ⊮IJ[\̃CfbNXł
     */
    int IMEy=0;
    /**
     * ⊮IJ[\ړ܂B
     * @param o ړ
     */
    private void moveY(int o) {
        int yMax=candidates.size();
        if (yMax==0) return;
        if (yMax>=8) yMax=8;
        //println ("IMEy "+IMEy);
        int old=IMEy;
        IMEy=(IMEy+o+yMax)%yMax;
        drawCandidate(old);
        //println ("IMEy2 "+IMEy);
        drawCandidate(IMEy);
    }
    /**
     * IME̓͂܂
     */
    public void endIME() {
        setMainMenu();
        imeMode=false;
        showMenu(funcKeys[keyPage],255);
        if (candidates.size()>0) {
            String s=candidates.get(IMEy).toString();
            if (s.equals(DIRECT)) {
                // Cӂ͂̕郂[hiCӓ̓[hjɈڍs
                doInput();
                return;
            }
            clearAllScreen();
            draw();
            int i=s.indexOf("|");
            if (i>=0) {
                s=s.substring(i+1);
            }
            insert(s);
            redrawMenu();
        }
    }
    //ifndef applet
    /* (non-Javadoc)
     * @see com.nttdocomo.ui.ComponentListener#componentAction(com.nttdocomo.ui.Component, int, int)
     */
    public void componentAction(Component c,int arg1,int arg2) {
        Display.setCurrent(G.wnd);
        String s=G.textBox.getText();
        draw();
        insert(s);
        redrawMenu();
        if (s.length()>0) dict.add(s);
    }
    //endif applet
    /**
     * Cӓ̓[h̃eLXgGfB^J܂B
     * 
     */
    public static void doInput() {
        //ifndef applet
        EventLoop.pressedKey=-1;
        Display.setCurrent(input);
        //endif applet
    }
}
