/*
 * Created on 2005/02/26
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package inter;

import java.util.Hashtable;
import java.util.Random;

import com.nttdocomo.ui.Display;

import ui.Console;
import ui.EventLoop;
import ui.G;
import ui.ICWindow;
import util.Vector;

/**
 *
 * BASICC^v^łB
 * BASICeLXg̒ԃR[h̐ƁAԃR[h̎ss܂B
 *@<a href="http://soybasic.sourceforge.jp/cgi-bin/mini.cgi?page=vmspec">ԃR[h̎dl</a>
 *  
 *<pre>
 * @F
 * vO[hs := sԍ 
 * _CNg[hs := 
 *  :=  { ':' }
 *  :=  | ̑̕iej
 * (let) := ϐ '=' 
 * (expr) := ea { 'or' ea }
 * ea   := cmp { 'and' cmp}
 * cmp  := add [ ('>' | '<' | '>=' | '<=' | '=' | '<>') add ]   
 * add  := mul { ('+' | '-') mul }
 * mul  := una { ('*' | '/') una }
 * una  := [ '+' | '-' ] pow
 * pow  := elem { '^' elem }
 * elem := l萔 | 萔 | '('  ')' | ϐ
 * ϐ(var)  := ϐ [ '('  { ,  }  ')' ] 
 * </pre>
 * <BR>
 * 萔A啶Ə͋ʂ܂
 * 
 * @author hoge1000
 */

public class Interpreter {
    /**
     * ԃR[hIntegerIuWFNgŁAlOPOFS`OPOFS+opmax-1 ̂̂
     * ߂Ƃ݂Ȃ܂BȊO̒ԃR[h̃IuWFNǵAX^bNɐςݏグ܂B
     * (opmax͖߃R[h̍ől)
     */
    public static final int OPOFS=-(1<<31);
    /**
     * ߃R[hłB
     */
    public static final int 
      ADD=1,
      SUB=2,
      MUL=3,
      DIV=4,
      ARRAY=5,
      ILET=6,
      GOTO=7,
      GOSUB=8,
      END0=9,
      GT=10,
      LT=11,
      GE=12,
      LE=13,
      NE=14,
      EQ=15,
      INPUT=16,
      IPRINT=17,
      LIST=18,
      LOAD=19,
      SAVE=20,
      RETURN=21,
      NEG=22,
      NOT=23,
      CLS=24,
      IDEREF=25,
      POW=ADD,  //TODO:
      OR=27,  
      AND=28, 
      STRCAT=29,
      SLET=30,
      STRCMP=31,
      RND=32,
      STRIG=33,
      PSET=34,
      LINE=35,
      FOR=36, 
      NEXT=37, 
      LOCK=38,
      UNLOCK=39,
      GIPRINT=40,
      COLORPAL=41,
      PRINTLN=42,
      SDEREF=43,
      GSPRINT=44,
      SPRINT=45,
      TIME=46,
      SYNC=47,
      LOCATE=48,
      WIDTH=49,
      HEIGHT=50,
      STOPOFF=51,
      ABS=52,
      MOD=53
      ;

    /**
     *  C^v^쐬܂B
     *
     * @param tokenizer seLXg玚؂o߂Tokenizerw肵܂
     * @param env ̃C^v^ssw肵܂B
     */
    public Interpreter(StringTokenizer tokenizer,Environment env) {
        token=tokenizer;
        this.env=env;
        if (compares==null) {
            compares=new Hashtable();
            compares.put(">=",new Integer(GE));
            compares.put("<=",new Integer(LE));
            compares.put(">" ,new Integer(GT));
            compares.put("<" ,new Integer(LT));
            compares.put("<>",new Integer(NE));
            compares.put("=",new Integer(EQ));
            int1ParamFuncs=new Hashtable();
            int1ParamFuncs.put("RND",new Integer(RND));
            int1ParamFuncs.put("STRIG",new Integer(STRIG));
            int1ParamFuncs.put("ABS",new Integer(ABS));
        }
    }
    /**
     * ݉͂ĂsłB_CNg[h̏ꍇnullł
     */
    ProgLine progLine;
    /**
     * @param tokenizer
     * @param environment
     * @param p
     */
    public Interpreter(StringTokenizer tokenizer,Environment environment,ProgLine p) {
        this(tokenizer,environment);
        this.progLine=p;
    }
    /**
     * 
     */
    public static Hashtable compares=null;
    public static Hashtable int1ParamFuncs=null;

    /**
     * RpC̒ԃR[hł
     */
    public Vector code=new Vector();
    /**
     * X^bNɃIuWFNgςނ߂̃R[hǉ܂B
     * @param o
     */
    public void addPush(Object o) {
        code.add(o);
    }
    /**
     * ZpR[hǉ܂
     * @param i R[hԍ
     */
    public void addOpr(int i) {
        code.add(new Integer(i+OPOFS));
    }
    /**
     * truȅꍇA0L[ŃvO~܂B
     */
    public boolean stopOn=true;
    /**
     * ݎs̍słB
     */
    public ProgLine curLine;
    /**
     * GOTOɂw肳ꂽɎsׂsłB
     * inullłB
     */
    public ProgLine sigGoto;
    /**
     * NEXTɂw肳ꂽA߂ׂFOR킵܂B
     * inullł
     */
    public ForContext sigNext;
    /**
     * RETURNstrueɂȂÃ݂Tu[`I܂
     */
    boolean sigReturn;
    /**
     * parseExprɂĉ͂ꂽ̐\i[܂B
     * 
     */
    //public int eInt;
    /**
     * parseExprɂĉ͂ꂽ\i[܂B
     */
    //public String eString;
    /**
     * seLXg玚؂o߂̃IuWFNgłB
     */
    StringTokenizer token;
    /**
     * ̃C^v^ssłB
     */
    Environment env;
    public static final int TINT=2,TSTRING=3,TSINGLE=4,TDOUBLE=8,TNONE=0;
    /**
     * ͂܂B
     * expr = ea { or ea }
     * 
     * @return  ͂̌^@TINT:   TSTRING: 
     * 
     */
    public int parseExpr() {
        //G.println("INTER expr ");
        int ty=parseEA();
        while (true) {
            //int s=token.savePoint();
            if (token.nextTokenIf("OR")) { 
                if (parseEA()!=TINT) error("TM");
                addOpr(OR);
                ty=TINT;
            } else {
                //token.restorePoint(s);
                return ty;
            }
        }
    }
    /**
     * EA͂܂B
     * EA = cmp { and cmp}
     * 
     * @return  ͂̌^@TINT:   TSTRING: 
     * 
     */
    public int parseEA() {
        //G.println("INTER ea ");
        int ty=parseCmp();
        while (true) {
            if (token.nextTokenIf("AND")) { 
                if (parseCmp()!=TINT) error("TM");
                addOpr(AND);
                ty=TINT;
            } else {
                //token.restorePoint(s);
                return ty;
            }
        }
    }
    /**
     * Cmp͂܂B
     * Cmp = add [ (> < >= <= = <>) add ]   
     * 
     * @return  ͂̌^@TINT:   TSTRING: 
     * 
     */
    public int parseCmp() {
        //G.println("INTER cmp ");
        int ty=parseAdd();
        int s=token.savePoint();
        String n=token.nextToken();
        Integer op=(Integer)compares.get(n);
        if (op!=null) {
            int ty2=parseAdd();
            if (!(ty==TINT && ty2==TINT)) {
                if (!(ty==TSTRING && ty2==TSTRING)) error("TM");
                addOpr(STRCMP);
                addPush(new Integer(0));
            }
            addOpr(op.intValue());
            return TINT;
        }
        token.restorePoint(s);
        return ty;
    }
    
    /**
     * Add͂܂B
     * Add =  mul { (+  -) mul }
     * 
     * @return  ͂̌^@TINT:   TSTRING: 
     * 
     */
    public int parseAdd() {
        //G.println("INTER add ");
        int ty=parseMul();
        while (true) {
            if (token.nextTokenIf("+")) { 
                int ty2=parseMul();
                if (ty==TINT && ty2==TINT) {
                    addOpr(ADD);
                    ty=TINT;
                } else if (ty==TSTRING && ty2==TSTRING	) {
                    addOpr(STRCAT);
                    ty=TSTRING;
                } else error("TM");
            } else if (token.nextTokenIf("-")) { 
                if (ty!=TINT ||
                      parseMul()!=TINT) error("TM");
                addOpr(SUB);
                ty=TINT;
            } else {
                //token.restorePoint(s);
                return ty;
            }
        }
    }
    
    /**
     * Mul͂܂B
     * Mul = una { (*  /) una }
     * 
     * @return  ͂̌^@TINT:   TSTRING: 
     * 
     */
    public int parseMul() {
        //G.println("INTER mul ");
        int ty=parseUna();
        while (true) {
            if (token.nextTokenIf("*")) { 
                if (parseUna()!=TINT) error("TM");
                addOpr(MUL);
                ty=TINT;
            } else if (token.nextTokenIf("/")) { 
                if (parseUna()!=TINT) error("TM");
                addOpr(DIV);
                ty=TINT;
            } else if (token.nextTokenIf("MOD")) { 
                if (parseUna()!=TINT) error("TM");
                addOpr(MOD);
                ty=TINT;
            } else {
                //token.restorePoint(s);
                return ty;
            }
        }
    }
    
    /**
     * Una ͂܂B
     * una  = [ + - ] pow
     * @return
     */
    private int parseUna() {
        //G.println("INTER una ");
        //String n=token.nextToken();
        boolean neg=false;
        if (token.nextTokenIf("-")) {
            neg=true;
        }/* else {
            token.restorePoint(s);
        }*/
        int ty=parsePow();
        if (neg) {
            if (ty==TINT) {
                addOpr(NEG);
            } else error("TM");
        }
        return ty;
    }
    /**
     * Pow͂܂B
     * Pow = elem { ^ elem }
     * 
     * @return  ͂̌^@TINT:   TSTRING: 
     * 
     */
    public int parsePow() {
        //G.println("INTER pow ");
        int ty=parseElem();
        while (true) {
            if (token.nextTokenIf("^")) { 
                if (parseElem()!=TINT) error("TM");
                addOpr(POW);
                /*int t=eInt;
                eInt=1;
                for (int i=0 ; i<t ; i++) {
                    eInt *= se ; 
                }*/
                ty=TINT;
            } else {
                //token.restorePoint(s);
                return ty;
            }
        }
    }

    /**
     *  Elemi萔Aϐj͂܂
     * @return
     */
    private int parseElem() {
        String t=token.nextToken();
        //G.println("INTER elem <"+t+"> type="+token.tokenType());
        switch (token.tokenType()) {
        case StringTokenizer.TNUM:
            // l̏ꍇ
            addPush( new Integer(Integer.parseInt(t)) );
            //G.println("INTER eInt="+eInt);
            return TINT;
        case StringTokenizer.TVARNAME:
            Integer op=(Integer)int1ParamFuncs.get(t);
        	if (op!=null) {
        	    errorUnless("(");
                parseExpr();
        	    errorUnless(")");
                addOpr(op.intValue());
                return TINT;
            }
        	if (t.equals("TIME")) {
        	    addOpr(TIME);
        	    return TINT;
        	}
        	if (t.equals("WIDTH")) {
        	    addOpr(WIDTH);
        	    return TINT;
        	}
        	if (t.equals("HEIGHT")) {
        	    addOpr(HEIGHT);
        	    return TINT;
        	}
            switch (parseVar(t)) {
            case TINT:
                addOpr(IDEREF);
                return TINT;
            case TSTRING:
                addOpr(SDEREF);
                return TSTRING;
            }
        case StringTokenizer.TSTRING:
            addPush(t);
        	return TSTRING;
        case StringTokenizer.TDELIM:
            if (t.equals("(")) {
                int ty=parseExpr();
                errorUnless(")");
                return ty;
            }
            break;
        }
        error("MO");
        return TNONE;
    }
    /**
     * ϐ͂܂B
     * token@͎̏ꏊwĂ̂Ƃ܂
     * 
     * A(5)
     *  ^
     *  (varName="A")
     * 
     * B
     *  ^
     *  (varName="B")
     * 
     * @param varName ϐBtoken͂łɂ̕ϐ̃g[NoA̒̃g[NwĂKv
     * ͂ꂽϐX^bNɐςނ悤Ȗ߂𐶐܂
     */
    private int parseVar(String varName) {
        Variable v=env.getVar(varName);
        if (token.nextTokenIf("(")) {
            // z/֐
            if (v instanceof Array) {
                Array ar=(Array) v;
                addPush(ar);
                if (parseExpr()!=TINT) error("TM");
                addOpr(ARRAY);
                errorUnless(")");
                
                switch (ar.type) {
                case Variable.T_INT: return TINT;
                case Variable.T_STRING: return TSTRING;
                }
            }
        } else {
            // Pϐ
            //token.restorePoint(s);
            addPush(v);
            if (v instanceof IntVariable) return TINT;
            if (v instanceof StringVariable) return TSTRING;
        }
        error("TM");return 0;
    }
    /**
     * ͂܂
     * 
     * @throws BASICError @^Ă?SN Error, ?MO Error, ?TM ErrorɂȂ܂
     * 
     */
    public void parseStatement() throws BASICError {
        String s=token.nextToken();
        if (s.equals("?")) {
            while (true) {
                switch (parseExpr()) {
                case TINT:addOpr(IPRINT);break;
                case TSTRING:addOpr(SPRINT);break;
                default :error("TM");
                }
                int p=token.savePoint();
                String st=token.nextToken();
                if (st.equals("") || st.equals(":")) {
                    token.restorePoint(p);
                    addOpr(PRINTLN);
                    break;
                } else if (st.equals(";")) {
                    int p2=token.savePoint();
                    String n=token.nextToken();
                    token.restorePoint(p2);
                    if (n.equals("") || n.equals(":")) {
                        break;
                    }
                } else {
                    token.restorePoint(p);
                }
            }
        } else if (s.equals("LOCATE")) {
            if (parseExpr()!=TINT) error("TM");
            errorUnless(",");
            if (parseExpr()!=TINT) error("TM");
            addOpr(LOCATE);
        } else if (s.equals("CLS")) {
            addOpr(CLS);
        } else if (s.equals("RUN")) {
            System.gc();
            stopOn=true;
            sp=0;
            //ifndef applet
            /*          
            //endif applet
            G.waitInput=false;
            //ifndef applet
             */
            //endif applet
            gosub(env.first);
            //ifndef applet
            /*          
            //endif applet
            G.waitInput=true;
            //ifndef applet
             */
            //endif applet
            EventLoop.instance.clear();
        } else if (s.equals("GOTO")) {
            parseGoto();
        } else if (s.equals("GOSUB")) {
            parseGosub();
        } else if (s.equals("RETURN")) {
            parseReturn();
        } else if (s.equals("LIST")) {
            parseList();
        } else if (s.equals("IF")) {
            parseIf();
        } else if (s.equals("SAVE")) {
            parseSave();
        } else if (s.equals("LOAD")) {
            parseLoad();
        } else if (s.equals("INPUT")) {
            parseInput();
        } else if (s.equals("DIM")) {
            parseDim();
        } else if (s.equals("PSET")) {
            parsePset();
        } else if (s.equals("LINE")) {
            parseLine();
        } else if (s.equals("GPRINT")) {
            parseGPrint();
        } else if (s.equals("FOR")) {
            parseFor();
        } else if (s.equals("LOCK")) {
            addOpr(LOCK);
        } else if (s.equals("NEXT")) {
            addOpr(NEXT);
        } else if (s.equals("UNLOCK")) {
            addOpr(UNLOCK);
        } else if (s.equals("COLOR")) {
            parseColor();
        } else if (s.equals("SYNC")) {
            parseExpr();
            addOpr(SYNC);
        } else if (s.equals("STOP")) {
            if (token.nextTokenIf("OFF")) {
                addOpr(STOPOFF);	
            } else error("SN");
        } else if (s.equals("REM")) {
        } else if (token.tokenType()==StringTokenizer.TVARNAME)  {
            parseLet(s);
        } else {
            error("SN");
        }
    }
    /**
     * COLOR͂܂
     */
    private void parseColor() {
        errorUnless("=");
        errorUnless("(");
        parseExpr();
        errorUnless(",");
        parseExpr();
        errorUnless(",");
        parseExpr();
        errorUnless(",");
        parseExpr();
        errorUnless(")");
        addOpr(COLORPAL);
    }
    /**
     * FOR͂܂
     */
    private void parseFor() {
        String t=errorUnless(StringTokenizer.TVARNAME);
        Variable v=env.getVar(t);
        if (!(v instanceof IntVariable)) error("TM");
        addPush(v);
        errorUnless("=");
        if (parseExpr()!=TINT) error("TM");
        addOpr(ILET);
        errorUnless("TO");

        ForContext fc=new ForContext();
        addPush(fc); // --- FOR1p^(ForContext)

        parseExpr(); // --- FOR2p^(Il)
        if (token.nextTokenIf("STEP")) {
            parseExpr();  // --- FOR3p^()
        } else {
            addPush(new Integer(1)); // --- FOR3p^()
        }
        addOpr(FOR);
        fc.loop=(IntVariable)v;
        fc.line=progLine;
        fc.offset=code.size();
        //TODO: CX^Xϐg悤ɂȂAvFORւ̈Ƃ
    }
    /**
     * PSET͂܂
     */
    private void parsePset() {
        errorUnless("(");
        parseExpr();
        errorUnless(",");
        parseExpr();
        errorUnless(")");
        if (token.nextTokenIf(",")) {
            parseExpr();
        } else {
            addPush(new Integer(DEFCOL));
        }
        addOpr(PSET);
    }
    /**
     * LINEŎg萔ł
     */
    public static final int LINENORM=0,LINEB=1,LINEBF=2,DEFCOL=-1;
    /**
     * LINE͂܂
     */
    private void parseLine() {
        int mode=LINENORM;
        int step=0;
        String t="";
        if (token.nextTokenIf("(")) {
            parseExpr();
            errorUnless(",");
            parseExpr();
            errorUnless(")");
            addPush(new Integer(DEFCOL));
            addOpr(PSET);
        }
        errorUnless("-");
        if (token.nextTokenIf("STEP")) {
            step=1;
        }
        addPush(new Integer(step));
        errorUnless("(");
        parseExpr();
        errorUnless(",");
        parseExpr();
        errorUnless(")");
        if (token.nextTokenIf(",")) {
            if (token.nextTokenIf(",")) {
                // LINE -(x,y),,B[F]
                addPush(new Integer(DEFCOL)); //default color
                t=token.nextToken();    // B[F]
            } else {
                parseExpr(); // color
                if (token.nextTokenIf(",")) {
                    // LINE -(x,y),C,B[F]
                    t=token.nextToken(); // B[F]
                }// else LINE -(x,y),C
            }
        } else {
            // LINE -(x,y)
            addPush(new Integer(DEFCOL));
        }
        if (t.equals("BF")) mode=LINEBF;
        if (t.equals("B")) mode=LINEB;
        addPush(new Integer(mode));
        addOpr(LINE);
    }
    /**
     * GPRINT͂܂
     *
     */
    private void parseGPrint() {
        while (true) {
            switch (parseExpr()) {
            case TINT:addOpr(GIPRINT);break;
            case TSTRING:addOpr(GSPRINT);break;
            default :error("TM");
            }
            int p=token.savePoint();
            String st=token.nextToken();
            if (st.equals("") || st.equals(":")) {
                token.restorePoint(p);
                break;
            } else if (st.equals(";")) {
                int p2=token.savePoint();
                String n=token.nextToken();
                token.restorePoint(p2);
                if (n.equals("") || n.equals(":")) {
                    break;
                }
            } else {
                token.restorePoint(p);
            }
        }

    }
    /**
     * DIM͂܂
     * 
     * @throws BASICError
     * 
     */
    private void parseDim() throws BASICError {
        String varName=errorUnless(StringTokenizer.TVARNAME);
        errorUnless("(");
        String s=errorUnless(StringTokenizer.TNUM);
        
        int sz=Integer.parseInt(s);
        if (sz<0) error("BS");
        errorUnless(")");
        if (!(env.variables.get(varName) instanceof Array)) {
            env.variables.put(varName,
                    new Array(sz,
                       varName.endsWith("$") ? 
                          Variable.T_STRING:
                          Variable.T_INT
                    )
            );
        }
    }
    /**
     * INPUT͂܂
     * @throws BASICError
     * 
     */
    private void parseInput() throws BASICError {
        String s=errorUnless(StringTokenizer.TVARNAME);
        parseVar(s);
        addOpr(INPUT);
    }
    /**
     * G[𔭐܂
     * @param string G[R[h
     */
    private void error(String errorCode) throws BASICError{
        /*if (curLine!=null) env.error(errorCode, curLine.lineNo);
        else */env.error(errorCode);
    }
    /**
     * LOAD͂܂
     */
    private void parseLoad() {
        String t=token.nextToken();
        addPush(t);
        addOpr(LOAD);
    }
    /**
     * SAVE͂܂
     */
    private void parseSave() {
        String t=token.nextToken();
        addPush(t);
        addOpr(SAVE);
    }
    
    /**
     * IF߂܂B
     * @throws BASICError
     */
    private void parseIf() throws BASICError {
        if (parseExpr()!=TINT) error("TM");
        addOpr(END0);
        // ȂTHEN̓ǂݔ΂Ȃ̂..THEN: ƓꎋĂAparseStatementsœǂݔ΂
        
    }
    /**
     * GOTO ߂܂
     */
    private void parseGoto() {
        String t=token.nextToken();
        if (token.tokenType()==StringTokenizer.TNUM) {
            addPush(new Integer(Integer.parseInt(t)));
            addOpr(GOTO);
        } else error("UL");
        
    }
    /**
     * GOSUB ߂܂
     */
    private void parseGosub() {
        String t=token.nextToken();
        if (token.tokenType()==StringTokenizer.TNUM) {
            addPush(new Integer(Integer.parseInt(t)));
            addOpr(GOSUB);
        } else error("UL");
    }
    /**
     * RETURN߂܂
     *  
     */
    private void parseReturn() {
        addOpr(RETURN);
    }
    /**
     * sԍso܂
     * @param i sԍ
     * @return isڂ΂̍sBȂ?UL ErrorɂȂ
     */
    public ProgLine findExact(int i) {
        for (ProgLine res=env.first ; res!=null ; res=res.next) {
            if (res.lineNo==i) return res;
        }
        error("UL");
        return null;
    }
    /**
     * LIST ߂߂܂B
     */
    private void parseList() {
        int b=0,e=Integer.MAX_VALUE;
        String s;
        if ((s=token.nextTokenIf(StringTokenizer.TNUM))!=null) {
            b=Integer.parseInt(s);
            e=b;
        }
        if (token.nextTokenIf("-")) {
            if ((s=token.nextTokenIf(StringTokenizer.TNUM))!=null) {
                e=Integer.parseInt(s);
            } else {
                e=Integer.MAX_VALUE;
            }
        }
        addPush(new Integer(b));
        addPush(new Integer(e));
        addOpr(LIST);
    }
    /**
     * (LET)͂܂B
     * @throws BASICError
     *
     */
    public void parseLet(String varName) throws BASICError {
        parseVar(varName);
        String s=token.nextToken();
        //G.println("INTER let "+s);
        if (s.equals("=")) {
            int ty=parseExpr();
            switch (ty) {
            case TINT:
                //v.set(eInt);
                addOpr(ILET);
                break;
            case TSTRING:
//              v.set(eString);
                addOpr(SLET);
                break;
            default:
                error("TM");
            }
        } else {
            error("SN");
        }
    }
    /**
     * `Jn_̈ʒuƐFł
     */
    int px,py,col;
    /**
     * ߂܂B
     * @throws BASICError
     * 
     */
    public void parseStatements() throws BASICError {
        while(true) {
            parseStatement();
            int sv=token.savePoint();
            String t=token.nextToken();
            //G.println("NEXTTOKEN = "+t);
            if (! ( t.equals(":") || t.equals("THEN")) ) {
                token.restorePoint(sv);
                return;
            }
            //checkBreak();
        }
    }
    /**
     * g[NoA̓etypenɂw肳ꂽނłȂ?MO ErrorɂȂ܂
     * @param type 
     * @return (̃g[Ntypeꍇ)og[N
     */
    public String errorUnless(int type) {
        String t=token.nextToken();
        if (token.tokenType()!=type) error("MO");
        return t;
    }
    /**
     * g[NoA̓ew肳ꂽetkƈvȂ?SN ErrorɂȂ܂
     * @param tk e
     * @return (̃g[Ntkꍇjog[N
     */
    public String errorUnless(String tk) {
        String t=token.nextToken();
        if (!t.equals(tk)) error("SN");
        return t;
    }
//------------ԃR[hs
    /**
     * ss܂B
     * @param line sJns
     * @throws BASICError
     */
    public void gosub(ProgLine line) throws BASICError {
        ProgLine sc=curLine;
        StringTokenizer t=token;
        curLine=line;
        int ofs=0;
        while(curLine!=null && !sigReturn) {
            //G.println("INTERPRETING: line "+curLine.lineNo);
            exe(curLine.code,ofs);
            if (sigGoto!=null) {
                curLine=sigGoto;
                ofs=0;
                sigGoto=null;
            } else if (sigNext!=null) {
                curLine=sigNext.line;
                ofs=sigNext.offset;
                sigNext=null;
            } else {
                curLine=curLine.next;
                ofs=0;
            }
            checkBreak();
        }
        sigReturn=false;
        curLine=sc;
        token=t;
    }
    /**
     * ss܂B
     * @param i sJnsԍ
     * @throws BASICError
     */
    public void gosub(int i) {
        gosub(findExact(i));
    }
    //int freI=0;    //TODO:debug
    //static Runtime r=Runtime.getRuntime(); //TODO:debug
    /**
     * 0L[ꂽǂfAĂvO~߂܂B
     */
    public void checkBreak() {
        if (stopOn && ICWindow.instance.getKeypadState()==1) {
            EventLoop.instance.clear();
            G.unlockForce();
            error("Break");
        }
        /*TODO:debug
        if (freI++>2000) {
            freI=0;
            System.out.println(r.freeMemory());
            System.out.println(r.freeMemory());
        }*/
    }
    /**
     * RND֐Ŏg܂B
     */
    static Random rnd=new Random();
    /**
     * ϐAAForContextpX^bNł
     * 
     * ostack[i]@ istack[i]@͂ǂ炩ЕӖ܂B
     */
    Object []ostack=new Object[64];
    /**
     * pX^bNł
     * ostack[i]@ istack[i]@͂ǂ炩ЕӖ܂B
     */
    int   []istack=new int[64];
    /**
     * X^bN|C^łB
     * ԏ̒listack[sp-1]܂ostack[sp-1]ł
     */
    int sp=0;// istack[sp]͂
    StringBuffer buf=new StringBuffer();
    /**
     * ԃR[hs܂B
     * @param code R[h
     * @param ofs sJnꏊcodẽItZbg
     */
    public void exe(Vector code,int ofs) {
        for (int i=ofs ; i<code.size() ; i++) {
            Object o=code.get(i);
            if (o instanceof Integer) {
                int ci=((Integer)o).intValue();
                switch(ci-OPOFS) {
                	case CLS:
                        Console.current.cls();
                        Console.current.draw();
                        break;
                    case ADD:
                        istack[sp-2]+=istack[sp-1];
                        sp--;
                        break;
                    case OR:
                        istack[sp-2]|=istack[sp-1];
                        sp--;
                        break;
                    case AND:
                        istack[sp-2]&=istack[sp-1];
                        sp--;
                        break;
                    case STRCAT:
                        ostack[sp-2]=ostack[sp-2].toString()+ostack[sp-1].toString();
                        sp--;
                        break;
                    case SUB:
                        istack[sp-2]-=istack[sp-1];
                        sp--;
                        break;
                    case STRCMP:
                        istack[sp-2]=
                            ostack[sp-2].toString().compareTo      
                           (ostack[sp-1].toString())   ;   	
                        sp--;
                        break;
                    case MUL:
                        istack[sp-2]*=istack[sp-1];
                        sp--;
                        break;
                    case DIV:                        
                        istack[sp-2]/=istack[sp-1];
                        sp--;
                        break;
                    case MOD:                        
                        istack[sp-2]%=istack[sp-1];
                        sp--;
                        break;

                    case ARRAY:
                        Array ar=(Array)ostack[sp-2];
                        int idx=istack[sp-1];
                        Variable v=ar.getAt(idx);/*  null;
                        try {
                            v=ar.variables[idx];
                        } catch(ArrayIndexOutOfBoundsException e) {
                            error("BS");
                        }*/
                        ostack[sp-2]=v;
                    	sp--;
                    	break;
                    case ILET:
                        ((IntVariable)ostack[sp-2]).i=istack[sp-1];
                        sp-=2;
                        break;
                    case SLET:
                        ((Variable)ostack[sp-2]).set(
                                ((String)ostack[sp-1])    
                        );
                        sp-=2;
                        break;
                    case IDEREF:
                        istack[sp-1]=((IntVariable)ostack[sp-1]).i;
                        break;
                    case SDEREF:
                        ostack[sp-1]=((Variable)ostack[sp-1]).getValue();
                        break;
                    case GOTO:
                    	sigGoto=
                    	    findExact(
                    	            istack[sp-1]
                    	    );
                    	sp--;
                    	return;
                    case GOSUB:
                    	gosub(
                    	     istack[sp-1]
                    	);
                    	sp--;
                    	break;
                    case END0:
                        if (istack[--sp]==0) return;
                        break;
                    
                    case GT:
                        istack[sp-2]=istack[sp-2]>istack[sp-1] ? -1:0;
                        sp--;
                        break;
                    case LT:
                        istack[sp-2]=istack[sp-2]<istack[sp-1] ? -1:0;
                        sp--;
                        break;

                    case GE:
                        istack[sp-2]=istack[sp-2]>=istack[sp-1] ? -1:0;
                        sp--;
                        break;
                    case LE:
                        istack[sp-2]=istack[sp-2]<=istack[sp-1] ? -1:0;
                        sp--;
                        break;
                    case NE:
                        istack[sp-2]=istack[sp-2]!=istack[sp-1] ? -1:0;
                        sp--;
                        break;
                    case EQ:
                        istack[sp-2]=istack[sp-2]==istack[sp-1] ? -1:0;
                        sp--;
                        break;
                    case INPUT:
                        v=(Variable)ostack[--sp];
                        EventLoop.instance.aborter=null;
                        Console.current.startInput();
                        //ifndef applet
                        /*          
                        //endif applet
                        G.waitInput=true;
                        //ifndef applet
                         */
                        //endif applet
                        EventLoop.instance.run();
                        //ifndef applet
                        /*          
                        //endif applet
                        G.waitInput=false;
                        //ifndef applet
                         */
                        //endif applet
                        String inp=(String)EventLoop.instance.aborter;
                        EventLoop.instance.aborter=null;
                        v.set(inp);
                        break;
                    case IPRINT:
                        buf.delete(0,buf.length());
                        buf.append(istack[--sp]);
                    	Console.current.print(buf.toString(),false);
                        break;
                    case SPRINT:
                    	Console.current.print(ostack[--sp].toString(),false);
                    	break;
                    case PRINTLN:
                    	Console.current.print("");
                    	break;
                    case LIST:
                        stopOn=true;
                        int b=istack[sp-2];
                        int e=istack[sp-1];
                        sp-=2;
                        for (ProgLine p=env.first; p!=null ; p=p.next) {
                            if (p.lineNo>e) break;
                            if (p.lineNo>=b) {
                                Console.current.print(p.toString());
                                //ifndef applet
                                /*
                                //endif applet
                                try {
                                    Thread.sleep(20);
                                }catch(Exception ex) {}
                                //ifndef applet 
                                */
                                //endif applet 
                            }
                            checkBreak();
                            while (ICWindow.instance.getKeypadState()!=0) {
                                try {
                                    Thread.sleep(20);
                                    checkBreak();
                                } catch (InterruptedException e1) {
                                }
                            }
                        }
                        break;
                    case LOAD:
                        if (env.modified) {
                            Console.current.print("vOۑĂ܂!");
                            Console.current.print("0:Cancel/1:Continue Loading");
                            while (ICWindow.instance.getKeypadState()!=1<<Display.KEY_1) {
                                checkBreak();
                                try {
                                    Thread.sleep(17);
                                } catch (Exception ex) {
                                }
                            }
                        }
                        
                        String t=ostack[--sp].toString();
                        if (t.equals("")) {
                            env.loadFromScratchPad(0);
                        } else {
                            Console.current.print(env.loadFromNetwork(t));
                        }
                        Console.current.initDict();
                        break;
                    case SAVE:
                        if (env.first==null) {
                            Console.current.print("Empty program. not Saved.");
                            break;
                        } 
                        t=ostack[--sp].toString();
                        if (t.equals("")) {
                            env.saveToScratchPad(0);
                            return;
                        }
                        Console.current.print(env.saveToNetwork(t));
                        break;
                    case RETURN:
                        sigReturn=true;
                        return;
                    case NEG:
                        istack[sp-1]=-istack[sp-1];
                        break;
                    case NOT:
                        istack[sp-1]=istack[sp-1]==0 ?-1:0;
                        break;
                    case RND:
                        if (istack[sp-1]>0) {
                            istack[sp-1]=
                                (rnd.nextInt() & 0x3fffffff )/
                                  (0x40000000/istack[sp-1])
                           ;
                        } else {
                            rnd=new Random(-istack[sp-1]);
                        }
                        break;
                    case ABS:
                        if (istack[sp-1]<0) istack[sp-1]=-istack[sp-1];
                        break;
                    case STRIG:
                        istack[sp-1]=strig(istack[sp-1]);
                        break;
                    case PSET:
                        int c=istack[sp-1];
                        if (c==DEFCOL) c=col; else col=c;
                        py  =istack[sp-2];
                        px  =istack[sp-3];
                        G.setColor(c);
                        //G.drawRect(px,py,0,0);
                        sp-=3;
                        break;
                    case LINE:
                        int mode=istack[sp-1];
                        c=istack[sp-2];
                        if (c==DEFCOL) c=col; else col=c;

                        int y  =istack[sp-3];
                        int x  =istack[sp-4];
                        int step=istack[sp-5];
                        if (step==1) {
                            x+=px;
                            y+=py;
                        }
                        G.setColor(c);
                        switch (mode) {
                        case LINENORM:
                            G.drawLine(px,py,x-px,y-py);
                            break;
                        case LINEB:
                            G.drawRect(px,py,x-px,y-py);
                            break;
                        case LINEBF:
                            G.fillRect(px,py,x-px,y-py);
                            break;
                        }
                        px=x;py=y;
                        sp-=5;
                        break;
                    case GIPRINT:
                        G.setColor(col);
                        buf.delete(0,buf.length());
                        buf.append(istack[--sp]);
                        px+=G.drawString(buf.toString(),px,py);
                        break;
                    case GSPRINT:
                        G.setColor(col);
                        px+=G.drawString(ostack[--sp].toString(),px,py);
                        break;
                    case COLORPAL:
                        G.setColorPal(
                                istack[sp-4],
                                istack[sp-3],
                                istack[sp-2],
                                istack[sp-1]);
                        sp-=4;
                        break;
                    case LOCK:
                        G.lock();
                        break;
                    case UNLOCK:
                    	G.unlock();
                    	break;
                    case FOR:
                        ForContext fc=(ForContext)ostack[sp-3];
                        fc.to=istack[sp-2];
                        fc.step=istack[sp-1];
                        sp-=2;
                        //G.println("FOR!  "+istack[sp-1]);
                        break;
                    case NEXT:
                        if (sp==0) error("NF");
                        if (! (ostack[sp-1] instanceof ForContext)) error("NF");
                        sigNext=(ForContext)ostack[sp-1];
                        sigNext.loop.set(sigNext.loop.i+sigNext.step);
                        if (
                           (sigNext.step>0 && sigNext.loop.i<=sigNext.to) ||
                           (sigNext.step<=0 && sigNext.loop.i>=sigNext.to)) {
                            return;
                        }
                        sigNext=null;
                        sp--;
                        break;
                    case TIME:
                        istack[sp++]=((int)System.currentTimeMillis()) & 0x7fffffff;
                        break;
                    case WIDTH:
                        istack[sp++]=G.sWidth;
                        break;
                    case HEIGHT:
                        istack[sp++]=G.sHeight;
                        break;
                    case SYNC:
                        if (lastSync==0) lastSync=System.currentTimeMillis();	
                        try {
                            lastSync+=istack[--sp];
                            while (true) {
                                long restT=(lastSync-System.currentTimeMillis());
                                if (restT<=0) {
                                    if (restT<=1000) lastSync=System.currentTimeMillis();
                                    break;
                                }
                                if (restT>17) restT=17;
                                Thread.sleep(restT);
                                checkBreak();
                            }
                        } catch (Exception ex) {}
                        break;
                    case LOCATE:
                        Console.current.locate(
                        istack[sp-2],istack[sp-1]);
                        sp-=2;
                        break;
                    case STOPOFF:
                        stopOn=false;
                        break;
                    
                    default: istack[sp++]=ci;
                }
            } else {
                ostack[sp++]=o;
            }
            //Avbgŗp}@\
            //ifndef applet
            /*          
            //endif applet
            try {
                if (waitCnt++ %60==19) Thread.sleep(1);
            } catch (Exception e) {
                e.printStackTrace();
            }
            //ifndef applet
            */          
            //endif applet
        }
    }
    /**
     * SYNCŎgp:ŌSYNCsꂽԂł
     */
    static long lastSync=0;
    /**
     * STRIG֐̒lۑ܂
     */
    static int []fstrig=new int[32];
    /**
     * STRIGs܂
     * @param i L[R[h
     * @return STRIG(i)̌
     */
    private int strig(int i) {
        if ((ICWindow.instance.getKeypadState() & (1<<i))!=0) {
            fstrig[i]++;
        } else {
            fstrig[i]=0;
        }
        return fstrig[i];
    }
    //ifndef applet
    /*          
    //endif applet
    int waitCnt=0;
    //ifndef applet
     */          
    //endif applet
    /**
     * TODO:DEBUG
     */
    public void dispCode() {
        for (int t=0 ; t<code.size() ; t++) {
            Object e=(Object) code.get(t);
            if (e instanceof Integer) {
                Integer in=(Integer) e;
                String c="";
                switch(in.intValue()-OPOFS) {
            	case CLS:
            	    c="CLS";
            	    break;
                case ADD:
                    c="ADD";
                    break;
                case SUB:
                    c="SUB";
                    break;
                case MUL:
                    c="MUL";
                    break;
                case DIV:                        
                    c="DIV";
                    break;
                case ARRAY:
                    c="ARRAY";
                    break;
                case ILET:
                    c="ILET";
                    break;
                case IDEREF:
                    c="IDEREF";
                    break;
                case SDEREF:
                    c="SDEREF";
                    break;
                case GOTO:
                    c="GOTO";
                    break;
                case GOSUB:
                    c="GOSUB";
                    break;
                case END0:
                    c="END0";
                    break;
                case GT:
                    c="GT";
                    break;
                case LT:
                    c="LT";
                    break;
                case GE:
                    c="GE";
                    break;
                case LE:
                    c="LE";
                    break;
                case NE:
                    c="NE";
                    break;
                case EQ:
                    c="EQ";
                    break;
                case INPUT:
                    c="INPUT";
                    break;
                case IPRINT:
                    c="IPRINT";
                    break;
                case SPRINT:
                    c="SPRINT";
                    break;
                case PRINTLN:
                    c="PRINTLN";
                    break;
                case LIST:
                    c="LIST";
                    break;
                case LOAD:
                    c="LOAD";
                    break;
                case SAVE:
                    c="SAVE";
                    break;
                case RETURN:
                    c="RETURN";
                    break;
                case NEG:
                    c="NEG";
                    break;
                case NOT:
                    c="NOT";
                    break;
                case SLET:
                    c="LET";
                    break;
                case STRCAT:
                    c="STRCAT";
                    break;
                case STRCMP:
                    c="STRCMP";
                    break;
                case PSET:
                    c="PSET";
                    break;
                case LINE:
                    c="LINE";
                    break;
                case NEXT:
                    c="NEXT";
                    break;
                case LOCK:
                    c="LOCK";
                    break;
                case UNLOCK:
                	c="UNLOCK";
                	break;
                case TIME:
                    c="TIME";
                default:
                    c=in.toString();
                }
                //G.println("INT:"+c+" / "+in+" "+SUB+" "+OPOFS);
            } else {
                //G.println("PUSH:"+ e );
            }
        }
    }

}
