/*
 * Created on 2005/02/26
 *
 */
package inter;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;

import javax.microedition.io.Connector;

import ui.Console;

import com.nttdocomo.io.HttpConnection;
import com.nttdocomo.ui.IApplication;

/**
 * BASIC̎słBϐƃvOsi[܂
 * @author hoge1000
 *
 */
public class Environment {
    //public Screen activePage;
    /**
     * ϐL[AϐlƂ
     * ׂĂ̕ϐi[܂
     */
    public Hashtable variables=new Hashtable();
    /**
     * ϐ擾܂Bw肳ꂽOϐȂꍇ
     * Iɍ쐬܂B
     * @param varName ϐ
     * @return varName𖼑Oɂϐ
     */
    public Variable getVar(String varName) {
        varName=varName.toUpperCase();
        Variable res=getVarWithoutCreation(varName);
        if (res==null) {
            if (varName.endsWith("$")) {
                res=new StringVariable();
            } else {
                res=new IntVariable();
            }
            variables.put(varName,res);
        }
        return res;
    }
    /**
     * ϐ擾܂Bw肳ꂽOϐȂꍇ
     * nullԂ܂
     * @param varName ϐ
     * @return varName𖼑OɂϐBȂnull
     */
    public Variable getVarWithoutCreation(String varName) {
        varName=varName.toUpperCase();
        return (Variable)variables.get(varName);
    }
    /**
     * vOۑ̂܂ܕύXĂtrue
     */
    public boolean modified=false;
    /**
     * vOs̐擪łB
     * ׂĂ̍sfirst擪ɁANXgɂĕ\܂B
     */
    public ProgLine first;
    /**
     * vOsǉ܂
     * @param ln sԍ
     * @param content ߗ
     * @throws BASICError
     */
    public void addLine(int ln,String content) throws BASICError {
        modified=true;
        if (content.length()==0) {
            deleteLine(ln);
            return;
        }
        ProgLine p=new ProgLine();p.init(this,ln,content);
        
        //G.println("ENVAdding "+p);
        if (first==null) {
            first=p;
            //G.println("ENVAdding2 "+p);
            return;
        }
        if (ln<first.lineNo) {
            //G.println("ENV ins null");
            ProgLine of=first;
            first=p;
            p.next=of;
        } else if (ln==first.lineNo) {
            p.next=first.next;
            first=p;
        } else {
            ProgLine ins=first.findInsertion(ln);
            ProgLine.set(ins,p);
        }
        
    }
    /**
     * @param ln
     * @throws BASICError
     */
    private void deleteLine(int ln) throws BASICError {
        if (first==null) error("UL");
        if (first!=null && first.lineNo==ln) {
            first=first.next;
        } else {
            ProgLine delPrev=first.findInsertion(ln);
            if (delPrev!=null && 
                delPrev.next != null &&
                delPrev.next.lineNo==ln
            ) {
                delPrev.next=delPrev.next.next;
            } else {
                error("UL");
            }
        }
        modified=true;
    }
    //Hashtable statements=new Hashtable();
    /*
     * gXe[ggǉ܂
     * @param procnm gXe[gg
     * @param extension Xe[ggJ[gbW
     *
    public void addStatement(String procnm,Cartridge extension) {
        statements.put(procnm,extension);
    }*/
    /**
     * vOXNb`pbhɕۑ܂
     * @param ofs ۑʒu
     */
    public void saveToScratchPad(int ofs) {
        try {
            DataOutputStream o=new DataOutputStream(
                    Connector.openOutputStream("scratchpad:///0;pos="+ofs)
            );
            save(o);
            o.close();
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * vOOT[oɑM܂
     * @param name t@C
     * @return bZ[W
     */
    public String saveToNetwork(String name) {
        String msg="Save Error";
        HttpConnection con=null;
        try {
            String url=IApplication.getCurrentApp().getSourceURL()
            +"upload.cgi?"+name;
            //G.println("URL="+url);
            //G.println("Opening connection");
            con = (HttpConnection) Connector.open(
                 url, Connector.READ_WRITE , true);
            con.setRequestMethod(HttpConnection.POST);
            con.setRequestProperty("Content-Type", "text/plain"); 
            DataOutputStream out = new DataOutputStream(
                    con.openOutputStream()
            );
            save(out);
            out.close();
            
            //G.println("BEFORECON");
            con.connect();
            //G.println("AFTERCON");
            if (con.getResponseCode() == HttpConnection.HTTP_OK) {
                DataInputStream in=new DataInputStream(
                        con.openInputStream());
                int res=in.read();
                if (res=='0') {
                    msg="Save Complete";
                } else {
                    msg="Save http error";
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        if (con!=null) {
            try {
                con.close();
            } catch (IOException e) {
                e.printStackTrace();
                msg="Close Error";
            }
        }
        return msg;
    }
    /*
    public String dumpSP(int len) {
        String msg="Save Error";
        HttpConnection con=null;
        try {
            String url=IApplication.getCurrentApp().getSourceURL()
            +"upload.cgi?DUMP";
            G.println("URL="+url);
            G.println("Opening connection");
            con = (HttpConnection) Connector.open(
                 url, Connector.READ_WRITE , true);
            con.setRequestMethod(HttpConnection.POST);
            con.setRequestProperty("Content-Type", "text/plain"); 
            DataOutputStream out = new DataOutputStream(
                    con.openOutputStream()
            );
            DataInputStream o=new DataInputStream(
                    Connector.openInputStream("scratchpad:///0;pos=0")
            );
            byte[] buf=new byte[len];
            o.read(buf);
            out.write(buf);
            o.close();
            out.close();
            
            G.println("BEFORECON");
            con.connect();
            G.println("AFTERCON");
            if (con.getResponseCode() == HttpConnection.HTTP_OK) {
                DataInputStream in=new DataInputStream(
                        con.openInputStream()
                );
                int res=in.read();
                if (res=='0') {
                    msg="Save Complete";
                } else {
                    msg="Save http error";
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        if (con!=null) {
            try {
                con.close();
            } catch (IOException e) {
                e.printStackTrace();
                msg="Close Error";
            }
        }
        return msg;
    }*/
    /**
     * vOT[oM܂
     * @param name t@C
     * @return ǂݍ݌̃bZ[W
     */
    public String loadFromNetwork(String name) {
        String msg="Load Error";
        HttpConnection con=null;
        try {
            String url=IApplication.getCurrentApp().getSourceURL()
            +"download.cgi?"+name;
            //G.println("URL="+url);
            //G.println("Opening connection");
            con = (HttpConnection) 
                 Connector.open(url, Connector.READ , true);
            con.setRequestMethod(HttpConnection.GET);
            //G.println("BEFORECON");
            con.connect();
            //G.println("AFTERCON");
            if (con.getResponseCode() == HttpConnection.HTTP_OK) {
                DataInputStream in = new DataInputStream(
                        con.openInputStream()
                );
                int res=in.read();
                if (res=='0') {
                    load(in);
                    msg="Load Complete";
                } else msg="File not found";
                in.close();
            }
        } catch (IOException e) {
            msg="Load IO Error";
            e.printStackTrace();
        }
        if (con!=null) {
            try {
                con.close();
            } catch (IOException e) {
                e.printStackTrace();
                msg="Close Error";
            }
        }
        return msg;
    }
    /**
     * vOXNb`pbhǂݍ݂܂
     * @param ofs
     */
    public void loadFromScratchPad(int ofs) {
        try {
            DataInputStream o=new DataInputStream(
                    Connector.openInputStream("scratchpad:///0;pos="+ofs)
            );
            load(o);
            o.close();
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * vOXg[ɏo͂܂
     * @param d ۑ̃Xg[
     * @throws IOException
     */
    public void save(DataOutputStream d) throws IOException {
            for (ProgLine cur=first;cur!=null ;cur=cur.next) {
                d.writeInt(cur.lineNo);
                d.writeUTF(cur.content);
            }
            d.writeInt(-1);
            modified=false;
    }
    /**
     * vOXg[ǂݍ݂܂
     * 
     * @param i 
     * @throws IOException
     */
    public void load(DataInputStream i) throws IOException {
        variables.clear();
          int line=i.readInt();
          ProgLine cur=null;
          ProgLine oldF=first;
          while (line>=0) {
              //G.println("LOAD" + line );
              String content=i.readUTF();
              ProgLine r=new ProgLine();
              try {
                  r.init(this,line,content);
              } catch (BASICError e) {
                  Console.current.print(""+e+" in "+line);
              }
              if (cur==null) first=r;
              else cur.next=r;
              cur=r;
              int pline=line;
              line=i.readInt();
              if (line>=0 && line<=pline) {
                  Console.current.print("Empty File");
                  first=oldF;
                  break;
              }
          }
          modified=false;
          //G.println( first.lineNo+ "  - "+ first.content);
    }
    /**
     * G[𔭐܂
     * @param errorCode G[R[h
     */
    public void error(String errorCode) throws BASICError {
        throw new BASICError(errorCode);
    }
    
}
