/*
 * Decompiled with CFR 0.152.
 */
package ui;

import com.nttdocomo.ui.Component;
import com.nttdocomo.ui.Display;
import com.nttdocomo.ui.Font;
import com.nttdocomo.ui.Frame;
import com.nttdocomo.ui.Graphics;
import com.nttdocomo.ui.Label;
import com.nttdocomo.ui.Panel;
import com.nttdocomo.ui.TextBox;
import com.nttdocomo.ui.UIException;
import java.util.Hashtable;
import ui.Console;
import ui.EventLoop;
import ui.ICWindow;

public class G {
    public static final int yPitch = 14;
    public static ICWindow wnd;
    public static int sWidth;
    public static int sHeight;
    public static Graphics gr;
    public static int fontType;
    public static Font font;
    static Hashtable colors;
    public static boolean init;
    public static TextBox textBox;
    public static Panel input;
    public static String[] menu;
    public static int menuColor;

    static {
        sWidth = 240;
        sHeight = 256;
        fontType = 1912603648;
        colors = new Hashtable();
        init = false;
    }

    public static void clearAllScreen() {
        G.setColor(255, 255, 255);
        G.fillRect(0, 0, sWidth, sHeight);
    }

    public static int stringWidth(String s) {
        return font.stringWidth(s);
    }

    public static void lock() {
        gr = wnd.getGraphics();
        gr.setFont(font);
        gr.lock();
    }

    public static void unlock() {
        gr.unlock(false);
    }

    public static void setColor(int r, int g, int b) {
        if (r > 255) {
            r = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (b > 255) {
            b = 255;
        }
        if (b < 0) {
            b = 0;
        }
        gr.setColor(Graphics.getColorOfRGB((int)r, (int)g, (int)b));
    }

    public static void setColor(int i) {
        Integer c = (Integer)colors.get(new Integer(i));
        if (c != null) {
            int ci = c;
            int r = ci & 0xFF;
            int g = (ci /= 256) & 0xFF;
            int b = (ci /= 256) & 0xFF;
            G.setColor(r, g, b);
        }
    }

    public static int drawString(String s, int x, int y) {
        gr.drawString(s, x, y);
        return G.stringWidth(s);
    }

    public static void drawRect(int x, int y, int w, int h) {
        if (w < 0) {
            x += w;
            w = -w;
        }
        if (h < 0) {
            y += h;
            h = -h;
        }
        gr.drawRect(x, y, w, h);
    }

    public static void drawLine(int x, int y, int w, int h) {
        gr.drawLine(x, y, x + w, y + h);
    }

    public static void fillRect(int x, int y, int w, int h) {
        if (w < 0) {
            x += w;
            w = -w;
        }
        if (h < 0) {
            y += h;
            h = -h;
        }
        gr.fillRect(x, y, w, h);
    }

    public static void start() {
        font = Font.getFont((int)fontType);
        sWidth = Display.getWidth();
        sHeight = Display.getHeight();
        wnd = new ICWindow();
        G.setMainMenu();
        input = new Panel();
        input.add((Component)new Label("Press Select to input"));
        textBox = new TextBox("", 20, 1, 0);
        input.add((Component)textBox);
        textBox.setInputMode(1);
        Display.setCurrent((Frame)wnd);
        int i = 0;
        while (i < 16) {
            int r = (i & 1) * 255;
            int g = (i & 2) * 127;
            int b = (i & 4) * 63;
            if (i >= 8) {
                r /= 2;
                g /= 2;
                b /= 2;
            }
            G.setColorPal(i, r, g, b);
            ++i;
        }
    }

    public static void paint() {
        if (!init) {
            init = true;
            G.lock();
            G.unlock();
            new Console();
            Console.current.draw();
            EventLoop.instance.startLoop();
        }
    }

    public static void setMainMenu() {
        wnd.setSoftLabel(0, "\u5358\u8a9e");
        wnd.setSoftLabel(1, "\u6587\u5b57\u7a2e");
    }

    public static void setInputMenu() {
        wnd.setSoftLabel(0, "\u65b0\u5358\u8a9e");
    }

    public static void printStackTrace(Exception e) {
        Console.current.print(String.valueOf(e.getMessage()) + "/" + e.toString());
    }

    public static void showMenu(String[] m, int menuColor) {
        G.menuColor = menuColor;
        menu = m;
        G.redrawMenu();
    }

    public static void redrawMenu() {
        try {
            G.lock();
            int bw = sWidth / 3;
            int bh = 14;
            int i = 0;
            while (i < 12) {
                int x = bw * (i % 3);
                int y = sHeight - bh * 4 + i / 3 * bh;
                G.setColor(0, 0, 128);
                G.fillRect(x, y + 2, bw, bh + 1);
                G.setColor(255, 255, 255);
                if (i < menu.length && menu[i].length() > 0) {
                    G.drawString(menu[i].substring(0), x + 5, y + 14);
                }
                ++i;
            }
            G.unlock();
        }
        catch (UIException e) {
            e.printStackTrace();
        }
    }

    public static void unlockForce() {
        gr.unlock(true);
    }

    public static void setColorPal(int n, int r, int g, int b) {
        colors.put(new Integer(n), new Integer(b * 65536 + g * 256 + r));
    }
}

