/*
 * Decompiled with CFR 0.152.
 */
package ui;

import com.nttdocomo.ui.Component;
import com.nttdocomo.ui.ComponentListener;
import com.nttdocomo.ui.Display;
import com.nttdocomo.ui.Frame;
import inter.Array;
import inter.Environment;
import inter.Interpreter;
import inter.StringTokenizer;
import inter.Variable;
import java.util.Enumeration;
import key.Dictionary;
import key.Key;
import key.KeyInput;
import ui.EventLoop;
import ui.G;
import util.Vector;

public class Console
extends G
implements ComponentListener {
    public int x;
    public int y;
    public String[] lines;
    public boolean[] connected;
    public static Console current;
    public boolean inputMode = false;
    public int inputX;
    public int inputY;
    public Environment env;
    public boolean imeMode = false;
    public static String BLANK_LINE;
    int keyPage = 2;
    public static final int FK_EXPR = 0;
    public static final int FK_NUM = 0;
    public static final int FK_OPR = 1;
    public static final int FK_STMT = 2;
    public static final String CMDBS = "[BS]";
    public static final String CMDSPC = "[SPC]";
    String[][] funcKeys = new String[][]{{"1", "2", "3", "4", "5", "6", "7", "8", "9", "[BS]", "0", "."}, {"+", "-", "*", "/", "=", ">", "<", "(@)", ":", "[BS]", ",", "\"@\""}, new String[0]};
    String[] stmtHeadProg = new String[]{"?@:", "IF @ THEN ", "GOTO @:", "?@;:", "RETURN:", "GOSUB @:", "FOR @= TO :", "PSET(@,),:", "LINE(@,)-(,),,BF:", "[BS]", "[SPC]", "NEXT:"};
    String[] stmtHeadDirect = new String[]{"?@:", "", "GOTO @:", "LIST @-", "RUN", "GOSUB @:", "", "LOAD\"@\"", "SAVE\"@\"", "[BS]", "[SPC]", ""};
    Dictionary dict = new Dictionary();
    public boolean showCursor = true;
    public static final int CTX_EXPRHEAD = 1;
    public static final int CTX_EXPRTAIL = 2;
    public static final int CTX_STMTHEAD = 4;
    public static final int CTX_STMTTAIL = 8;
    public static final int CTX_DIRECT = 16;
    public static final int CTX_LINENO = 32;
    KeyInput in;
    Vector candidates;
    public static int IMEw;
    public static final String DIRECT = "__DIRECTINPUT";
    int IMEy = 0;

    public void cls() {
        int i = 0;
        while (i < this.lines.length) {
            this.lines[i] = BLANK_LINE;
            this.connected[i] = false;
            ++i;
        }
        this.y = 0;
        this.x = 0;
    }

    public Console() {
        BLANK_LINE = "                                             ".substring(0, Display.getWidth() / 6);
        current = this;
        G.input.setComponentListener((ComponentListener)this);
        this.env = new Environment();
        this.lines = new String[G.sHeight / 14 - 4];
        this.connected = new boolean[this.lines.length];
        this.cls();
        this.y = 0;
        this.x = 0;
        this.print("soyBasic Ver 0.1");
        this.print("Copyright 2005 by Hoge- Ship");
        this.print("Ok");
        this.funcKeys[2] = this.stmtHeadDirect;
        this.keyPage = 2;
        G.showMenu(this.funcKeys[this.keyPage], 200);
        this.initDict();
    }

    public void initDict() {
        this.dict = new Dictionary();
        this.dict.add("PRINT|?");
        this.dict.add("GOTO @:");
        this.dict.add("GOSUB @:");
        this.dict.add("CLS:");
        this.dict.add("DIM @():");
        this.dict.add("LIST @-");
        this.dict.add("INPUT @:");
        this.dict.add("AND @ ");
        this.dict.add("OR @ ");
        this.dict.add("IF @ THEN ");
        this.dict.add("RND(@)");
        this.dict.add("RETURN:");
        this.dict.add("LOCK:");
        this.dict.add("LOCATE @,:");
        this.dict.add("STEP ");
        this.dict.add("UNLOCK:");
        this.dict.add("GPRINT @:");
        this.dict.add("STRIG(@)");
        this.dict.add("COLOR=(@,,,):");
        this.dict.add("SEMICOLON|;");
        this.dict.add("REM|'");
        this.dict.add("SYNC @:");
        this.dict.add("TIME");
        this.dict.add("WIDTH");
        this.dict.add("HEIGHT");
        this.dict.add("MOD @ ");
        this.dict.add("ABS(@)");
        this.dict.add("LOAD\"@\"");
        this.dict.add("SAVE\"@\"");
        Enumeration e = this.env.variables.keys();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            this.dict.add("" + name);
        }
    }

    public void draw(int y) {
        G.lock();
        G.setColor(255, 255, 255);
        G.fillRect(0, y * 14, G.sWidth, 14);
        G.setColor(0, 0, 0);
        G.drawString(this.lines[y], 0, 14 * y + 14);
        G.unlock();
    }

    public void draw() {
        G.lock();
        G.setColor(255, 255, 255);
        G.fillRect(0, 0, G.sWidth, 14 * this.lines.length + 3);
        G.setColor(0, 0, 0);
        int i = 0;
        while (i < this.lines.length) {
            G.drawString(this.lines[i], 0, 14 * i + 14);
            ++i;
        }
        this.showCursor(0);
        G.unlock();
    }

    public void onKeyType(Key key) {
        if (this.imeMode) {
            this.onIMEKeyType(key);
            return;
        }
        switch (key.keyCode) {
            case 17: {
                this.locate(this.x, this.y - 1);
                break;
            }
            case 19: {
                this.locate(this.x, this.y + 1);
                break;
            }
            case 16: {
                this.locate(this.x - 1, this.y);
                break;
            }
            case 18: {
                this.locate(this.x + 1, this.y);
                break;
            }
            case 21: {
                this.startIME();
                break;
            }
            case 22: {
                this.keyPage = (this.keyPage + 1) % this.funcKeys.length;
                G.showMenu(this.funcKeys[this.keyPage], 200);
                break;
            }
            case 20: {
                this.exec();
                break;
            }
            default: {
                int im = key.menuOffset;
                if (G.menu == null || im < 0 || im >= G.menu.length || G.menu[im].length() <= 0) break;
                this.insert(G.menu[im]);
            }
        }
    }

    public void insert(String s) {
        if (s.length() == 0) {
            return;
        }
        if (s.equals(CMDSPC)) {
            s = " ";
        }
        if (s.equals(CMDBS)) {
            this.backSpace(this.x, this.y);
            if (this.x > 0 || this.y > 0 && this.connected[this.y - 1]) {
                this.locate(this.x - 1, this.y);
            }
            this.refreshContext();
        } else {
            switch (s.charAt(s.length() - 1)) {
                case '(': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': {
                    this.keyPage = 0;
                    G.showMenu(this.funcKeys[this.keyPage], 170);
                    break;
                }
                default: {
                    Variable v;
                    int ctx = this.getContext();
                    if ((ctx & 4) > 0 || (ctx & 0x10) > 0) {
                        Variable v2 = this.env.getVarWithoutCreation(s);
                        if (v2 == null) break;
                        if (v2 instanceof Array) {
                            s = String.valueOf(s) + "(@)=:";
                            break;
                        }
                        s = String.valueOf(s) + "=@:";
                        break;
                    }
                    if ((ctx & 1) <= 0 || !((v = this.env.getVarWithoutCreation(s)) instanceof Array)) break;
                    s = String.valueOf(s) + "(@)";
                }
            }
            int insPnt = s.indexOf("@");
            if (insPnt >= 0) {
                s = String.valueOf(s.substring(0, insPnt)) + s.substring(insPnt + 1);
            } else {
                insPnt = s.length();
            }
            this.lines[this.y] = String.valueOf(this.lines[this.y].substring(0, this.x)) + s + this.lines[this.y].substring(this.x, this.lines[this.y].length());
            this.checkLineInsertion(this.y);
            this.locate(this.x + insPnt, this.y);
            if (insPnt < s.length() || this.isAlpha(s.charAt(0)) || s.charAt(0) == ':') {
                this.refreshContext();
            }
        }
    }

    private void backSpace(int x, int y) {
        while (true) {
            if (x == 0 && y > 0 && this.connected[y - 1]) {
                this.lines[y - 1] = String.valueOf(this.lines[y - 1].substring(0, this.lines[y - 1].length() - 1)) + this.lines[y].charAt(0);
                this.draw(y - 1);
                this.lines[y] = this.lines[y].substring(1, this.lines[y].length());
            } else {
                this.lines[y] = x > 0 ? String.valueOf(this.lines[y].substring(0, x - 1)) + this.lines[y].substring(x) : this.lines[y].substring(1);
            }
            int n = y;
            this.lines[n] = String.valueOf(this.lines[n]) + " ";
            if (!this.connected[y]) {
                this.draw(y);
                return;
            }
            x = 0;
            ++y;
        }
    }

    private void checkLineInsertion(int y) {
        while (true) {
            String hmd = this.lines[y].substring(BLANK_LINE.length());
            this.lines[y] = this.lines[y].substring(0, BLANK_LINE.length());
            this.draw(y);
            if (!this.connected[y]) {
                if (Console.chomp(hmd, false).length() > 0 || this.lines[y].charAt(this.lines[y].length() - 1) != ' ') {
                    this.connected[y] = true;
                    if (y < this.lines.length - 1) {
                        int j = this.lines.length - 1;
                        while (j > y + 1) {
                            this.lines[j] = this.lines[j - 1];
                            this.connected[j] = this.connected[j - 1];
                            --j;
                        }
                        this.lines[y + 1] = (String.valueOf(hmd) + BLANK_LINE).substring(0, BLANK_LINE.length());
                        this.connected[y + 1] = false;
                        this.draw();
                    } else {
                        this.scroll();
                        this.lines[y] = (String.valueOf(hmd) + BLANK_LINE).substring(0, BLANK_LINE.length());
                    }
                }
                return;
            }
            this.lines[++y] = String.valueOf(hmd) + this.lines[y];
        }
    }

    private boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public void locate(int x, int y) {
        if (this.showCursor) {
            this.showCursor(255);
        }
        if (x < 0) {
            x = y <= 0 ? 0 : this.lines[--y].length() - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if (y >= this.lines.length) {
            y = this.lines.length - 1;
            this.scroll();
        }
        if (x >= this.lines[y].length()) {
            if (y < this.lines.length - 1) {
                x = 0;
                ++y;
            } else {
                x = this.lines[y].length() - 1;
            }
        }
        this.x = x;
        this.y = y;
        if (this.showCursor) {
            this.showCursor(0);
        }
    }

    private void scroll() {
        int i = 1;
        while (i < this.lines.length) {
            this.lines[i - 1] = this.lines[i];
            this.connected[i - 1] = this.connected[i];
            ++i;
        }
        this.lines[this.lines.length - 1] = BLANK_LINE;
        this.connected[this.lines.length - 1] = false;
        this.draw();
    }

    private void showCursor(int col) {
        int px = this.xPixel(this.x, this.y);
        int py = this.yPixel(this.y);
        int w = this.cWidth(this.x, this.y);
        G.setColor(col, col, 255);
        G.fillRect(px, py + 14, w, 2);
    }

    private int cWidth(int curX, int curY) {
        return G.stringWidth(this.lines[curY].substring(curX, curX + 1));
    }

    public int yPixel(int curY) {
        return curY * 14;
    }

    public int xPixel(int curX, int curY) {
        return G.stringWidth(this.lines[curY].substring(0, curX));
    }

    public void exec() {
        Interpreter i = null;
        try {
            this.showCursor(255);
            this.showCursor = false;
            while (this.y > 0 && this.connected[this.y - 1]) {
                --this.y;
            }
            String inp = this.lines[this.y];
            while (this.y < this.lines.length - 1 && this.connected[this.y]) {
                ++this.y;
                inp = String.valueOf(inp) + this.lines[this.y];
            }
            int nextY = this.y + 1;
            if (this.inputMode) {
                if (this.inputY == this.y) {
                    inp = inp.substring(this.inputX);
                }
                inp = Console.chomp(inp, false);
                EventLoop.instance.aborter = inp;
                this.inputMode = false;
                this.locate(0, nextY);
                return;
            }
            String chompL = Console.chomp(inp, true);
            if (chompL.length() == 0) {
                this.locate(0, nextY);
                this.showCursor = true;
                this.showCursor(0);
                return;
            }
            StringTokenizer token = new StringTokenizer(chompL);
            int s = token.savePoint();
            String ln = token.nextToken();
            if (token.tokenType() == 1) {
                this.showCursor = true;
                this.locate(0, nextY);
                this.env.addLine(Integer.parseInt(ln), Console.chomp(token.restString(), true));
                return;
            }
            token.restorePoint(s);
            i = new Interpreter(token, this.env);
            this.locate(0, nextY);
            i.parseStatements();
            i.exe(i.code, 0);
        }
        catch (Exception e) {
            G.unlockForce();
            if (i != null && i.curLine != null) {
                this.print(e + " in " + i.curLine.lineNo);
            }
            this.print("" + e);
        }
        this.showCursor = true;
        this.print("Ok");
    }

    public void print(String s) {
        this.print(s, true);
    }

    public void print(String s, boolean br) {
        while (true) {
            if (s.length() + this.x < BLANK_LINE.length()) {
                this.lines[this.y] = String.valueOf(this.lines[this.y].substring(0, this.x)) + s + this.lines[this.y].substring(this.x + s.length());
                this.draw(this.y);
                if (br) {
                    this.locate(0, this.y + 1);
                } else {
                    this.locate(this.x + s.length(), this.y);
                }
                return;
            }
            this.connected[this.y] = true;
            this.lines[this.y] = String.valueOf(this.lines[this.y].substring(0, this.x)) + s;
            s = this.lines[this.y].substring(BLANK_LINE.length());
            this.lines[this.y] = this.lines[this.y].substring(0, BLANK_LINE.length());
            this.draw(this.y);
            this.locate(0, this.y + 1);
        }
    }

    public static String chomp(String s, boolean trailSemicolon) {
        int b = 0;
        while (b < s.length()) {
            if (s.charAt(b) != ' ') break;
            ++b;
        }
        if (b == s.length()) {
            return "";
        }
        int e = s.length() - 1;
        while (e > b) {
            if (s.charAt(e) != ' ' && (!trailSemicolon || s.charAt(e) != ':')) break;
            --e;
        }
        return s.substring(b, e + 1);
    }

    public int getContext() {
        String before;
        int beforeType;
        StringBuffer sb = new StringBuffer();
        int yy = this.y;
        do {
            sb.insert(0, this.lines[yy]);
        } while (--yy >= 0 && this.connected[yy]);
        String s = Console.chomp(sb.toString().toUpperCase().substring(0, this.x + (this.y - yy - 1) * BLANK_LINE.length()), false);
        int xx = s.length() - 1;
        if (xx < 0) {
            return 16;
        }
        char t = s.charAt(xx);
        if (t >= 'A' && t <= 'Z' || t >= '0' && t <= '9' || t == '.') {
            while (xx >= 0) {
                t = s.charAt(xx);
                if (!(t >= 'A' && t <= 'Z' || t >= '0' && t <= '9' || t == '.')) break;
                --xx;
            }
            t = s.charAt(++xx);
            beforeType = t >= 'A' && t <= 'Z' ? 2 : 1;
            before = s.substring(xx);
            if (xx == 0 && beforeType == 1) {
                return 4;
            }
        } else {
            before = String.valueOf(t);
            beforeType = 3;
        }
        switch (beforeType) {
            case 3: {
                switch (before.charAt(0)) {
                    case '(': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '/': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '?': {
                        return 1;
                    }
                    case ')': {
                        return 10;
                    }
                    case ':': {
                        return 4;
                    }
                }
            }
            case 1: 
            case 2: {
                if (before.equals("GOTO") || before.equals("GOSUB") || before.equals("LIST")) {
                    return 32;
                }
                if (before.equals("IF") || before.equals("TO") || before.equals("AND") || before.equals("OR") || before.equals("SYNC") || before.equals("LOCATE")) {
                    return 1;
                }
                if (before.equals("THEN")) {
                    return 4;
                }
                return 10;
            }
        }
        return 4;
    }

    public void startInput() {
        EventLoop.instance.clear();
        this.showCursor = true;
        this.insert("? ");
        this.inputMode = true;
        this.inputX = this.x;
        this.inputY = this.y;
    }

    public void onKeyRelease(Key key) {
        if (this.imeMode) {
            return;
        }
        switch (key.keyCode) {
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.refreshContext();
            }
        }
    }

    public void refreshContext() {
        int ctx = this.getContext();
        if ((ctx & 2) > 0) {
            this.keyPage = 1;
            G.showMenu(this.funcKeys[this.keyPage], 150);
        }
        if ((ctx & 0x10) > 0) {
            this.funcKeys[2] = this.stmtHeadDirect;
            this.keyPage = 2;
            G.showMenu(this.funcKeys[this.keyPage], 100);
        } else if ((ctx & 4) > 0) {
            this.funcKeys[2] = this.stmtHeadProg;
            this.keyPage = 2;
            G.showMenu(this.funcKeys[this.keyPage], 100);
        }
        if ((ctx & 1) > 0) {
            this.keyPage = 0;
            G.showMenu(this.funcKeys[this.keyPage], 170);
        }
        if ((ctx & 0x20) > 0) {
            this.keyPage = 0;
            G.showMenu(this.funcKeys[this.keyPage], 170);
        }
    }

    public void startIME() {
        this.candidates = new Vector();
        this.in = new KeyInput();
        this.drawCandidates();
        this.imeMode = true;
        G.setInputMenu();
    }

    public void drawCandidates() {
        IMEw = G.sWidth / 2;
        G.setColor(0, 0, 0);
        G.fillRect(0, G.sHeight - 56, G.sWidth, 56);
        this.candidates = this.dict.getSetStartsWith(this.in);
        int yMax = this.candidates.size();
        if (this.IMEy >= yMax) {
            this.IMEy = yMax - 1;
        }
        int i = 0;
        while (i < this.candidates.size()) {
            this.drawCandidate(i);
            ++i;
        }
    }

    void drawCandidate(int idx) {
        if (idx < 0) {
            return;
        }
        int x = idx / 4 * IMEw + 5;
        int y = G.sHeight - 56 + idx % 4 * 14;
        String e = (String)this.candidates.get(idx);
        int col = idx == this.IMEy ? 255 : 0;
        G.setColor(col, col, col);
        G.fillRect(x, y, IMEw, 14);
        G.setColor(255 - col, 255 - col, 255 - col);
        G.drawString(e, x, y + 14);
    }

    public void onIMEKeyType(Key key) {
        this.moveY(0);
        switch (key.keyCode) {
            case 21: {
                this.candidates.insertElementAt(DIRECT, 0);
                this.IMEy = 0;
                this.endIME();
                return;
            }
            case 11: 
            case 20: {
                this.endIME();
                return;
            }
            case 10: 
            case 16: {
                this.in.removeLast();
                this.drawCandidates();
                return;
            }
            case 19: {
                this.moveY(1);
                break;
            }
            case 17: {
                this.moveY(-1);
                break;
            }
            case 18: {
                this.moveY(4);
            }
        }
        if (key.representChar() == '\u0000') {
            return;
        }
        this.in.add(key);
        this.drawCandidates();
    }

    private void moveY(int o) {
        int yMax = this.candidates.size();
        if (yMax == 0) {
            return;
        }
        if (yMax >= 8) {
            yMax = 8;
        }
        int old = this.IMEy;
        this.IMEy = (this.IMEy + o + yMax) % yMax;
        this.drawCandidate(old);
        this.drawCandidate(this.IMEy);
    }

    public void endIME() {
        G.setMainMenu();
        this.imeMode = false;
        G.showMenu(this.funcKeys[this.keyPage], 255);
        if (this.candidates.size() > 0) {
            String s = this.candidates.get(this.IMEy).toString();
            if (s.equals(DIRECT)) {
                Console.doInput();
                return;
            }
            G.clearAllScreen();
            this.draw();
            int i = s.indexOf("|");
            if (i >= 0) {
                s = s.substring(i + 1);
            }
            this.insert(s);
            G.redrawMenu();
        }
    }

    public void componentAction(Component c, int arg1, int arg2) {
        Display.setCurrent((Frame)G.wnd);
        String s = G.textBox.getText();
        this.draw();
        this.insert(s);
        G.redrawMenu();
        if (s.length() > 0) {
            this.dict.add(s);
        }
    }

    public static void doInput() {
        EventLoop.pressedKey = -1;
        Display.setCurrent((Frame)G.input);
    }
}

