/*
 * Decompiled with CFR 0.152.
 */
package inter;

import inter.BASICError;
import inter.Environment;
import inter.Interpreter;
import inter.StringTokenizer;
import util.Vector;

public class ProgLine {
    public int lineNo;
    public String content;
    public ProgLine next;
    public Vector code;

    public void init(Environment env, int lineNo, String content) throws BASICError {
        this.lineNo = lineNo;
        this.content = content;
        Interpreter in = new Interpreter(new StringTokenizer(content), env, this);
        in.parseStatements();
        this.code = in.code;
    }

    public ProgLine findInsertion(int lineNo) {
        ProgLine res = this;
        while (res.next != null) {
            if (res.next.lineNo >= lineNo) break;
            res = res.next;
        }
        return res;
    }

    public static void set(ProgLine prev, ProgLine adding) {
        ProgLine oldNext = prev.next;
        if (oldNext != null && oldNext.lineNo == adding.lineNo) {
            adding.next = oldNext.next;
            prev.next = adding;
        } else {
            prev.next = adding;
            adding.next = oldNext;
        }
    }

    public String toString() {
        return String.valueOf(this.lineNo) + " " + this.content;
    }
}

