/*
 * Decompiled with CFR 0.152.
 */
package inter;

import inter.Array;
import inter.BASICError;
import inter.Environment;
import inter.ForContext;
import inter.IntVariable;
import inter.ProgLine;
import inter.StringTokenizer;
import inter.StringVariable;
import inter.Variable;
import java.util.Hashtable;
import java.util.Random;
import ui.Console;
import ui.EventLoop;
import ui.G;
import ui.ICWindow;
import util.Vector;

public class Interpreter {
    public static final int OPOFS = Integer.MIN_VALUE;
    public static final int ADD = 1;
    public static final int SUB = 2;
    public static final int MUL = 3;
    public static final int DIV = 4;
    public static final int ARRAY = 5;
    public static final int ILET = 6;
    public static final int GOTO = 7;
    public static final int GOSUB = 8;
    public static final int END0 = 9;
    public static final int GT = 10;
    public static final int LT = 11;
    public static final int GE = 12;
    public static final int LE = 13;
    public static final int NE = 14;
    public static final int EQ = 15;
    public static final int INPUT = 16;
    public static final int IPRINT = 17;
    public static final int LIST = 18;
    public static final int LOAD = 19;
    public static final int SAVE = 20;
    public static final int RETURN = 21;
    public static final int NEG = 22;
    public static final int NOT = 23;
    public static final int CLS = 24;
    public static final int IDEREF = 25;
    public static final int POW = 1;
    public static final int OR = 27;
    public static final int AND = 28;
    public static final int STRCAT = 29;
    public static final int SLET = 30;
    public static final int STRCMP = 31;
    public static final int RND = 32;
    public static final int STRIG = 33;
    public static final int PSET = 34;
    public static final int LINE = 35;
    public static final int FOR = 36;
    public static final int NEXT = 37;
    public static final int LOCK = 38;
    public static final int UNLOCK = 39;
    public static final int GIPRINT = 40;
    public static final int COLORPAL = 41;
    public static final int PRINTLN = 42;
    public static final int SDEREF = 43;
    public static final int GSPRINT = 44;
    public static final int SPRINT = 45;
    public static final int TIME = 46;
    public static final int SYNC = 47;
    public static final int LOCATE = 48;
    public static final int WIDTH = 49;
    public static final int HEIGHT = 50;
    public static final int STOPOFF = 51;
    public static final int ABS = 52;
    public static final int MOD = 53;
    ProgLine progLine;
    public static Hashtable compares = null;
    public static Hashtable int1ParamFuncs = null;
    public Vector code = new Vector();
    public boolean stopOn = true;
    public ProgLine curLine;
    public ProgLine sigGoto;
    public ForContext sigNext;
    boolean sigReturn;
    StringTokenizer token;
    Environment env;
    public static final int TINT = 2;
    public static final int TSTRING = 3;
    public static final int TSINGLE = 4;
    public static final int TDOUBLE = 8;
    public static final int TNONE = 0;
    public static final int LINENORM = 0;
    public static final int LINEB = 1;
    public static final int LINEBF = 2;
    public static final int DEFCOL = -1;
    int px;
    int py;
    int col;
    static Random rnd = new Random();
    Object[] ostack = new Object[64];
    int[] istack = new int[64];
    int sp = 0;
    StringBuffer buf = new StringBuffer();
    static long lastSync = 0L;
    static int[] fstrig = new int[32];

    public Interpreter(StringTokenizer tokenizer, Environment env) {
        this.token = tokenizer;
        this.env = env;
        if (compares == null) {
            compares = new Hashtable();
            compares.put(">=", new Integer(12));
            compares.put("<=", new Integer(13));
            compares.put(">", new Integer(10));
            compares.put("<", new Integer(11));
            compares.put("<>", new Integer(14));
            compares.put("=", new Integer(15));
            int1ParamFuncs = new Hashtable();
            int1ParamFuncs.put("RND", new Integer(32));
            int1ParamFuncs.put("STRIG", new Integer(33));
            int1ParamFuncs.put("ABS", new Integer(52));
        }
    }

    public Interpreter(StringTokenizer tokenizer, Environment environment, ProgLine p) {
        this(tokenizer, environment);
        this.progLine = p;
    }

    public void addPush(Object o) {
        this.code.add(o);
    }

    public void addOpr(int i) {
        this.code.add(new Integer(i + Integer.MIN_VALUE));
    }

    public int parseExpr() {
        int ty = this.parseEA();
        while (this.token.nextTokenIf("OR")) {
            if (this.parseEA() != 2) {
                this.error("TM");
            }
            this.addOpr(27);
            ty = 2;
        }
        return ty;
    }

    public int parseEA() {
        int ty = this.parseCmp();
        while (this.token.nextTokenIf("AND")) {
            if (this.parseCmp() != 2) {
                this.error("TM");
            }
            this.addOpr(28);
            ty = 2;
        }
        return ty;
    }

    public int parseCmp() {
        int ty = this.parseAdd();
        int s = this.token.savePoint();
        String n = this.token.nextToken();
        Integer op = (Integer)compares.get(n);
        if (op != null) {
            int ty2 = this.parseAdd();
            if (ty != 2 || ty2 != 2) {
                if (ty != 3 || ty2 != 3) {
                    this.error("TM");
                }
                this.addOpr(31);
                this.addPush(new Integer(0));
            }
            this.addOpr(op);
            return 2;
        }
        this.token.restorePoint(s);
        return ty;
    }

    public int parseAdd() {
        int ty = this.parseMul();
        while (true) {
            if (this.token.nextTokenIf("+")) {
                int ty2 = this.parseMul();
                if (ty == 2 && ty2 == 2) {
                    this.addOpr(1);
                    ty = 2;
                    continue;
                }
                if (ty == 3 && ty2 == 3) {
                    this.addOpr(29);
                    ty = 3;
                    continue;
                }
                this.error("TM");
                continue;
            }
            if (!this.token.nextTokenIf("-")) break;
            if (ty != 2 || this.parseMul() != 2) {
                this.error("TM");
            }
            this.addOpr(2);
            ty = 2;
        }
        return ty;
    }

    public int parseMul() {
        int ty = this.parseUna();
        while (true) {
            if (this.token.nextTokenIf("*")) {
                if (this.parseUna() != 2) {
                    this.error("TM");
                }
                this.addOpr(3);
                ty = 2;
                continue;
            }
            if (this.token.nextTokenIf("/")) {
                if (this.parseUna() != 2) {
                    this.error("TM");
                }
                this.addOpr(4);
                ty = 2;
                continue;
            }
            if (!this.token.nextTokenIf("MOD")) break;
            if (this.parseUna() != 2) {
                this.error("TM");
            }
            this.addOpr(53);
            ty = 2;
        }
        return ty;
    }

    private int parseUna() {
        boolean neg = false;
        if (this.token.nextTokenIf("-")) {
            neg = true;
        }
        int ty = this.parsePow();
        if (neg) {
            if (ty == 2) {
                this.addOpr(22);
            } else {
                this.error("TM");
            }
        }
        return ty;
    }

    public int parsePow() {
        int ty = this.parseElem();
        while (this.token.nextTokenIf("^")) {
            if (this.parseElem() != 2) {
                this.error("TM");
            }
            this.addOpr(1);
            ty = 2;
        }
        return ty;
    }

    private int parseElem() {
        String t = this.token.nextToken();
        switch (this.token.tokenType()) {
            case 1: {
                this.addPush(new Integer(Integer.parseInt(t)));
                return 2;
            }
            case 2: {
                Integer op = (Integer)int1ParamFuncs.get(t);
                if (op != null) {
                    this.errorUnless("(");
                    this.parseExpr();
                    this.errorUnless(")");
                    this.addOpr(op);
                    return 2;
                }
                if (t.equals("TIME")) {
                    this.addOpr(46);
                    return 2;
                }
                if (t.equals("WIDTH")) {
                    this.addOpr(49);
                    return 2;
                }
                if (t.equals("HEIGHT")) {
                    this.addOpr(50);
                    return 2;
                }
                switch (this.parseVar(t)) {
                    case 2: {
                        this.addOpr(25);
                        return 2;
                    }
                    case 3: {
                        this.addOpr(43);
                        return 3;
                    }
                }
            }
            case 0: {
                this.addPush(t);
                return 3;
            }
            case 3: {
                if (!t.equals("(")) break;
                int ty = this.parseExpr();
                this.errorUnless(")");
                return ty;
            }
        }
        this.error("MO");
        return 0;
    }

    private int parseVar(String varName) {
        Variable v = this.env.getVar(varName);
        if (this.token.nextTokenIf("(")) {
            if (v instanceof Array) {
                Array ar = (Array)v;
                this.addPush(ar);
                if (this.parseExpr() != 2) {
                    this.error("TM");
                }
                this.addOpr(5);
                this.errorUnless(")");
                switch (ar.type) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                }
            }
        } else {
            this.addPush(v);
            if (v instanceof IntVariable) {
                return 2;
            }
            if (v instanceof StringVariable) {
                return 3;
            }
        }
        this.error("TM");
        return 0;
    }

    public void parseStatement() throws BASICError {
        block59: {
            String s = this.token.nextToken();
            if (s.equals("?")) {
                while (true) {
                    switch (this.parseExpr()) {
                        case 2: {
                            this.addOpr(17);
                            break;
                        }
                        case 3: {
                            this.addOpr(45);
                            break;
                        }
                        default: {
                            this.error("TM");
                        }
                    }
                    int p = this.token.savePoint();
                    String st = this.token.nextToken();
                    if (st.equals("") || st.equals(":")) {
                        this.token.restorePoint(p);
                        this.addOpr(42);
                        break block59;
                    }
                    if (st.equals(";")) {
                        int p2 = this.token.savePoint();
                        String n = this.token.nextToken();
                        this.token.restorePoint(p2);
                        if (!n.equals("") && !n.equals(":")) continue;
                        break block59;
                    }
                    this.token.restorePoint(p);
                }
            }
            if (s.equals("LOCATE")) {
                if (this.parseExpr() != 2) {
                    this.error("TM");
                }
                this.errorUnless(",");
                if (this.parseExpr() != 2) {
                    this.error("TM");
                }
                this.addOpr(48);
            } else if (s.equals("CLS")) {
                this.addOpr(24);
            } else if (s.equals("RUN")) {
                System.gc();
                this.stopOn = true;
                this.sp = 0;
                this.gosub(this.env.first);
                EventLoop.instance.clear();
            } else if (s.equals("GOTO")) {
                this.parseGoto();
            } else if (s.equals("GOSUB")) {
                this.parseGosub();
            } else if (s.equals("RETURN")) {
                this.parseReturn();
            } else if (s.equals("LIST")) {
                this.parseList();
            } else if (s.equals("IF")) {
                this.parseIf();
            } else if (s.equals("SAVE")) {
                this.parseSave();
            } else if (s.equals("LOAD")) {
                this.parseLoad();
            } else if (s.equals("INPUT")) {
                this.parseInput();
            } else if (s.equals("DIM")) {
                this.parseDim();
            } else if (s.equals("PSET")) {
                this.parsePset();
            } else if (s.equals("LINE")) {
                this.parseLine();
            } else if (s.equals("GPRINT")) {
                this.parseGPrint();
            } else if (s.equals("FOR")) {
                this.parseFor();
            } else if (s.equals("LOCK")) {
                this.addOpr(38);
            } else if (s.equals("NEXT")) {
                this.addOpr(37);
            } else if (s.equals("UNLOCK")) {
                this.addOpr(39);
            } else if (s.equals("COLOR")) {
                this.parseColor();
            } else if (s.equals("SYNC")) {
                this.parseExpr();
                this.addOpr(47);
            } else if (s.equals("STOP")) {
                if (this.token.nextTokenIf("OFF")) {
                    this.addOpr(51);
                } else {
                    this.error("SN");
                }
            } else if (!s.equals("REM")) {
                if (this.token.tokenType() == 2) {
                    this.parseLet(s);
                } else {
                    this.error("SN");
                }
            }
        }
    }

    private void parseColor() {
        this.errorUnless("=");
        this.errorUnless("(");
        this.parseExpr();
        this.errorUnless(",");
        this.parseExpr();
        this.errorUnless(",");
        this.parseExpr();
        this.errorUnless(",");
        this.parseExpr();
        this.errorUnless(")");
        this.addOpr(41);
    }

    private void parseFor() {
        String t = this.errorUnless(2);
        Variable v = this.env.getVar(t);
        if (!(v instanceof IntVariable)) {
            this.error("TM");
        }
        this.addPush(v);
        this.errorUnless("=");
        if (this.parseExpr() != 2) {
            this.error("TM");
        }
        this.addOpr(6);
        this.errorUnless("TO");
        ForContext fc = new ForContext();
        this.addPush(fc);
        this.parseExpr();
        if (this.token.nextTokenIf("STEP")) {
            this.parseExpr();
        } else {
            this.addPush(new Integer(1));
        }
        this.addOpr(36);
        fc.loop = (IntVariable)v;
        fc.line = this.progLine;
        fc.offset = this.code.size();
    }

    private void parsePset() {
        this.errorUnless("(");
        this.parseExpr();
        this.errorUnless(",");
        this.parseExpr();
        this.errorUnless(")");
        if (this.token.nextTokenIf(",")) {
            this.parseExpr();
        } else {
            this.addPush(new Integer(-1));
        }
        this.addOpr(34);
    }

    private void parseLine() {
        int mode = 0;
        int step = 0;
        String t = "";
        if (this.token.nextTokenIf("(")) {
            this.parseExpr();
            this.errorUnless(",");
            this.parseExpr();
            this.errorUnless(")");
            this.addPush(new Integer(-1));
            this.addOpr(34);
        }
        this.errorUnless("-");
        if (this.token.nextTokenIf("STEP")) {
            step = 1;
        }
        this.addPush(new Integer(step));
        this.errorUnless("(");
        this.parseExpr();
        this.errorUnless(",");
        this.parseExpr();
        this.errorUnless(")");
        if (this.token.nextTokenIf(",")) {
            if (this.token.nextTokenIf(",")) {
                this.addPush(new Integer(-1));
                t = this.token.nextToken();
            } else {
                this.parseExpr();
                if (this.token.nextTokenIf(",")) {
                    t = this.token.nextToken();
                }
            }
        } else {
            this.addPush(new Integer(-1));
        }
        if (t.equals("BF")) {
            mode = 2;
        }
        if (t.equals("B")) {
            mode = 1;
        }
        this.addPush(new Integer(mode));
        this.addOpr(35);
    }

    private void parseGPrint() {
        while (true) {
            switch (this.parseExpr()) {
                case 2: {
                    this.addOpr(40);
                    break;
                }
                case 3: {
                    this.addOpr(44);
                    break;
                }
                default: {
                    this.error("TM");
                }
            }
            int p = this.token.savePoint();
            String st = this.token.nextToken();
            if (st.equals("") || st.equals(":")) {
                this.token.restorePoint(p);
                break;
            }
            if (st.equals(";")) {
                int p2 = this.token.savePoint();
                String n = this.token.nextToken();
                this.token.restorePoint(p2);
                if (!n.equals("") && !n.equals(":")) continue;
                break;
            }
            this.token.restorePoint(p);
        }
    }

    private void parseDim() throws BASICError {
        String varName = this.errorUnless(2);
        this.errorUnless("(");
        String s = this.errorUnless(1);
        int sz = Integer.parseInt(s);
        if (sz < 0) {
            this.error("BS");
        }
        this.errorUnless(")");
        if (!(this.env.variables.get(varName) instanceof Array)) {
            this.env.variables.put(varName, new Array(sz, varName.endsWith("$") ? 1 : 0));
        }
    }

    private void parseInput() throws BASICError {
        String s = this.errorUnless(2);
        this.parseVar(s);
        this.addOpr(16);
    }

    private void error(String errorCode) throws BASICError {
        this.env.error(errorCode);
    }

    private void parseLoad() {
        String t = this.token.nextToken();
        this.addPush(t);
        this.addOpr(19);
    }

    private void parseSave() {
        String t = this.token.nextToken();
        this.addPush(t);
        this.addOpr(20);
    }

    private void parseIf() throws BASICError {
        if (this.parseExpr() != 2) {
            this.error("TM");
        }
        this.addOpr(9);
    }

    private void parseGoto() {
        String t = this.token.nextToken();
        if (this.token.tokenType() == 1) {
            this.addPush(new Integer(Integer.parseInt(t)));
            this.addOpr(7);
        } else {
            this.error("UL");
        }
    }

    private void parseGosub() {
        String t = this.token.nextToken();
        if (this.token.tokenType() == 1) {
            this.addPush(new Integer(Integer.parseInt(t)));
            this.addOpr(8);
        } else {
            this.error("UL");
        }
    }

    private void parseReturn() {
        this.addOpr(21);
    }

    public ProgLine findExact(int i) {
        ProgLine res = this.env.first;
        while (res != null) {
            if (res.lineNo == i) {
                return res;
            }
            res = res.next;
        }
        this.error("UL");
        return null;
    }

    private void parseList() {
        int b = 0;
        int e = Integer.MAX_VALUE;
        String s = this.token.nextTokenIf(1);
        if (s != null) {
            e = b = Integer.parseInt(s);
        }
        if (this.token.nextTokenIf("-")) {
            s = this.token.nextTokenIf(1);
            e = s != null ? Integer.parseInt(s) : Integer.MAX_VALUE;
        }
        this.addPush(new Integer(b));
        this.addPush(new Integer(e));
        this.addOpr(18);
    }

    public void parseLet(String varName) throws BASICError {
        this.parseVar(varName);
        String s = this.token.nextToken();
        if (s.equals("=")) {
            int ty = this.parseExpr();
            switch (ty) {
                case 2: {
                    this.addOpr(6);
                    break;
                }
                case 3: {
                    this.addOpr(30);
                    break;
                }
                default: {
                    this.error("TM");
                    break;
                }
            }
        } else {
            this.error("SN");
        }
    }

    public void parseStatements() throws BASICError {
        int sv;
        String t;
        do {
            this.parseStatement();
            sv = this.token.savePoint();
        } while ((t = this.token.nextToken()).equals(":") || t.equals("THEN"));
        this.token.restorePoint(sv);
    }

    public String errorUnless(int type) {
        String t = this.token.nextToken();
        if (this.token.tokenType() != type) {
            this.error("MO");
        }
        return t;
    }

    public String errorUnless(String tk) {
        String t = this.token.nextToken();
        if (!t.equals(tk)) {
            this.error("SN");
        }
        return t;
    }

    public void gosub(ProgLine line) throws BASICError {
        ProgLine sc = this.curLine;
        StringTokenizer t = this.token;
        this.curLine = line;
        int ofs = 0;
        while (this.curLine != null && !this.sigReturn) {
            this.exe(this.curLine.code, ofs);
            if (this.sigGoto != null) {
                this.curLine = this.sigGoto;
                ofs = 0;
                this.sigGoto = null;
            } else if (this.sigNext != null) {
                this.curLine = this.sigNext.line;
                ofs = this.sigNext.offset;
                this.sigNext = null;
            } else {
                this.curLine = this.curLine.next;
                ofs = 0;
            }
            this.checkBreak();
        }
        this.sigReturn = false;
        this.curLine = sc;
        this.token = t;
    }

    public void gosub(int i) {
        this.gosub(this.findExact(i));
    }

    public void checkBreak() {
        if (this.stopOn && ICWindow.instance.getKeypadState() == 1) {
            EventLoop.instance.clear();
            G.unlockForce();
            this.error("Break");
        }
    }

    public void exe(Vector code, int ofs) {
        int i = ofs;
        while (i < code.size()) {
            block92: {
                Object o;
                block93: {
                    o = code.get(i);
                    if (!(o instanceof Integer)) break block93;
                    int ci = (Integer)o;
                    block3 : switch (ci - Integer.MIN_VALUE) {
                        case 24: {
                            Console.current.cls();
                            Console.current.draw();
                            break;
                        }
                        case 1: {
                            int n = this.sp - 2;
                            this.istack[n] = this.istack[n] + this.istack[this.sp - 1];
                            --this.sp;
                            break;
                        }
                        case 27: {
                            int n = this.sp - 2;
                            this.istack[n] = this.istack[n] | this.istack[this.sp - 1];
                            --this.sp;
                            break;
                        }
                        case 28: {
                            int n = this.sp - 2;
                            this.istack[n] = this.istack[n] & this.istack[this.sp - 1];
                            --this.sp;
                            break;
                        }
                        case 29: {
                            this.ostack[this.sp - 2] = String.valueOf(this.ostack[this.sp - 2].toString()) + this.ostack[this.sp - 1].toString();
                            --this.sp;
                            break;
                        }
                        case 2: {
                            int n = this.sp - 2;
                            this.istack[n] = this.istack[n] - this.istack[this.sp - 1];
                            --this.sp;
                            break;
                        }
                        case 31: {
                            this.istack[this.sp - 2] = this.ostack[this.sp - 2].toString().compareTo(this.ostack[this.sp - 1].toString());
                            --this.sp;
                            break;
                        }
                        case 3: {
                            int n = this.sp - 2;
                            this.istack[n] = this.istack[n] * this.istack[this.sp - 1];
                            --this.sp;
                            break;
                        }
                        case 4: {
                            int n = this.sp - 2;
                            this.istack[n] = this.istack[n] / this.istack[this.sp - 1];
                            --this.sp;
                            break;
                        }
                        case 53: {
                            int n = this.sp - 2;
                            this.istack[n] = this.istack[n] % this.istack[this.sp - 1];
                            --this.sp;
                            break;
                        }
                        case 5: {
                            Array ar = (Array)this.ostack[this.sp - 2];
                            int idx = this.istack[this.sp - 1];
                            Variable v = ar.getAt(idx);
                            this.ostack[this.sp - 2] = v;
                            --this.sp;
                            break;
                        }
                        case 6: {
                            ((IntVariable)this.ostack[this.sp - 2]).i = this.istack[this.sp - 1];
                            this.sp -= 2;
                            break;
                        }
                        case 30: {
                            ((Variable)this.ostack[this.sp - 2]).set((String)this.ostack[this.sp - 1]);
                            this.sp -= 2;
                            break;
                        }
                        case 25: {
                            this.istack[this.sp - 1] = ((IntVariable)this.ostack[this.sp - 1]).i;
                            break;
                        }
                        case 43: {
                            this.ostack[this.sp - 1] = ((Variable)this.ostack[this.sp - 1]).getValue();
                            break;
                        }
                        case 7: {
                            this.sigGoto = this.findExact(this.istack[this.sp - 1]);
                            --this.sp;
                            return;
                        }
                        case 8: {
                            this.gosub(this.istack[this.sp - 1]);
                            --this.sp;
                            break;
                        }
                        case 9: {
                            if (this.istack[--this.sp] == 0) {
                                return;
                            }
                            break block92;
                        }
                        case 10: {
                            this.istack[this.sp - 2] = this.istack[this.sp - 2] > this.istack[this.sp - 1] ? -1 : 0;
                            --this.sp;
                            break;
                        }
                        case 11: {
                            this.istack[this.sp - 2] = this.istack[this.sp - 2] < this.istack[this.sp - 1] ? -1 : 0;
                            --this.sp;
                            break;
                        }
                        case 12: {
                            this.istack[this.sp - 2] = this.istack[this.sp - 2] >= this.istack[this.sp - 1] ? -1 : 0;
                            --this.sp;
                            break;
                        }
                        case 13: {
                            this.istack[this.sp - 2] = this.istack[this.sp - 2] <= this.istack[this.sp - 1] ? -1 : 0;
                            --this.sp;
                            break;
                        }
                        case 14: {
                            this.istack[this.sp - 2] = this.istack[this.sp - 2] != this.istack[this.sp - 1] ? -1 : 0;
                            --this.sp;
                            break;
                        }
                        case 15: {
                            this.istack[this.sp - 2] = this.istack[this.sp - 2] == this.istack[this.sp - 1] ? -1 : 0;
                            --this.sp;
                            break;
                        }
                        case 16: {
                            Variable v = (Variable)this.ostack[--this.sp];
                            EventLoop.instance.aborter = null;
                            Console.current.startInput();
                            EventLoop.instance.run();
                            String inp = (String)EventLoop.instance.aborter;
                            EventLoop.instance.aborter = null;
                            v.set(inp);
                            break;
                        }
                        case 17: {
                            this.buf.delete(0, this.buf.length());
                            this.buf.append(this.istack[--this.sp]);
                            Console.current.print(this.buf.toString(), false);
                            break;
                        }
                        case 45: {
                            Console.current.print(this.ostack[--this.sp].toString(), false);
                            break;
                        }
                        case 42: {
                            Console.current.print("");
                            break;
                        }
                        case 18: {
                            this.stopOn = true;
                            int b = this.istack[this.sp - 2];
                            int e = this.istack[this.sp - 1];
                            this.sp -= 2;
                            ProgLine p = this.env.first;
                            while (p != null) {
                                if (p.lineNo <= e) {
                                    if (p.lineNo >= b) {
                                        Console.current.print(p.toString());
                                    }
                                    this.checkBreak();
                                    while (ICWindow.instance.getKeypadState() != 0) {
                                        try {
                                            Thread.sleep(20L);
                                            this.checkBreak();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                    p = p.next;
                                    continue;
                                }
                                break block92;
                            }
                            break block92;
                        }
                        case 19: {
                            String t;
                            if (this.env.modified) {
                                Console.current.print("\u30d7\u30ed\u30b0\u30e9\u30e0\u304c\u4fdd\u5b58\u3055\u308c\u3066\u3044\u307e\u305b\u3093!");
                                Console.current.print("0:Cancel/1:Continue Loading");
                                while (ICWindow.instance.getKeypadState() != 2) {
                                    this.checkBreak();
                                    try {
                                        Thread.sleep(17L);
                                    }
                                    catch (Exception p) {
                                        // empty catch block
                                    }
                                }
                            }
                            if ((t = this.ostack[--this.sp].toString()).equals("")) {
                                this.env.loadFromScratchPad(0);
                            } else {
                                Console.current.print(this.env.loadFromNetwork(t));
                            }
                            Console.current.initDict();
                            break;
                        }
                        case 20: {
                            String t;
                            if (this.env.first == null) {
                                Console.current.print("Empty program. not Saved.");
                                break;
                            }
                            if ((t = this.ostack[--this.sp].toString()).equals("")) {
                                this.env.saveToScratchPad(0);
                                return;
                            }
                            Console.current.print(this.env.saveToNetwork(t));
                            break;
                        }
                        case 21: {
                            this.sigReturn = true;
                            return;
                        }
                        case 22: {
                            this.istack[this.sp - 1] = -this.istack[this.sp - 1];
                            break;
                        }
                        case 23: {
                            this.istack[this.sp - 1] = this.istack[this.sp - 1] == 0 ? -1 : 0;
                            break;
                        }
                        case 32: {
                            if (this.istack[this.sp - 1] > 0) {
                                this.istack[this.sp - 1] = (rnd.nextInt() & 0x3FFFFFFF) / (0x40000000 / this.istack[this.sp - 1]);
                                break;
                            }
                            rnd = new Random(-this.istack[this.sp - 1]);
                            break;
                        }
                        case 52: {
                            if (this.istack[this.sp - 1] < 0) {
                                this.istack[this.sp - 1] = -this.istack[this.sp - 1];
                                break;
                            }
                            break block92;
                        }
                        case 33: {
                            this.istack[this.sp - 1] = this.strig(this.istack[this.sp - 1]);
                            break;
                        }
                        case 34: {
                            int c = this.istack[this.sp - 1];
                            if (c == -1) {
                                c = this.col;
                            } else {
                                this.col = c;
                            }
                            this.py = this.istack[this.sp - 2];
                            this.px = this.istack[this.sp - 3];
                            G.setColor(c);
                            this.sp -= 3;
                            break;
                        }
                        case 35: {
                            int mode = this.istack[this.sp - 1];
                            int c = this.istack[this.sp - 2];
                            if (c == -1) {
                                c = this.col;
                            } else {
                                this.col = c;
                            }
                            int y = this.istack[this.sp - 3];
                            int x = this.istack[this.sp - 4];
                            int step = this.istack[this.sp - 5];
                            if (step == 1) {
                                x += this.px;
                                y += this.py;
                            }
                            G.setColor(c);
                            switch (mode) {
                                case 0: {
                                    G.drawLine(this.px, this.py, x - this.px, y - this.py);
                                    break;
                                }
                                case 1: {
                                    G.drawRect(this.px, this.py, x - this.px, y - this.py);
                                    break;
                                }
                                case 2: {
                                    G.fillRect(this.px, this.py, x - this.px, y - this.py);
                                }
                            }
                            this.px = x;
                            this.py = y;
                            this.sp -= 5;
                            break;
                        }
                        case 40: {
                            G.setColor(this.col);
                            this.buf.delete(0, this.buf.length());
                            this.buf.append(this.istack[--this.sp]);
                            this.px += G.drawString(this.buf.toString(), this.px, this.py);
                            break;
                        }
                        case 44: {
                            G.setColor(this.col);
                            this.px += G.drawString(this.ostack[--this.sp].toString(), this.px, this.py);
                            break;
                        }
                        case 41: {
                            G.setColorPal(this.istack[this.sp - 4], this.istack[this.sp - 3], this.istack[this.sp - 2], this.istack[this.sp - 1]);
                            this.sp -= 4;
                            break;
                        }
                        case 38: {
                            G.lock();
                            break;
                        }
                        case 39: {
                            G.unlock();
                            break;
                        }
                        case 36: {
                            ForContext fc = (ForContext)this.ostack[this.sp - 3];
                            fc.to = this.istack[this.sp - 2];
                            fc.step = this.istack[this.sp - 1];
                            this.sp -= 2;
                            break;
                        }
                        case 37: {
                            if (this.sp == 0) {
                                this.error("NF");
                            }
                            if (!(this.ostack[this.sp - 1] instanceof ForContext)) {
                                this.error("NF");
                            }
                            this.sigNext = (ForContext)this.ostack[this.sp - 1];
                            this.sigNext.loop.set(this.sigNext.loop.i + this.sigNext.step);
                            if (this.sigNext.step > 0 && this.sigNext.loop.i <= this.sigNext.to || this.sigNext.step <= 0 && this.sigNext.loop.i >= this.sigNext.to) {
                                return;
                            }
                            this.sigNext = null;
                            --this.sp;
                            break;
                        }
                        case 46: {
                            this.istack[this.sp++] = (int)System.currentTimeMillis() & Integer.MAX_VALUE;
                            break;
                        }
                        case 49: {
                            this.istack[this.sp++] = G.sWidth;
                            break;
                        }
                        case 50: {
                            this.istack[this.sp++] = G.sHeight;
                            break;
                        }
                        case 47: {
                            if (lastSync == 0L) {
                                lastSync = System.currentTimeMillis();
                            }
                            try {
                                lastSync += (long)this.istack[--this.sp];
                                while (true) {
                                    long restT;
                                    if ((restT = lastSync - System.currentTimeMillis()) <= 0L) {
                                        if (restT <= 1000L) {
                                            lastSync = System.currentTimeMillis();
                                            break block3;
                                        }
                                        break block92;
                                    }
                                    if (restT > 17L) {
                                        restT = 17L;
                                    }
                                    Thread.sleep(restT);
                                    this.checkBreak();
                                }
                            }
                            catch (Exception exception) {
                                break;
                            }
                        }
                        case 48: {
                            Console.current.locate(this.istack[this.sp - 2], this.istack[this.sp - 1]);
                            this.sp -= 2;
                            break;
                        }
                        case 51: {
                            this.stopOn = false;
                            break;
                        }
                        default: {
                            this.istack[this.sp++] = ci;
                            break;
                        }
                    }
                    break block92;
                }
                this.ostack[this.sp++] = o;
            }
            ++i;
        }
    }

    private int strig(int i) {
        if ((ICWindow.instance.getKeypadState() & 1 << i) != 0) {
            int n = i;
            fstrig[n] = fstrig[n] + 1;
        } else {
            Interpreter.fstrig[i] = 0;
        }
        return fstrig[i];
    }

    public void dispCode() {
        int t = 0;
        while (t < this.code.size()) {
            Object e = this.code.get(t);
            if (e instanceof Integer) {
                Integer in = (Integer)e;
                String c = "";
                switch (in - Integer.MIN_VALUE) {
                    case 24: {
                        c = "CLS";
                        break;
                    }
                    case 1: {
                        c = "ADD";
                        break;
                    }
                    case 2: {
                        c = "SUB";
                        break;
                    }
                    case 3: {
                        c = "MUL";
                        break;
                    }
                    case 4: {
                        c = "DIV";
                        break;
                    }
                    case 5: {
                        c = "ARRAY";
                        break;
                    }
                    case 6: {
                        c = "ILET";
                        break;
                    }
                    case 25: {
                        c = "IDEREF";
                        break;
                    }
                    case 43: {
                        c = "SDEREF";
                        break;
                    }
                    case 7: {
                        c = "GOTO";
                        break;
                    }
                    case 8: {
                        c = "GOSUB";
                        break;
                    }
                    case 9: {
                        c = "END0";
                        break;
                    }
                    case 10: {
                        c = "GT";
                        break;
                    }
                    case 11: {
                        c = "LT";
                        break;
                    }
                    case 12: {
                        c = "GE";
                        break;
                    }
                    case 13: {
                        c = "LE";
                        break;
                    }
                    case 14: {
                        c = "NE";
                        break;
                    }
                    case 15: {
                        c = "EQ";
                        break;
                    }
                    case 16: {
                        c = "INPUT";
                        break;
                    }
                    case 17: {
                        c = "IPRINT";
                        break;
                    }
                    case 45: {
                        c = "SPRINT";
                        break;
                    }
                    case 42: {
                        c = "PRINTLN";
                        break;
                    }
                    case 18: {
                        c = "LIST";
                        break;
                    }
                    case 19: {
                        c = "LOAD";
                        break;
                    }
                    case 20: {
                        c = "SAVE";
                        break;
                    }
                    case 21: {
                        c = "RETURN";
                        break;
                    }
                    case 22: {
                        c = "NEG";
                        break;
                    }
                    case 23: {
                        c = "NOT";
                        break;
                    }
                    case 30: {
                        c = "LET";
                        break;
                    }
                    case 29: {
                        c = "STRCAT";
                        break;
                    }
                    case 31: {
                        c = "STRCMP";
                        break;
                    }
                    case 34: {
                        c = "PSET";
                        break;
                    }
                    case 35: {
                        c = "LINE";
                        break;
                    }
                    case 37: {
                        c = "NEXT";
                        break;
                    }
                    case 38: {
                        c = "LOCK";
                        break;
                    }
                    case 39: {
                        c = "UNLOCK";
                        break;
                    }
                    case 46: {
                        c = "TIME";
                    }
                    default: {
                        c = in.toString();
                    }
                }
            }
            ++t;
        }
    }
}

