/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sowba.dtd2java;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.sowba.dtd2java.Dtd2JavaUtil;
import jp.sourceforge.sowba.dtd2java.Recipe;
import jp.sourceforge.sowba.dtd2java.dtd.AttributeObject;
import jp.sourceforge.sowba.dtd2java.dtd.ContextObject;
import jp.sourceforge.sowba.dtd2java.dtd.ElementObject;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dtd2Java
implements Runnable {
    private static final Pattern C_P1 = Pattern.compile("<!ELEMENT\\s+([^\\s]+)\\s+(.*)>");
    private static final Pattern C_P2 = Pattern.compile("<!ATTLIST\\s+([^\\s]+)\\s+(.*)>");
    private static final Pattern C_P3 = Pattern.compile("(.*)(\\()(.+?)(\\))(.*)");
    private ContextObject m_context;
    private Recipe m_recipe;

    public static void main(String[] args) {
        try {
            Dtd2Java me = new Dtd2Java();
            Recipe recipe = new Recipe();
            int i = 0;
            while (i < args.length) {
                String expression;
                String[] tokens;
                if (args[i].equalsIgnoreCase("-i") && i <= args.length - 2) {
                    recipe.setDtdPath(args[++i]);
                } else if (args[i].equalsIgnoreCase("-d") && i <= args.length - 2) {
                    recipe.setOutputDir(args[++i]);
                } else if (args[i].equalsIgnoreCase("-p") && i <= args.length - 2) {
                    recipe.setPackageName(args[++i]);
                } else if (args[i].equalsIgnoreCase("-t") && i <= args.length - 2) {
                    recipe.setTemplateDir(args[++i]);
                } else if (args[i].equalsIgnoreCase("-bv") && i <= args.length - 2) {
                    recipe.setBeansVmName(args[++i]);
                } else if (args[i].equalsIgnoreCase("-fv") && i <= args.length - 2) {
                    recipe.setFactoryVmName(args[++i]);
                } else if (args[i].equalsIgnoreCase("-f") && i <= args.length - 2) {
                    recipe.setFactoryName(args[++i]);
                } else if (args[i].equalsIgnoreCase("-k") && i <= args.length - 2) {
                    if ((tokens = (expression = args[++i]).split("=")).length != 2) {
                        recipe.setDtdPath(null);
                        break;
                    }
                    recipe.getKeyMap().put(tokens[0], tokens[1]);
                } else if (args[i].equalsIgnoreCase("-ra") && i <= args.length - 2) {
                    if ((tokens = (expression = args[++i]).split("=")).length != 2) {
                        recipe.setDtdPath(null);
                        break;
                    }
                    recipe.getReplacingAttributeMap().put(tokens[0], tokens[1]);
                } else if (args[i].equalsIgnoreCase("-cp") && i <= args.length - 2) {
                    recipe.setClassPrefix(args[++i]);
                } else if (args[i].equalsIgnoreCase("-cs") && i <= args.length - 2) {
                    recipe.setClassSuffix(args[++i]);
                } else if (args[i].equalsIgnoreCase("-cache")) {
                    recipe.setCache(true);
                } else if (args[i].equalsIgnoreCase("-generics")) {
                    recipe.setGenerics(true);
                }
                ++i;
            }
            me.setRecipe(recipe);
            if (!me.validateParameter()) {
                System.out.println("usage:");
                System.out.println("java jp.sourceforge.sowba.dtd2java.Dtd2Java -i DTD\u30d1\u30b9 -d \u30bd\u30fc\u30b9\u30d1\u30b9 -p \u30d1\u30c3\u30b1\u30fc\u30b8\u540d");
                System.out.println("  -t \u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea -bv \u30d3\u30fc\u30f3\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8 -fv \u30d5\u30a1\u30af\u30c8\u30ea\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8");
                System.out.println("  [-f \u30d5\u30a1\u30af\u30c8\u30ea\u540d] [-k \u8981\u7d20\u540d=\u5c5e\u6027\u540d]...");
                System.out.println("");
                System.out.println("    -i  DTD\u306e\u30d5\u30eb\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                System.out.println("");
                System.out.println("    -d  \u751f\u6210\u3059\u308bJava\u30bd\u30fc\u30b9\u306e\u51fa\u529b\u5148\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                System.out.println("        \u3053\u3053\u3067\u6307\u5b9a\u3057\u305f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4ee5\u4e0b\u306b\u30d1\u30c3\u30b1\u30fc\u30b8\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002");
                System.out.println("");
                System.out.println("    -p  \u30d1\u30c3\u30b1\u30fc\u30b8\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                System.out.println("");
                System.out.println("    -t  Velocity\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3092\u683c\u7d0d\u3057\u305f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                System.out.println("");
                System.out.println("    -bv \u30d3\u30fc\u30f3\u3092\u751f\u6210\u3059\u308b\u70ba\u306e\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                System.out.println("");
                System.out.println("    -fv \u30d5\u30a1\u30af\u30c8\u30ea\u3092\u751f\u6210\u3059\u308b\u70ba\u306e\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                System.out.println("");
                System.out.println("    -f  \u30d5\u30a1\u30af\u30c8\u30ea\u306e\u30af\u30e9\u30b9\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                System.out.println("        \u30d1\u30c3\u30b1\u30fc\u30b8\u540d\u306f\u4e0d\u8981\u3067\u3059\u3002");
                System.out.println("        \u6307\u5b9a\u3055\u308c\u306a\u304b\u3063\u305f\u5834\u5408\u306f\u3001XmlObjectFactory\u3068\u3057\u307e\u3059\u3002");
                System.out.println("");
                System.out.println("    -k  \u8981\u7d20\u306e\u30ad\u30fc\u5c5e\u6027\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u8907\u6570\u5b9a\u7fa9\u53ef\u80fd\u3067\u3059\u3002");
                System.out.println("");
                System.out.println("    -ra \u5c5e\u6027\u306b\u5bfe\u5fdc\u3059\u308b\u30d7\u30ed\u30d1\u30c6\u30a3\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u8907\u6570\u5b9a\u7fa9\u53ef\u80fd\u3067\u3059\u3002");
                System.out.println("");
                System.out.println("    -cp \u30d3\u30fc\u30f3\u30af\u30e9\u30b9\u540d\u306e\u30d7\u30ea\u30d5\u30a3\u30c3\u30af\u30b9\u3067\u3059\u3002");
                System.out.println("");
                System.out.println("    -cs \u30d3\u30fc\u30f3\u30af\u30e9\u30b9\u540d\u306e\u30b5\u30d5\u30a3\u30c3\u30af\u30b9\u3067\u3059\u3002");
                System.out.println("");
                System.out.println("    -cache \u751f\u6210\u3057\u305f\u30d3\u30fc\u30f3\u3092\u30ad\u30e3\u30c3\u30b7\u30e5\u3059\u308b\u3088\u3046\u306b\u3057\u307e\u3059\u3002");
                System.out.println("");
                System.out.println("    -generics \u751f\u6210\u3059\u308b\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u3067generics\u3092\u4f7f\u3046\u3088\u3046\u306b\u3057\u307e\u3059\u3002");
                return;
            }
            me.run();
            Dtd2JavaUtil util = new Dtd2JavaUtil(recipe);
            System.out.println("\u30af\u30e9\u30b9\u3092\u751f\u6210\u3057\u307e\u3057\u305f\u3002\u30d1\u30b9[" + recipe.getOutputDir() + "]");
            ElementObject[] elems = me.getContext().getElements();
            int i2 = 0;
            while (i2 < elems.length) {
                System.out.println("    " + recipe.getPackageName() + "." + util.getClassName(elems[i2].getName()));
                ++i2;
            }
            System.out.println("    " + recipe.getPackageName() + "." + recipe.getFactoryName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void analyzeChildElements(TreeSet<String> childmap, ContextObject context, String text) {
        Matcher m1;
        int nameidx = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        while ((m1 = C_P3.matcher(text)).matches()) {
            String name = "__P__" + nameidx;
            ++nameidx;
            text = String.valueOf(m1.group(1)) + name + m1.group(5);
            String v = m1.group(3);
            map.put(name, v);
        }
        this.analyzeChildElementsSub01(childmap, context, text, map, false);
    }

    private void analyzeChildElementsSub01(TreeSet<String> childmap, ContextObject context, String s, Map placeHolderMap, boolean forceMultiple) {
        Pattern p1 = Pattern.compile("(.*)([\\*\\?\\+])");
        String[] tokens = s.split("[,|]");
        int i = 0;
        while (i < tokens.length) {
            String value;
            String token = tokens[i].trim();
            String indicator = forceMultiple ? "*" : "";
            Matcher m1 = p1.matcher(token);
            if (m1.matches()) {
                token = m1.group(1);
                indicator = m1.group(2);
                if (indicator.matches("[\\*\\+]")) {
                    indicator = "*";
                }
            }
            if ((value = (String)placeHolderMap.get(token)) != null) {
                this.analyzeChildElementsSub01(childmap, context, value, placeHolderMap, indicator.equals("*"));
            } else {
                childmap.add(token);
                ElementObject elem = context.getElement(token);
                if (indicator.equals("*")) {
                    elem.setIndicator("*");
                }
            }
            ++i;
        }
    }

    private void analyzeDtd(ContextObject context, String dtdpath) throws FileNotFoundException, IOException {
        String line;
        String content = this.createContent(dtdpath);
        BufferedReader reader = new BufferedReader(new StringReader(content));
        while ((line = reader.readLine()) != null) {
            Matcher m1 = C_P1.matcher(line = line.trim());
            if (m1.matches()) {
                String elementDef = m1.group(1);
                String childrenDef = m1.group(2);
                ElementObject elem = context.getElement(elementDef);
                String ct = childrenDef.trim();
                if (ct.equalsIgnoreCase("EMPTY")) continue;
                if (ct.matches(".*\\(#PCDATA\\).*") || ct.equalsIgnoreCase("ANY")) {
                    elem.setHasBody(true);
                    continue;
                }
                TreeSet<String> childmap = new TreeSet<String>();
                this.analyzeChildElements(childmap, context, childrenDef);
                Iterator<String> k = childmap.iterator();
                while (k.hasNext()) {
                    ElementObject child = context.getElement(k.next());
                    elem.addChild(child.getName(), child);
                }
                continue;
            }
            Matcher m2 = C_P2.matcher(line);
            if (!m2.matches()) continue;
            String elementDef = m2.group(1);
            String attlistDef = m2.group(2);
            ElementObject element = context.getElement(elementDef);
            attlistDef = attlistDef.replaceAll("\\\".*?\\\"", "_DQUOT_");
            attlistDef = attlistDef.replaceAll("\\(.*?\\)", "_PAREN_");
            StringTokenizer tokenizer = new StringTokenizer(attlistDef, " ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equalsIgnoreCase("CDATA") || token.equalsIgnoreCase("#REQUIRED") || token.equalsIgnoreCase("#FIXED") || token.equalsIgnoreCase("#IMPLIED") || token.equalsIgnoreCase("_DQUOT_") || token.equalsIgnoreCase("_PAREN_")) continue;
                element.addAttribute(token, new AttributeObject(elementDef, token));
            }
        }
        reader.close();
    }

    private String createContent(String dtd) throws FileNotFoundException, IOException {
        int data;
        File f = new File(dtd);
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        while ((data = reader.read()) != -1) {
            writer.write(data);
        }
        writer.close();
        reader.close();
        String s = sw.toString();
        s = s.replaceAll("\\s+", " ");
        s = s.replaceAll("<!--.*?-->", "");
        s = s.replaceAll("\\s+", " ");
        s = s.replaceAll(">\\s+<", "><");
        s = s.trim();
        s = s.replaceAll(">", ">\n");
        return s;
    }

    private void generateBeans(ContextObject context, VelocityEngine engine, VelocityContext vc, Dtd2JavaUtil util) throws IOException, Exception {
        String newdir = String.valueOf(this.getRecipe().getOutputDir()) + "/" + this.getRecipe().getPackageName();
        newdir = newdir.replaceAll("\\.", "/");
        newdir = newdir.replaceAll("\\\\", "/");
        ElementObject[] elems = context.getElements();
        int i = 0;
        while (i < elems.length) {
            ElementObject elem = elems[i];
            String classname = util.getClassName(elem.getName());
            File newfile = new File(String.valueOf(newdir) + "/" + classname + ".java");
            if (!newfile.getParentFile().mkdirs() && !newfile.getParentFile().exists()) {
                throw new RuntimeException("\u30d1\u30b9\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + newfile.getParent() + "]");
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(newfile));
            vc.put("element", (Object)elem);
            engine.mergeTemplate(this.getRecipe().getBeansVmName(), (Context)vc, (Writer)writer);
            writer.close();
            ++i;
        }
    }

    private void generateFactory(ContextObject context, VelocityEngine engine, VelocityContext vc, Dtd2JavaUtil util) throws IOException, Exception {
        String newdir = String.valueOf(this.getRecipe().getOutputDir()) + "/" + this.getRecipe().getPackageName();
        newdir = newdir.replaceAll("\\.", "/");
        File newfile = new File(String.valueOf(newdir = newdir.replaceAll("\\\\", "/")) + "/" + context.getFactoryName() + ".java");
        if (!newfile.getParentFile().mkdirs() && !newfile.getParentFile().exists()) {
            throw new RuntimeException("\u30d1\u30b9\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + newfile.getParent() + "]");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(newfile));
        engine.mergeTemplate(this.getRecipe().getFactoryVmName(), (Context)vc, (Writer)writer);
        writer.close();
    }

    public ContextObject getContext() {
        return this.m_context;
    }

    public Recipe getRecipe() {
        return this.m_recipe;
    }

    @Override
    public void run() {
        try {
            Properties veloprop = new Properties();
            veloprop.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogChute");
            veloprop.setProperty("input.encoding", "Windows-31J");
            veloprop.setProperty("output.encoding", "Windows-31J");
            veloprop.setProperty("resource.loader", "FILE");
            veloprop.setProperty("FILE.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
            veloprop.setProperty("FILE.resource.loader.cache", "false");
            veloprop.setProperty("FILE.resource.loader.path", this.getRecipe().getTemplateDir());
            this.m_context = new ContextObject();
            this.m_context.setPackageName(this.getRecipe().getPackageName());
            if (this.getRecipe().getFactoryName() == null || this.getRecipe().getFactoryName().length() == 0) {
                this.getRecipe().setFactoryName("XmlObjectFactory");
            }
            this.m_context.setFactoryName(this.getRecipe().getFactoryName());
            for (String key : this.getRecipe().getKeyMap().keySet()) {
                String value = this.getRecipe().getKeyMap().get(key);
                this.m_context.addKey(key, value);
            }
            this.analyzeDtd(this.m_context, this.getRecipe().getDtdPath());
            VelocityEngine engine = new VelocityEngine();
            engine.init(veloprop);
            VelocityContext vc = new VelocityContext();
            Dtd2JavaUtil util = new Dtd2JavaUtil(this.getRecipe());
            vc.put("context", (Object)this.m_context);
            vc.put("recipe", (Object)this.getRecipe());
            vc.put("util", (Object)util);
            this.generateBeans(this.m_context, engine, vc, util);
            this.generateFactory(this.m_context, engine, vc, util);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setRecipe(Recipe recipe) {
        this.m_recipe = recipe;
    }

    public boolean validateParameter() {
        boolean b = true;
        b &= this.getRecipe().getBeansVmName() != null;
        b &= this.getRecipe().getDtdPath() != null;
        b &= this.getRecipe().getFactoryVmName() != null;
        b &= this.getRecipe().getOutputDir() != null;
        b &= this.getRecipe().getPackageName() != null;
        return b &= this.getRecipe().getTemplateDir() != null;
    }
}

