<?php
$mydirname = basename(dirname(__FILE__));
$modversion['name'] = _MI_SB_MODULE_NAME;
$modversion['dirname'] = $mydirname;
$modversion['hasMain'] = 1;
$modversion['version'] = 1.03;
$modversion['description'] = _MI_SB_MODULE_DESCRIPTION;
$modversion['author'] = 'saitoh-y';
$modversion['credits'] = 'saitoh-y 2008 - 2009';
$modversion['help'] = 'help.html';
$modversion['license'] = 'GPL see LICENSE';
$modversion['official'] = 0;
$modversion['image'] = 'images/logo.png';
$modversion['cube_style'] = true;
$modversion['read_any'] = false;

/* UPDATE */
$modversion['onUpdate'] = "inc/onupdate/onupdate.php";

/* ADMIN */
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = 'admin/index.php';
$modversion['adminmenu'] = 'admin/menu.php';

/* DATABASE */
$modversion['sqlfile']['mysql'] = 'sql/mysql.sql';
$modversion['tables'][] = '{prefix}_{dirname}_sb_game';
$modversion['tables'][] = '{prefix}_{dirname}_sb_player';
$modversion['tables'][] = '{prefix}_{dirname}_sb_player_result_hitter';
$modversion['tables'][] = '{prefix}_{dirname}_sb_player_result_pitcher';
$modversion['tables'][] = '{prefix}_{dirname}_sb_team';
$modversion['tables'][] = '{prefix}_{dirname}_sb_team_result_map';
$modversion['tables'][] = '{prefix}_{dirname}_sb_category';

/* SUBMENU */
$root =& XCube_Root::getSingleton();
$modversion['sub'][] = array(
    'name' => _MI_SB_SUB_VIEW_GAME,
    'url'  => 'index.php?action=viewGame');
$modversion['sub'][] = array(
    'name' => _MI_SB_SUB_VIEW_YEAR,
    'url'  => 'index.php?action=viewYear');
$modversion['sub'][] = array(
    'name' => _MI_SB_SUB_VIEW_TEAM,
    'url'  => 'index.php?action=viewTeam');
$modversion['sub'][] = array(
    'name' => _MI_SB_SUB_RANK_HITTER,
    'url'  => 'index.php?action=viewPlayerResultHitterRank');
$modversion['sub'][] = array(
    'name' => _MI_SB_SUB_RANK_PITCHER,
    'url'  => 'index.php?action=viewPlayerResultPitcherRank');
if (!defined('_SB_DIRNAME')) {
    define('_SB_DIRNAME', basename(dirname(__FILE__)));
}
require_once XOOPS_MODULE_PATH . "/" . _SB_DIRNAME . '/inc/inc.php';
require_once _SB_MODULE_PATH . "class/access/AclClass.php";
$acl =& new Acl();
if ($acl->isAddTeam()) {
    $modversion['sub'][] = array(
        'name' => _MI_SB_SUB_ADD_TEAM,
        'url'  => 'index.php?action=makeTeam');
}
if ($acl->isAddGame()) {
    $modversion['sub'][] = array(
        'name' => _MI_SB_SUB_ADD_GAME,
        'url'  => 'index.php?action=makeGame');
}

/* Templates */
$modversion['templates'][]['file'] = 'sb_view_result_year.html';
$modversion['templates'][]['file'] = 'sb_detail_team.html';
$modversion['templates'][]['file'] = 'sb_edit_team.html';
$modversion['templates'][]['file'] = 'sb_edit_game.html';
$modversion['templates'][]['file'] = 'sb_edit_player.html';
$modversion['templates'][]['file'] = 'sb_detail_game.html';
$modversion['templates'][]['file'] = 'sb_edit_player_result_hitter.html';
$modversion['templates'][]['file'] = 'sb_edit_player_result_pitcher.html';
$modversion['templates'][]['file'] = 'sb_detail_player.html';
$modversion['templates'][]['file'] = 'sb_view_player_result_hitter.html';
$modversion['templates'][]['file'] = 'sb_view_player_result_pitcher.html';
$modversion['templates'][]['file'] = 'sb_view_result_game.html';
$modversion['templates'][]['file'] = 'sb_view_team.html';
$modversion['templates'][]['file'] = 'tp_game_score.html';
$modversion['templates'][]['file'] = 'tp_edit_player_result_hitter.html';
$modversion['templates'][]['file'] = 'tp_edit_player_result_pitcher.html';
$modversion['templates'][]['file'] = 'tp_detail_player_result.html';
$modversion['templates'][]['file'] = 'tp_view_result_year.html';
$modversion['templates'][]['file'] = 'tp_view_player.html';
$modversion['templates'][]['file'] = 'admin_menu.html';
$modversion['templates'][]['file'] = 'admin_viewTeam.html';
$modversion['templates'][]['file'] = 'admin_AclTeam.html';
$modversion['templates'][]['file'] = 'admin_viewCategory.html';
$modversion['templates'][]['file'] = 'admin_editCategory.html';
/* BLOCK */
$modversion['blocks'][0]['name'] = _MI_SB_VIEW_LAST_GAME;
$modversion['blocks'][0]['description'] = '';
$modversion['blocks'][0]['show_func'] = '';
$modversion['blocks'][0]['file'] = 'viewLastGameBlock.php';
$modversion['blocks'][0]['class'] = 'ViewLastGameBlock';
$modversion['blocks'][0]['options'] = '5';
$modversion['blocks'][0]['edit_func'] = '';
$modversion['blocks'][0]['template'] = 'view_last_game.html';
$modversion['blocks'][0]['func_num'] = 1;
$modversion['blocks'][0]['can_clone'] = 0;

$modversion['blocks'][1]['name'] = _MI_SB_VIEW_LAST_RANK_HITTER;
$modversion['blocks'][1]['description'] = '';
$modversion['blocks'][1]['show_func'] = '';
$modversion['blocks'][1]['file'] = 'viewLastRankHitterBlock.php';
$modversion['blocks'][1]['class'] = 'ViewLastRankHitterBlock';
$modversion['blocks'][1]['options'] = 'AVG|3';
$modversion['blocks'][1]['edit_func'] = '';
$modversion['blocks'][1]['template'] = 'view_last_rank_hitter.html';
$modversion['blocks'][1]['func_num'] = 2;
$modversion['blocks'][1]['can_clone'] = 1;

$modversion['blocks'][2]['name'] = _MI_SB_VIEW_LAST_RANK_PITCHER;
$modversion['blocks'][2]['description'] = '';
$modversion['blocks'][2]['show_func'] = '';
$modversion['blocks'][2]['file'] = 'viewLastRankPitcherBlock.php';
$modversion['blocks'][2]['class'] = 'ViewLastRankPitcherBlock';
$modversion['blocks'][2]['options'] = 'ERA|ASC|3';
$modversion['blocks'][2]['edit_func'] = '';
$modversion['blocks'][2]['template'] = 'view_last_rank_pitcher.html';
$modversion['blocks'][2]['func_num'] = 3;
$modversion['blocks'][2]['can_clone'] = 1;

/* MODULE SETTING */
$modversion['config'][0]['name'] = "rank_hitter";
$modversion['config'][0]['title'] = '_MI_SB_CONFIG_HITTER';
$modversion['config'][0]['description'] = '';
$modversion['config'][0]['formtype'] = 'select';
$modversion['config'][0]['valuetype'] = 'string';
$modversion['config'][0]['default'] = _MI_SB_CONFIG_HITTER_VALUE_AVG;
$modversion['config'][0]['options'] = array(
    _MI_SB_CONFIG_HITTER_NAME_AVG => _MI_SB_CONFIG_HITTER_VALUE_AVG,
    _MI_SB_CONFIG_HITTER_NAME_ATBAT => _MI_SB_CONFIG_HITTER_VALUE_ATBAT,
    _MI_SB_CONFIG_HITTER_NAME_ATBATS => _MI_SB_CONFIG_HITTER_VALUE_ATBATS,
    _MI_SB_CONFIG_HITTER_NAME_HITS => _MI_SB_CONFIG_HITTER_VALUE_HITS,
    _MI_SB_CONFIG_HITTER_NAME_TWO_BASE => _MI_SB_CONFIG_HITTER_VALUE_TWO_BASE,
    _MI_SB_CONFIG_HITTER_NAME_THREE_BASE => _MI_SB_CONFIG_HITTER_VALUE_THREE_BASE,
    _MI_SB_CONFIG_HITTER_NAME_HR => _MI_SB_CONFIG_HITTER_VALUE_HR,
    _MI_SB_CONFIG_HITTER_NAME_BB => _MI_SB_CONFIG_HITTER_VALUE_BB,
    _MI_SB_CONFIG_HITTER_NAME_HBP => _MI_SB_CONFIG_HITTER_VALUE_HBP,
    _MI_SB_CONFIG_HITTER_NAME_SACRIFICE => _MI_SB_CONFIG_HITTER_VALUE_SACRIFICE,
    _MI_SB_CONFIG_HITTER_NAME_RBI => _MI_SB_CONFIG_HITTER_VALUE_RBI,
    _MI_SB_CONFIG_HITTER_NAME_R => _MI_SB_CONFIG_HITTER_VALUE_R,
    _MI_SB_CONFIG_HITTER_NAME_SB => _MI_SB_CONFIG_HITTER_VALUE_SB,
    _MI_SB_CONFIG_HITTER_NAME_K => _MI_SB_CONFIG_HITTER_VALUE_K,
    _MI_SB_CONFIG_HITTER_NAME_SELF_E => _MI_SB_CONFIG_HITTER_VALUE_SELF_E,
    _MI_SB_CONFIG_HITTER_NAME_OBP => _MI_SB_CONFIG_HITTER_VALUE_OBP,
    _MI_SB_CONFIG_HITTER_NAME_SP => _MI_SB_CONFIG_HITTER_VALUE_SP,
    _MI_SB_CONFIG_HITTER_NAME_OPS => _MI_SB_CONFIG_HITTER_VALUE_OPS);

$modversion['config'][1]['name'] = "rank_hitter_sort";
$modversion['config'][1]['title'] = '_MI_SB_CONFIG_HITTER_SORT';
$modversion['config'][1]['description'] = '';
$modversion['config'][1]['formtype'] = 'select';
$modversion['config'][1]['valuetype'] = 'string';
$modversion['config'][1]['default'] = _MI_SB_CONFIG_VALUE_DESC;
$modversion['config'][1]['options'] = array(
    _MI_SB_CONFIG_NAME_DESC => _MI_SB_CONFIG_VALUE_DESC,
    _MI_SB_CONFIG_NAME_ASC => _MI_SB_CONFIG_VALUE_ASC);

$modversion['config'][2]['name'] = "rank_pitcher";
$modversion['config'][2]['title'] = '_MI_SB_CONFIG_PITCHER';
$modversion['config'][2]['description'] = '';
$modversion['config'][2]['formtype'] = 'select';
$modversion['config'][2]['valuetype'] = 'string';
$modversion['config'][2]['default'] = _MI_SB_CONFIG_PITCHER_VALUE_WIN;
$modversion['config'][2]['options'] = array(
    _MI_SB_CONFIG_PITCHER_NAME_WIN => _MI_SB_CONFIG_PITCHER_VALUE_WIN,
    _MI_SB_CONFIG_PITCHER_NAME_LOSE => _MI_SB_CONFIG_PITCHER_VALUE_LOSE,
    _MI_SB_CONFIG_PITCHER_NAME_SV => _MI_SB_CONFIG_PITCHER_VALUE_SV,
    _MI_SB_CONFIG_PITCHER_NAME_HLD => _MI_SB_CONFIG_PITCHER_VALUE_HLD,
    _MI_SB_CONFIG_PITCHER_NAME_IP => _MI_SB_CONFIG_PITCHER_VALUE_IP,
    _MI_SB_CONFIG_PITCHER_NAME_NP => _MI_SB_CONFIG_PITCHER_VALUE_NP,
    _MI_SB_CONFIG_PITCHER_NAME_AVG => _MI_SB_CONFIG_PITCHER_VALUE_AVG,
    _MI_SB_CONFIG_PITCHER_NAME_HR => _MI_SB_CONFIG_PITCHER_VALUE_HR,
    _MI_SB_CONFIG_PITCHER_NAME_K => _MI_SB_CONFIG_PITCHER_VALUE_K,
    _MI_SB_CONFIG_PITCHER_NAME_BB => _MI_SB_CONFIG_PITCHER_VALUE_BB,
    _MI_SB_CONFIG_PITCHER_NAME_HBP => _MI_SB_CONFIG_PITCHER_VALUE_HBP,
    _MI_SB_CONFIG_PITCHER_NAME_WP => _MI_SB_CONFIG_PITCHER_VALUE_WP,
    _MI_SB_CONFIG_PITCHER_NAME_R => _MI_SB_CONFIG_PITCHER_VALUE_R,
    _MI_SB_CONFIG_PITCHER_NAME_ER => _MI_SB_CONFIG_PITCHER_VALUE_ER,
    _MI_SB_CONFIG_PITCHER_NAME_ERA => _MI_SB_CONFIG_PITCHER_VALUE_ERA);

$modversion['config'][3]['name'] = "rank_pitcher_sort";
$modversion['config'][3]['title'] = '_MI_SB_CONFIG_PITCHER_SORT';
$modversion['config'][3]['description'] = '';
$modversion['config'][3]['formtype'] = 'select';
$modversion['config'][3]['valuetype'] = 'string';
$modversion['config'][3]['default'] = _MI_SB_CONFIG_VALUE_DESC;
$modversion['config'][3]['options'] = array(
    _MI_SB_CONFIG_NAME_DESC => _MI_SB_CONFIG_VALUE_DESC,
    _MI_SB_CONFIG_NAME_ASC => _MI_SB_CONFIG_VALUE_ASC);

//$modversion['config'][4]['name'] = "max_ining";
//$modversion['config'][4]['title'] = '_MI_SB_CONFIG_MAX_INING';
//$modversion['config'][4]['description'] = '';
//$modversion['config'][4]['formtype'] = 'select';
//$modversion['config'][4]['valuetype'] = 'int';
//$modversion['config'][4]['default'] = _MI_SB_CONFIG_MAX_INING_VALUE;
//$modversion['config'][4]['options'] = array(1 => 1, 2 => 2, 3 => 3, 4 => 4, 5 => 5, 6 => 6, 7 => 7,
//    8 => 8, 9 => 9, 10 => 10, 11 => 11, 12 => 12);
    
//$modversion['config'][5]['name'] = "base_atbat_num";
//$modversion['config'][5]['title'] = '_MI_SB_CONFIG_BASE_ATBUT_NUM';
//$modversion['config'][5]['description'] = '';
//$modversion['config'][5]['formtype'] = 'textbox';
//$modversion['config'][5]['valuetype'] = 'float';
//$modversion['config'][5]['default'] = _MI_SB_CONFIG_BASE_ATBUT_NUM_VALUE;
//$modversion['config'][5]['options'] = array();
//
//$modversion['config'][6]['name'] = "base_ip_num";
//$modversion['config'][6]['title'] = '_MI_SB_CONFIG_BASE_IP_NUM';
//$modversion['config'][6]['description'] = '';
//$modversion['config'][6]['formtype'] = 'textbox';
//$modversion['config'][6]['valuetype'] = 'int';
//$modversion['config'][6]['default'] = _MI_SB_CONFIG_BASE_IP_NUM_VALUE;
//$modversion['config'][6]['options'] = array();
?>