<?php
/**
 * ׻åȤ
 *
 * @param Array $gameResult
 */
function setGameScore(&$gameResult) {
    $topScore = 0;
    $bottomScore = 0;
    for ($i = 1; $i <= _SB_MODULE_MAXINING; $i++) {
        $topScore = $topScore + intval($gameResult['top_' . $i]);
        $bottomScore = $bottomScore + intval($gameResult['bottom_' . $i]);

        /* xװդ˥󥰤 */
        if (strstr($gameResult['bottom_' . $i], _SB_MODULE_ENDMARK) !== false) {
            $endIning = 'bottom_' . $i;
        }
    }

    /* ʥξxװĤ */
    if ($topScore < $bottomScore && @intval($gameResult[$endIning]) != 0) {
        $bottomScore = $bottomScore . _SB_MODULE_ENDMARK;
    }

    $gameResult['top_score'] = $topScore;
    $gameResult['bottom_score'] = $bottomScore;
}

/**
 * (Ǽ)Խˤơ9ͤʤʬ
 *
 * @param Array $playerResultHitterList (Ǽ)ꥹ
 */
function setPlayerResultHitterList(&$playerResultHitterList) {
    $remains = 9 - count($playerResultHitterList);
    for ($i = 0; $i < $remains; $i++) {
        $playerResultHitterList[] = array();
    }
}

/**
 * ե饰򥻥åȤ
 *
 * @param Array $$playerResultHitterList (Ǽ)ꥹ
 */
function setStartFg(&$playerResultHitterList) {
    foreach ($playerResultHitterList as $key => $hitter) {
        if (substr($hitter['batting_order'], 1) == '00') {
            @$playerResultHitterList[$key]['startFg'] = true;
        }
    }
}

/**
 * ȥȤ饤˥󥰿ꤹ
 *
 * @param Array $playerResultPitcherList ()ꥹ
 */
function setOut2Ining4List(&$playerResultPitcherList) {
    foreach ($playerResultPitcherList as $key => $result) {
        $ining = $result['IP'] / 3;
        $out = $result['IP'] % 3;
        @$playerResultPitcherList[$key]['IP'] = intval($ining);
        @$playerResultPitcherList[$key]['IP_out'] = $out;
    }
}

/**
 * ȥȤ饤˥󥰿ꤹ
 *
 * @param Array $result ()
 * @return Array
 */
function setOut2Ining(&$result) {
    $ining = $result['IP'] / 3;
    $out = $result['IP'] % 3;
    return array('IP' => intval($ining), 'IP_out' => $out);
}
/**
 * Ψ׻
 *
 * @param Array $result ӥꥹ
 * @return String
 */
function calcAVG($result) {
    if (!empty($result['atbats'])) {
        $AVG = @$result['hits'] / @$result['atbats'];
        return sprintf('%.' . _SB_MODULE_SHOW_FLOAT_LENGTH . 'f', $AVG);
    }
    else {
        return sprintf('%.' . _SB_MODULE_SHOW_FLOAT_LENGTH . 'f', 0);
    }
}

/**
 * Ψ׻
 *
 * @param Array $result ӥꥹ
 * @return String
 */
function calcOBP($result) {
    $denominator = @$result['atbats'] + @$result['BB'] + @$result['HBP'] + @$result['sacrifice'];

    if (!empty($denominator)) {
        $OBP = (@$result['hits'] + @$result['BB'] + @$result['HBP']) / $denominator;
        return sprintf('%.' . _SB_MODULE_SHOW_FLOAT_LENGTH . 'f', $OBP);
    }
    else {
        return sprintf('%.' . _SB_MODULE_SHOW_FLOAT_LENGTH . 'f', 0);
    }
}

/**
 * ĹΨ׻
 *
 * @param Array $result ӥꥹ
 * @return String
 */
function calcSP($result) {
    if (!empty($result['atbats'])) {
        $one = @$result['hits'] - @$result['two_base'] - @$result['three_base'] - @$result['HR'];
        $two = @$result['two_base'] * 2;
        $three = @$result['three_base'] * 3;
        $four = @$result['HR'] * 4;
        $SP = ($one + $two + $three + $four) / @$result['atbats'];

        return sprintf('%.' . _SB_MODULE_SHOW_FLOAT_LENGTH . 'f', $SP);
    }
    else {
        return sprintf('%.' . _SB_MODULE_SHOW_FLOAT_LENGTH . 'f', 0);
    }
}

/**
 * OPS׻
 *
 * @param Array $result ӥꥹ
 * @return String
 */
function calcOPS($result) {
    return sprintf('%.' . _SB_MODULE_SHOW_FLOAT_LENGTH . 'f', calcSP($result) + calcOBP($result));
}

/**
 * Ψ׻
 *
 * @param Array $result ӥꥹ
 * @return String
 */
function calcWAVG($result) {
    $denominator = @$result['win'] + @$result['lose'];
    if (!empty($denominator)) {
        $WAVG = @$result['win'] / $denominator;
        return sprintf('%.' . _SB_MODULE_SHOW_FLOAT_LENGTH . 'f', $WAVG);
    }
    else {
        return sprintf('%.' . _SB_MODULE_SHOW_FLOAT_LENGTH . 'f', 0);
    }
}

/**
 * ɸΨ׻
 *
 * @param Array $result ӥꥹ
 * @return String
 */
function calcERA($result) {
    $denominator = @$result['IP'] + (@$result['IP_out'] / 3);
    if (!empty($denominator)) {
        $WAVG = @$result['ER'] / $denominator * 9;
        return sprintf('%.' . _SB_MODULE_SHOW_FLOAT_LENGTH . 'f', $WAVG);
    }
    else {
        return sprintf('%.' . _SB_MODULE_SHOW_FLOAT_LENGTH . 'f', 0);
    }
}

/**
 * ̰ˤƾԤˤCSS򥻥åȤ
 *
 * @param Array $gameResult
 */
function setDesign(&$gameResult) {
    /* Ʊξ */
    if ($gameResult['top_team_cd'] == $gameResult['bottom_team_cd']) {
        $gameResult['result_style'] = _SB_MODULE_TEMPLATES_CSS_DRAW;
    }
    /* 蹶Ǿξ */
    elseif ($gameResult['team_cd'] == $gameResult['top_team_cd'] && $gameResult['top_score'] >
        $gameResult['bottom_score']) {
        $gameResult['result_style'] = _SB_MODULE_TEMPLATES_CSS_WIN;
    }
    /* 并Ǿξ */
    elseif ($gameResult['team_cd'] == $gameResult['bottom_team_cd'] && $gameResult['top_score'] <
        $gameResult['bottom_score']) {
        $gameResult['result_style'] = _SB_MODULE_TEMPLATES_CSS_WIN;
    }
    /* 蹶餱ξ */
    elseif ($gameResult['team_cd'] == $gameResult['top_team_cd'] && $gameResult['top_score'] <
        $gameResult['bottom_score']) {
        $gameResult['result_style'] = _SB_MODULE_TEMPLATES_CSS_LOSE;
    }
    /* 并餱ξ */
    elseif ($gameResult['team_cd'] == $gameResult['bottom_team_cd'] && $gameResult['top_score'] >
        $gameResult['bottom_score']) {
        $gameResult['result_style'] = _SB_MODULE_TEMPLATES_CSS_LOSE;
    }
    /* ʬξ */
    else {
        $gameResult['result_style'] = _SB_MODULE_TEMPLATES_CSS_DRAW;
    }
}

/**
 * ³$columnǻꤵ줿ͤʬ䤷
 * ͤ򥭡ȤϢˤ֤
 * ΤȤϤ$columnǻꤵ줿ˤäƥȤƤ뤳Ȥ
 *
 * @param String $column ɤΥʬ䤹뤫ꤹ륭̾
 * @param Array  $array  ʬ䤹뤫
 * @return Array $columnͤ򥭡ȤϢ
 */
function array_set($array, $column) {
    $pupArr = "";
    $returnArr = "";
    $staykey = $array[0][$column];
    foreach ($array as $value) {
        if (IsSet($value[$column])) {
            $val = $value[$column];
        }
        else {
            $val = "";
        }

        if ($staykey != $val) {
            //returnͤ
            $returnArr[$staykey] = $pupArr;

            //$pupArr$staykeyν
            $pupArr = "";
            $staykey = $val;
        }
        $pupArr[] = $value;

    }
    //롼פȴǸˤ⤦returnArrͤɲ
    $returnArr[$staykey] = $pupArr;
    return ($returnArr);
}

/**
 * Υꤵ줿ͤˤ
 *
 * @param Array $list 
 * @param String $key ̾
 * @return Array ͤꤵ줿
 */
function array_set_key($list, $key) {
    $setList = array();
    foreach ($list as $value) {
        $setList[$value[$key]] = $value;
    }
    return $setList;
}

/**
 * ʿ֤
 *
 * @return Integer
 */
function getRandamInteger() {
    list($usec, $sec) = explode(' ', microtime());
    $seed = (float) $sec + ((float) $usec * 100000);
    srand($seed);
    return date("YmdHis") . rand(0, 99);
}

/**
 * ¥ꥹȤ
 *
 * @return Array
 */
function getAuthList() {
    $authList[] = array(
        'name'            => _AD_SB_TEXT_ACL_CD_ADD_TEAM,
        'action_cd'       => _SB_MODULE_DB_ACL_CD_ADD_TEAM,
        'team_setting_fg' => false);
    $authList[] = array(
        'name'            => _AD_SB_TEXT_ACL_CD_EDIT_TEAM,
        'action_cd'       => _SB_MODULE_DB_ACL_CD_EDIT_TEAM,
        'team_setting_fg' => true);
    $authList[] = array(
        'name'            => _AD_SB_TEXT_ACL_CD_ADD_GAME,
        'action_cd'       => _SB_MODULE_DB_ACL_CD_ADD_GAME,
        'team_setting_fg' => false);
    $authList[] = array(
        'name'            => _AD_SB_TEXT_ACL_CD_EDIT_GAME,
        'action_cd'       => _SB_MODULE_DB_ACL_CD_EDIT_GAME,
        'team_setting_fg' => true);
    $authList[] = array(
        'name'            => _AD_SB_TEXT_ACL_CD_EDIT_PLAYER,
        'action_cd'       => _SB_MODULE_DB_ACL_CD_EDIT_PLAYER,
        'team_setting_fg' => true);
    return $authList;
}

/**
 * ȴԡϿ桼ȰʳΥ롼IDꥹȤ
 *
 * @return Array
 */
function getGroupidList() {
    $root =& XCube_Root::getSingleton();
    $groupList = $root->mContext->mXoopsUser->getGroups();
    $list = array();
    foreach ($groupList as $group) {
        if (!in_array($group, array(1, 2, 3))) {
            $list[] = $group;
        }
    }
    return $list;
}

/**
 * ॳɤɬפȤ륢󥳡ɥꥹȤ
 *
 * @return Array
 */
function getActionCdList4Team() {
    return array(_SB_MODULE_DB_ACL_CD_EDIT_TEAM, _SB_MODULE_DB_ACL_CD_EDIT_GAME,
        _SB_MODULE_DB_ACL_CD_EDIT_PLAYER);
}

/**
 * assgin
 *
 */
function assginCommon() {
	$root =& XCube_Root::getSingleton();
    $render =& $root->mContext->mModule->getRenderTarget();

    if (!empty($render)) {
        /* HEADER ASSIGN */
        $render->setAttribute('sb_url', _SB_MODULE_URL); // ⥸塼URL
        $render->setAttribute('max_ining', _SB_MODULE_MAXINING); // 祤˥
        $render->setAttribute('icon', "&nbsp;<IMG SRC='" . _SB_MODULE_URL .
            "images/arrow.png'>&nbsp;"); // 

        /* language ASSIGN*/
        $definedList = get_defined_constants(true);
        foreach ($definedList['user'] as $key => $value) {
            if (in_array(substr($key, 0, 6), array('_MD_SB', '_AD_SB'))) {

                $render->setAttribute(substr($key, 6), $value);
            }
        }

        /* ʲ⥸塼إå */
        $header = "";
        $jsNameList[] = XOOPS_URL . '/common/jscalendar/calendar.js';
        $jsNameList[] = XOOPS_URL . '/common/jscalendar/lang/' . $root->mContext->mXoopsConfig[
            'language'] . '.js';
        $jsNameList[] = XOOPS_URL . '/common/jscalendar/calendar-setup.js';
        $jsNameList[] = XOOPS_URL . '/modules/' . _SB_DIRNAME . '/inc/sb_game.js';
        $jsNameList[] = XOOPS_URL . '/modules/' . _SB_DIRNAME . '/inc/sb_playerResult.js';
        $jsNameList[] = XOOPS_URL . '/modules/' . _SB_DIRNAME . '/inc/sb_common.js';
        $jsNameList[] = XOOPS_URL . '/modules/' . _SB_DIRNAME . '/inc/sb_rank.js';

        $cssNameList[] = XOOPS_URL . '/modules/' . _SB_DIRNAME . '/templates/sb_style.css';
        $cssNameList[] = XOOPS_URL . '/common/jscalendar/calendar-system.css';
        foreach ($cssNameList as $cssName) {
            $header .= '<link rel="stylesheet" type="text/css" media="all" href="' . $cssName .
                '" />';
        }
        foreach ($jsNameList as $jsName) {
            $header .= '<script type="text/javascript" src="' . $jsName . '"></script>';
        }
        $render->setAttribute('xoops_module_header', $header);
    }
}
?>