<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/database/DatabaseScoreBookClass.php";

/**
 * sb_player_result_pitcherơ֥륯饹
 *
 * @since 0.0.8
 * @author saitoh-y
 */
class PlayerResultPitcher extends DatabaseScoreBook {

    /**
     * ӥ
     *
     * @access private
     * @var Integer
     */
    private $playerResultCd = 0;

    /**
     * 祳
     *
     * @access private
     * @var Integer
     */
    private $gameCd = 0;
    /**
     * 蹶ե饰
     *
     * @access private
     * @var boolean
     */
    private $topFg = false;

    /**
     * ꥳ
     *
     * @access private
     * @var Integer
     */
    private $playerCd = 0;

    /**
     * ॳ
     *
     * @access private
     * @var Integer
     */
    private $teamCd = 0;

    /**
     * SELECT
     *
     * @access private
     * @var String
     */
    private $select = "";
    /**
     * Ⱦꥹ
     *
     * @access private
     * @var Array
     */
    private $rankSortCond = array();

    /**
     * ǯ
     *
     * @access private
     * @var Integer
     */
    private $year = 0;

    /**
     * ƥꥳ
     *
     * @access private
     * @var Integer
     */
    private $categoryCd = 0;

    /**
     * 
     *
     * @access private
     * @var Integer
     */
    private $baseIP = 0;

    /**
     * ̥
     *
     * @access private
     * @var Integer
     */
    private $resultCd = 0;

    function PlayerResultPitcher() {
        parent::DatabaseScoreBook();
        $this->select = " result.player_cd,";
        $this->select .= " result.game_cd,";
        $this->select .= " result.result_cd,";
        $this->select .= " result.IP,";
        $this->select .= " result.NP,";
        $this->select .= " result.BF,";
        $this->select .= " result.OBA,";
        $this->select .= " result.HR,";
        $this->select .= " result.K,";
        $this->select .= " result.BB,";
        $this->select .= " result.HBP,";
        $this->select .= " result.WP,";
        $this->select .= " result.WP,";
        $this->select .= " result.R,";
        $this->select .= " result.ER";
    }

    /**
     * sb_player_result_pitcherơ֥ƤΥ쥳ɤ
     *
     * @return Array
     */
    function getAllList() {
        $sql = "SELECT * FROM " . $this->tableNamePlayerResultPitcher . " ORDER BY player_cd ASC";
        return $this->getList($sql);
    }

    /**
     * sb_player_result_pitcherơ֥1ʬΥ쥳ɤ
     *
     * @return Array
     */
    function getPlayerResultPitcher() {
        $sql = "SELECT " . $this->select . ", LEFT(game.game_date, 4) as year FROM " . $this->
            tableNamePlayerResultPitcher . " as result, " . $this->tableNameGame . " as game";
        $sql .= " WHERE result.player_cd = " . $this->playerCd;
        $sql .= " AND result.game_cd = game.game_cd";
        $sql .= " ORDER BY year ASC";
        return $this->getList($sql);
    }

    /**
     * sb_player_result_pitcherơ֥11ʬΥ쥳ɤ
     *
     * @return Array
     */
    function getPlayerResultPitcherList() {
        $sql = "SELECT * FROM " . $this->tableNamePlayerResultPitcher . " as result,";
        $sql .= $this->tableNamePlayer . " as player";
        $sql .= " WHERE result.player_cd = player.player_cd";
        $sql .= " AND result.game_cd = " . $this->gameCd;
        $sql .= " AND result.top_fg = " . $this->topFg;
        $sql .= " ORDER BY result.pitcher_order ASC";
        return $this->getList($sql);
    }

    /**
     * sb_player_result_pitcherơ֥1ʬΥ쥳ɤ
     *
     * @return Array
     */
    function getPlayerResultPitcherTeamList() {
        $sql = "SELECT " . $this->select . ", LEFT(game.game_date, 4) as year FROM " . $this->
            tableNamePlayerResultPitcher . " as result, " . $this->tableNameGame . " as game, " .
            $this->tableNamePlayer . " as player";
        $sql .= " WHERE result.player_cd = player.player_cd";
        $sql .= " AND result.game_cd = game.game_cd";
        $sql .= " AND player.team_cd = " . $this->teamCd;
        $sql .= " ORDER BY year ASC";
        return $this->getList($sql);
    }

    function getRankList() {
        /* ɬפʹܤ */
        $selectList[] = ', TRUNCATE((sum(pitcher.IP) / 3),0) as IP';
        $selectList[] = ', sum(pitcher.IP) % 3 as IP_out';
        $selectList[] = ', sum(pitcher.NP) as NP';
        $selectList[] = ', sum(pitcher.BF) as BF';
        $selectList[] = ', sum(pitcher.OBA) as OBA';
        $selectList[] = ', sum(pitcher.OBA) / (sum(pitcher.BF) - (sum(pitcher.BB) + sum(pitcher.HBP))) as AVG';
        $selectList[] = ', sum(pitcher.HR) as HR';
        $selectList[] = ', sum(pitcher.K) as K';
        $selectList[] = ', sum(pitcher.BB) as BB';
        $selectList[] = ', sum(pitcher.HBP) as HBP';
        $selectList[] = ', sum(pitcher.WP) as WP';
        $selectList[] = ', sum(pitcher.R) as R';
        $selectList[] = ', sum(pitcher.ER) as ER';
        $selectList[] = ', (sum(pitcher.ER) / FORMAT(sum(pitcher.IP) / 3,0))*9 as ERA';
        $selectList[] =
            ', ((sum(pitcher.ER) + sum(pitcher.BB) + sum(pitcher.HBP) ) / FORMAT(sum(pitcher.IP) / 3,0)) as WHIP';

        /*  */
        $sql = "SELECT pitcher.player_cd, player.player_name, team.team_cd, team.team_name, player.help_fg, player.ob_fg";
        $sql .= ", 0 as win, 0 as lose, 0 as SV, 0 as HLD";
        foreach ($selectList as $select) {
            $sql .= $select;
        }
        $sql .= " FROM " . $this->tableNamePlayerResultPitcher . " as pitcher, ";
        $sql .= $this->tableNameTeam . " as team, ";
        $sql .= $this->tableNamePlayer . " as player ";
        if (!empty($this->year) || !empty($this->categoryCd)) {
            $sql .= "," . $this->tableNameGame . " as game";
        }
        $sql .= " WHERE pitcher.player_cd = player.player_cd";
        $sql .= " AND team.team_cd = player.team_cd";
        if (!empty($this->year) || !empty($this->categoryCd)) {
            $sql .= " AND pitcher.game_cd = game.game_cd";
            if (!empty($this->year)) {
                $sql .= " AND game.game_date BETWEEN CAST('" . $this->year . "-01-01' as DATE)";
                $sql .= " AND CAST('" . $this->year . "-12-31' as DATE)";
            }
            if (!empty($this->categoryCd)) {
                $sql .= " AND game.category_cd = " . $this->categoryCd;
            }
        }
        $sql .= " GROUP BY pitcher.player_cd";
        if ($this->rankSortCond['column'] == 'ERA') {
            $sql .= " HAVING sum(pitcher.IP) >=" . $this->baseIP;
        }
        return $this->getList($sql);
    }

    /**
     * sb_player_result_pitcherơ֥뤫ǯӽ˾ԡSAVEHOLDΥ쥳ɤ
     *
     * @return Array
     */
    function getResultCdList() {
        /* 륫̾ */
        if (!empty($this->resultCd) && $this->resultCd == 1) {
            $column = "win";
        }
        elseif (!empty($this->resultCd) && $this->resultCd == 2) {
            $column = "lose";
        }
        elseif (!empty($this->resultCd) && $this->resultCd == 3) {
            $column = "SV";
        }
        elseif (!empty($this->resultCd) && $this->resultCd == 4) {
            $column = "HLD";
        }

        $sql =
            "SELECT player.player_cd, player.player_name, team.team_cd, team.team_name, count(*) as "
            . $column;
        $sql .= " FROM " . $this->tableNamePlayerResultPitcher . " as pitcher, ";
        $sql .= $this->tableNameTeam . " as team, ";
        $sql .= $this->tableNamePlayer . " as player ";
        if (!empty($this->year) || !empty($this->categoryCd)) {
            $sql .= "," . $this->tableNameGame . " as game";
        }
        $sql .= " WHERE pitcher.player_cd = player.player_cd";
        $sql .= " AND team.team_cd = player.team_cd";
        if (!empty($this->year) || !empty($this->categoryCd)) {
            $sql .= " AND pitcher.game_cd = game.game_cd";
            if (!empty($this->year)) {
                $sql .= " AND game.game_date BETWEEN CAST('" . $this->year . "-01-01' as DATE)";
                $sql .= " AND CAST('" . $this->year . "-12-31' as DATE)";
            }
            if (!empty($this->categoryCd)) {
                $sql .= " AND game.category_cd = " . $this->categoryCd;
            }
        }
        $sql .= " AND pitcher.result_cd = " . $this->resultCd;
        $sql .= " GROUP BY pitcher.player_cd";

        return $this->getList($sql);
    }

    /**
     * sb_player_result_pitcherơ֥˥쥳ɤɲä
     *
     * @return boolean
     */
    function insert() {
        return parent::insert($this->tableNamePlayerResultPitcher);
    }

    /**
     * sb_player_result_pitcherơ֥Υ쥳ɤ򹹿
     *
     * @return boolean
     */
    function update() {
        return parent::update($this->tableNamePlayerResultPitcher);
    }

    /**
     * sb_player_result_pitcherơ֥Υ쥳ɤ蹶ե饰򹹿
     *
     * @param Array $playerCdList ꥳɥꥹ
     * @return boolean
     */
    function updateTopFg($playerCdList) {
        $sql = "UPDATE " . $this->tableNamePlayerResultPitcher . " SET top_fg = " . $this->topFg;
        $sql .= " WHERE game_cd = " . $this->gameCd . " AND player_cd in (" . implode(",",
            $playerCdList) . ")";
        return $this->execute($sql);
    }

    /**
     * sb_player_result_pitcherơ֥뤫쥳ɤ
     *
     */
    function delete() {
        return parent::delete($this->tableNamePlayerResultPitcher);
    }

    /**
     * ӥɤΥå
     *
     * @param Integer $playerResultCd
     */
    function setPlayerResultCd($playerResultCd) {
        $this->playerResultCd = addslashes(intval($playerResultCd));
    }

    /**
     * 祳ɤΥå
     *
     * @param Integer $gameCd
     */
    function setGameCd($gameCd) {
        $this->gameCd = addslashes(intval($gameCd));
    }

    /**
     * 蹶ե饰Υå
     *
     * @param Integer $topFg
     */
    function setTopFg($topFg) {
        $this->topFg = addslashes(intval($topFg));
    }

    /**
     * ꥳɤΥå
     *
     * @param Integer $playerCd
     */
    function setPlayerCd($playerCd) {
        $this->playerCd = addslashes(intval($playerCd));
    }

    /**
     * ॳɤΥå
     *
     * @param Integer $teamCd
     */
    function setTeamCd($teamCd) {
        $this->teamCd = addslashes(intval($teamCd));
    }

    /**
     * ǯ٤Υå
     *
     * @param Integer $year
     */
    function setYear($year) {
        $this->year = addslashes(intval($year));
    }

    /**
     * ƥꥳɤΥå
     *
     * @param Integer $categoryCd
     */
    function setCategoryCd($categoryCd) {
        $this->categoryCd = addslashes(intval($categoryCd));
    }

    /**
     * Υå
     *
     * @param Integer $IP
     */
    function setBaseIP($IP) {
        $this->baseIP = addslashes(intval($IP * 3));
    }

    /**
     * ̥ɤΥå
     *
     * @param Integer $resultCd
     */
    function setResultCd($resultCd) {
        $this->resultCd = addslashes(intval($resultCd));
    }

    /**
     * 󥯥ȾΥå
     *
     * @param String $column Ⱦˤ륫̾
     * @param String $sort /߽
     */
    function setRankSortCond($column, $sort) {
        $this->rankSortCond = array('column' => addslashes($column), 'sort' => addslashes($sort));
    }
}
?>