<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * Ŀ(Ǽ)󥭥󥰰饹
 *
 * @version 0.0.2
 * @author saitoh-y
 */
class viewPlayerResultHitterRankAction extends ActionAbstract  {

    /**
     * 󥯥ꥹ
     *
     * @access private
     * @var Array
     */
    private $rankList = array();

    /**
     * ǿ
     *
     * @access private
     * @var Integer
     */
    private $baseAtbats = 1;

    /**
     * ǯ
     *
     * @access private
     * @var Integer
     */
    private $year = 0;
    
    /**
     * ƥꥳ
     *
     * @access private
     * @var Integer
     */
    private $categoryCd = 0;

    /**
     * ǯꥹ
     *
     * @access private
     * @var Array
     */
    private $yearList = array();

    /**
     * ̾
     *
     * @access private
     * @var String
     */
    private $column;

    /**
     * Ⱦ
     *
     * @access private
     * @var String
     */
    private $sort;
    
    /**
     * ƥꥹ
     *
     * @access private
     * @var Array
     */
    private $categoryList = array();

    /**
     * Ŀ(Ǽ)󥭥󥰰ɽμ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();

        /* ͼ */
        $year = $root->mContext->mRequest->getRequest('year');
        $this->categoryCd = $root->mContext->mRequest->getRequest('category_cd');
        $this->column = $root->mContext->mRequest->getRequest('column');
        $this->sort = $root->mContext->mRequest->getRequest('sort');
        if (empty($this->column)) {
            $this->column = _SB_MODULE_DEFAULT_HITTER_RANK_COLUMN;
        }
        if (empty($this->sort)) {
            $this->sort = _SB_MODULE_DEFAULT_HITTER_RANK_SORT;
        }

        /* 󥹥󥹤 */
        $playerResultHitter =& new PlayerResultHitter();
        $team =& new Team();
        $game =& new Game();
        $category =& new Category();
        
        /* ƥꥹȤμ */
        $this->categoryList = $category->getListWithoutDelfg();

        /* ǯꥹȤ */
        $oldYear = $game->getOldestYear();
        $lastYear = $game->getLastestYear();
        if (!is_null($oldYear) && !is_null($lastYear)) {
            $cnt = 0;
            for ($i = $oldYear; $i <= $lastYear; $i++) {
                $this->yearList[$cnt]['value'] = $i;
                $this->yearList[$cnt]['name'] = $i . _MD_SB_TEXT_YEAR;
                $cnt++;
            }
            rsort($this->yearList);
        }
        $this->yearList[$cnt]['value'] = _MD_SB_TEXT_TOTAL;
        $this->yearList[$cnt]['name'] = _MD_SB_TEXT_TOTAL;

        /* ǯ */
        if (!empty($year)) {
            $this->year = $year;
        } else {
            $this->year = $lastYear;
        }

        /* ꥹȤμ */
        $teamList = $team->getAllList();
        /* (Ǥ⥲¿Υ*)ǿȤƼ */
        $maxGameCount = 0;
        $game->setCategoryCd($this->categoryCd);
        foreach ($teamList as $teamItem) {
            $game->setTeamCd($teamItem['team_cd']);
            $gameCount = $game->getGameCount($this->year);
            if ($gameCount > $maxGameCount) {
                $maxGameCount = $gameCount;
            }
        }
        $this->baseAtbats = $maxGameCount * _SB_MODULE_BASE_ATBAT_NUM;

        /* 󥭥󥰥ꥹȤμ */
        $playerResultHitter->setYear($this->year);
        $playerResultHitter->setCategoryCd($this->categoryCd);
        $playerResultHitter->setBaseAtbats($this->baseAtbats);
        $playerResultHitter->setRankSortCond($this->column, $this->sort);
        $this->rankList = $playerResultHitter->getRankList();
    }

    /**
     * ǯ̰ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();
        $render->setTemplateName('sb_view_player_result_hitter.html');
        $render->setAttribute('categoryList', $this->categoryList);
        $render->setAttribute('rankList', $this->rankList);
        $render->setAttribute('baseAtbats', $this->baseAtbats);
        $render->setAttribute('yearList', $this->yearList);
        $render->setAttribute('year', $this->year);
        $render->setAttribute('category_cd', $this->categoryCd);
        $render->setAttribute('column', $this->column);
        $render->setAttribute('sort', $this->sort);
        $render->setAttribute('title', _MD_SB_TITLE_VIEW_PLAYER_RESULT_HITTER);
    }
}
?>