<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * 󹹿饹
 *
 * @since 0.0.4
 * @author saitoh-y
 */
class updateTeamAction extends ActionAbstract  {

    /**
     * ॳ
     *
     * @access private
     * @var Integer
     */
    private $teamCd = 0;

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailTeam = array();

    /**
     * 󹹿μ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $acl =& new Acl();

        /* ͼ */
        $teamCd = $root->mContext->mRequest->getRequest('team_cd');
        $teamName = $root->mContext->mRequest->getRequest('team_name');
        $home = $root->mContext->mRequest->getRequest('home');
        $etc = $root->mContext->mRequest->getRequest('etc');
        $sortNum = $root->mContext->mRequest->getRequest('sort_num');

        /* 桼å */
        $acl->setTeamCd($teamCd);
        if (!$acl->isEditTeam()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        /* 󥹥󥹤 */
        $team =& new Team();

        /* μ */
        $team->setTeamCd($teamCd);
        $detailTeam = $team->getTeam();

        /* ͥå */
        $validate =& new validateUpdateTeamFormAction();
        $validate->prepare();
        $validate->fetch();
        $validate->validate();
        if ($validate->hasError()) {
            $this->detailTeam['team_cd'] = $teamCd;
            $this->detailTeam['team_name'] = $teamName;
            $this->detailTeam['home'] = $home;
            $this->detailTeam['etc'] = $etc;
            $this->detailTeam['sort_num'] = $sortNum;
            $this->detailTeam['image_path'] = $detailTeam['image_path'];
            $this->actionForm = $validate;
            $this->errFg = true;
            return;
        }

        /*  */
        $team->setDataList($teamCd, 'team_cd', _SB_MODULE_DB_SET_INTEGER, true);
        $team->setDataList($teamName, 'team_name', _SB_MODULE_DB_SET_STRING);
        $team->setDataList($home, 'home', _SB_MODULE_DB_SET_STRING);
        $team->setDataList($etc, 'etc', _SB_MODULE_DB_SET_STRING);
        $team->setDataList($sortNum, 'sort_num', _SB_MODULE_DB_SET_INTEGER);
        /* ե뤬Τɲý򤹤 */
        $uploadImageFg = false;
        if (is_uploaded_file($_FILES['image_path']['tmp_name'])) {
            $imageName = getRandamInteger() . strrchr($_FILES['image_path']['name'], '.');
            $imagePath = _SB_MODULE_UPLOAD_IMAGE_PATH . $imageName;
            $imageUrl = _SB_MODULE_UPLOAD_IMAGE_URL . $imageName;
            $team->setDataList($imageUrl, 'image_path', _SB_MODULE_DB_SET_STRING);
            if (move_uploaded_file($_FILES['image_path']['tmp_name'], $imagePath)) {
                $uploadImageFg = true;
            }
        }

        /* 󹹿 */
        if (!$team->update()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_FAILE_UPDATE;
        }
        else {
            if (!empty($detailTeam['image_path']) && $uploadImageFg) {
                /* β */
                $unlink = _SB_MODULE_UPLOAD_IMAGE_PATH . basename($detailTeam['image_path']);
                unlink($unlink);
            }
            $this->teamCd = $teamCd;
        }
    }

    /**
     * ܺٲ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $root->mController->executeRedirect(_SB_MODULE_URL . "index.php?action=detailTeam&team_cd="
            . $this->teamCd, _SB_MODULE_REDIRECT_TIME, _MD_SB_SUCCESS_UPDATE);
    }

    /**
     * ͥ顼ɽ
     *
     */
    function errorView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();
        $render->setTemplateName('sb_edit_team.html');
        $render->setAttribute('action', 'updateTeam');
        $render->setAttribute('detailTeam', $this->detailTeam);
        $render->setAttribute('title', _MD_SB_TITLE_EDIT_TEAM);
        $render->setAttribute('actionForm', $this->actionForm);
        define('XOOPS_FOOTER_INCLUDED', 1);
    }
}
?>