<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * ̹饹
 *
 * @since 0.0.8
 * @author saitoh-y
 */
class updateGameAction extends ActionAbstract  {

    /**
     * 祳
     *
     * @access private
     * @var Integer
     */
    private $gameCd = 0;

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailGame = array();

    /**
     * ƥꥹ
     *
     * @access private
     * @var Array
     */
    private $categoryList = array();

    /**
     * 󹹿μ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $acl =& new Acl();

        /* ͼ */
        $gameCd = $root->mContext->mRequest->getRequest('game_cd');
        $gameName = $root->mContext->mRequest->getRequest('game_name');
        $gameDate = $root->mContext->mRequest->getRequest('game_date');
        $gameSite = $root->mContext->mRequest->getRequest('game_site');
        $topTeamCd = $root->mContext->mRequest->getRequest('top_team_cd');
        $bottomTeamCd = $root->mContext->mRequest->getRequest('bottom_team_cd');
        $topTeamName = $root->mContext->mRequest->getRequest('top_team_name');
        $bottomTeamName = $root->mContext->mRequest->getRequest('bottom_team_name');
        $topTeamCheck = $root->mContext->mRequest->getRequest('top_team_select_check');
        $bottomTeamCheck = $root->mContext->mRequest->getRequest('bottom_team_select_check');
        $gameContent = $root->mContext->mRequest->getRequest('game_content');
        $categoryCd = $root->mContext->mRequest->getRequest('category_cd');

        /* 桼å */
        $acl->setTeamCd($topTeamCd);
        $topEditFg = $acl->isEditGame();
        $acl->setTeamCd($bottomTeamCd);
        $bottomEditFg = $acl->isEditGame();
        $editFg = false;
        if ($topEditFg || $bottomEditFg) {
            $editFg = true;
        }
        if (!$editFg) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        /* 蹶并̾϶ˤʤ礬ΤǺ */
        $team =& new Team();
        $this->teamList = $team->getAllList();
        $teamList = array_set_key($this->teamList, 'team_cd');
        $topTeamName = (empty($topTeamName)) ? $teamList[$topTeamCd]['team_name'] : $topTeamName;
        $bottomTeamName = (empty($bottomTeamName)) ? $teamList[$bottomTeamCd]['team_name'] :
            $bottomTeamName;

        /* ˥󥰤ĹΤǥ롼 */
        $topResultList = array();
        $bottomResultList = array();
        for ($ining = 1; $ining <= _SB_MODULE_MAXINING; $ining++) {
            $topResultList[$ining] = $root->mContext->mRequest->getRequest('top_' . $ining);
            $bottomResultList[$ining] = $root->mContext->mRequest->getRequest('bottom_' . $ining);
        }

        /* ͥå */
        $validate =& new validateUpdateGameFormAction();
        $validate->prepare();
        $validate->fetch();
        $validate->validate();
        if ($validate->hasError()) {
            /* ͺ */
            $this->detailGame['game_cd'] = $gameCd;
            $this->detailGame['game_name'] = $gameName;
            $this->detailGame['game_date'] = $gameDate;
            $this->detailGame['game_site'] = $gameSite;
            $this->detailGame['top_team_cd'] = $topTeamCd;
            $this->detailGame['bottom_team_cd'] = $bottomTeamCd;
            $this->detailGame['top_team_name'] = $topTeamName;
            $this->detailGame['bottom_team_name'] = $bottomTeamName;
            $this->detailGame['top_team_select_check'] = $topTeamCheck;
            $this->detailGame['bottom_team_select_check'] = $bottomTeamCheck;
            $this->detailGame['game_content'] = $gameContent;
            $this->detailGame['category_cd'] = $categoryCd;
            $topScore = 0;
            $bottomScore = 0;
            for ($ining = 1; $ining <= _SB_MODULE_MAXINING; $ining++) {
                $this->detailGame['top_' . $ining] = $topResultList[$ining];
                $topScore = $topResultList[$ining] + $topScore;
                $this->detailGame['bottom_' . $ining] = $bottomResultList[$ining];
                $bottomScore = $bottomResultList[$ining] + $bottomScore;
                $this->detailGame['topList'][$ining] = $topResultList[$ining];
                $this->detailGame['bottomList'][$ining] = $bottomResultList[$ining];
            }
            $this->detailGame['top_score'] = $topScore;
            $this->detailGame['bottom_score'] = $bottomScore;
            $category =& new Category();
            $category->setCategoryCd($this->detailGame['category_cd']);
            $this->categoryList = $category->getListWithoutDelfgOrCategoryCd();

            $this->actionForm = $validate;
            $this->errFg = true;
            return;
        }

        /* 󥹥󥹤 */
        $game =& new Game();

        /* 򥻥å */
        $game->setDataList($gameCd, 'game_cd', _SB_MODULE_DB_SET_INTEGER, true);
        $game->setDataList($gameName, 'game_name', _SB_MODULE_DB_SET_STRING);
        $game->setDataList($gameDate, 'game_date', _SB_MODULE_DB_SET_DATE);
        $game->setDataList($gameSite, 'game_site', _SB_MODULE_DB_SET_STRING);
        $game->setDataList($topTeamCd, 'top_team_cd', _SB_MODULE_DB_SET_INTEGER);
        $game->setDataList($bottomTeamCd, 'bottom_team_cd', _SB_MODULE_DB_SET_INTEGER);
        $game->setDataList($topTeamName, 'top_team_name', _SB_MODULE_DB_SET_STRING);
        $game->setDataList($bottomTeamName, 'bottom_team_name', _SB_MODULE_DB_SET_STRING);
        $game->setDataList($gameContent, 'game_content', _SB_MODULE_DB_SET_STRING);
        for ($ining = 1; $ining <= _SB_MODULE_MAXINING; $ining++) {
            $game->setDataList($topResultList[$ining], 'top_' . $ining, _SB_MODULE_DB_SET_STRING);
            $game->setDataList($bottomResultList[$ining], 'bottom_' . $ining,
                _SB_MODULE_DB_SET_STRING);
        }
        $game->setDataList($categoryCd, 'category_cd', _SB_MODULE_DB_SET_INTEGER);

        /* 󹹿 */
        if (!$game->update()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_FAILE_UPDATE;
        }
        else {
            /* ӥޥå׹(/ɲ) */
            if (!empty($topTeamCd) || !empty($bottomTeamCd)) {
                $teamResult =& new TeamResult();
                $teamResult->destroyDataList();
                $teamResult->setDataList($gameCd, 'game_cd', _SB_MODULE_DB_SET_INTEGER, true);
                /* Υޥåפ */
                $teamResult->delete();
                if (!empty($topTeamCd)) {
                    $teamResult->setDataList($topTeamCd, 'team_cd', _SB_MODULE_DB_SET_INTEGER);
                    $teamResult->insert();
                }
                if (!empty($bottomTeamCd) && $bottomTeamCd != $topTeamCd) {
                    $teamResult->setDataList($bottomTeamCd, 'team_cd', _SB_MODULE_DB_SET_INTEGER);
                    $teamResult->insert();
                }
            }

            /* ӹ(蹶ե饰) */
            $playerResultHitter = new PlayerResultHitter();
            $playerResultHitter->setGameCd($gameCd);
            $playerResultPitcher = new PlayerResultPitcher();
            $playerResultPitcher->setGameCd($gameCd);
            $player = new Player();

            $teamCdList = array($topTeamCd, $bottomTeamCd);
            $topFgList = array(1, 0); // 1:蹶2:并

            for ($i = 0; $i < 2; $i++) {
                if (!empty($teamCdList[$i])) {
                    $player->setTeamCd($teamCdList[$i]);
                    $playerCdList = $player->getPlayerCdList();

                    /* (Ǽ) */
                    $playerResultHitter->setTopFg($topFgList[$i]);
                    $playerResultHitterList = $playerResultHitter->getPlayerResultHitterList();
                    if (@!in_array($playerResultHitterList[0]["team_cd"], $teamCdList)) {
                        /* ब㤦ϴ¸ξ */
                        $playerResultHitter->destroyDataList();
                        $playerResultHitter->setDataList($gameCd, "game_cd",
                            _SB_MODULE_DB_SET_INTEGER, true);
                        $playerResultHitter->setDataList($topFgList[$i], "top_fg",
                            _SB_MODULE_DB_SET_INTEGER, true);
                        $playerResultHitter->delete();
                    }

                    /* () */
                    $playerResultPitcher->setTopFg($topFgList[$i]);
                    $playerResultPitcherList = $playerResultPitcher->getPlayerResultPitcherList();
                    if (@!in_array($playerResultPitcherList[0]["team_cd"], $teamCdList)) {
                        /* ब㤦ϴ¸ξ */
                        $playerResultPitcher->destroyDataList();
                        $playerResultPitcher->setDataList($gameCd, "game_cd",
                            _SB_MODULE_DB_SET_INTEGER, true);
                        $playerResultPitcher->setDataList($topFgList[$i], "top_fg",
                            _SB_MODULE_DB_SET_INTEGER, true);
                        $playerResultPitcher->delete();
                    }

                    if (!empty($playerCdList)) {
                        $playerResultHitter->updateTopFg($playerCdList);
                        $playerResultPitcher->updateTopFg($playerCdList);
                    }

                }
            }

            $this->gameCd = $gameCd;
        }
    }

    /**
     * ̲̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $root->mController->executeRedirect(_SB_MODULE_URL . "index.php?action=detailGame&game_cd="
            . $this->gameCd, _SB_MODULE_REDIRECT_TIME, _MD_SB_SUCCESS_UPDATE);
    }

    /**
     * ͥ顼ɽ
     *
     */
    function errorView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();
        $render->setTemplateName('sb_edit_game.html');
        $render->setAttribute('action', 'updateGame');
        $render->setAttribute('teamList', $this->teamList);
        $render->setAttribute('categoryList', $this->categoryList);
        $render->setAttribute('detailGame', $this->detailGame);
        $render->setAttribute('title', _MD_SB_TITLE_EDIT_TEAM);
        $render->setAttribute('actionForm', $this->actionForm);
        define('XOOPS_FOOTER_INCLUDED', 1);
    }
}
?>