<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * ()(Ͽ/)饹
 *
 * @since 0.0.4
 * @author saitoh-y
 */
class regiPlayerResultPitcherAction extends ActionAbstract  {

    /**
     * 祳
     *
     * @access private
     * @var Integer
     */
    private $gameCd = 0;

    /**
     * 蹶ե饰
     *
     * @access private
     * @var boolean
     */
    private $topFg = false;

    /**
     * ǯ
     *
     * @access private
     * @var Integer
     */
    private $year = 0;

    /**
     * ()ꥹ
     *
     * @access private
     * @var Array
     */
    private $playerResultPitcherList = array();

    /**
     * ॳ
     *
     * @access private
     * @var Integer
     */
    private $teamCd = 0;

    /**
     * ꥹ
     *
     * @access private
     * @var Array
     */
    private $playerList = array();

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailTeam = array();

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailGame = array();

    /**
     * Хǡȥե饰
     *
     * @access private
     * @var boolean
     */
    private $validateFg = false;

    /**
     * Ϣ³Ͽե饰
     *
     * @access private
     * @var boolean
     */
    private $unbrokenFg = false;

    /**
     * ӹμ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $acl =& new Acl();

        /* ͼ */
        $this->gameCd = $root->mContext->mRequest->getRequest('game_cd');
        $this->teamCd = $root->mContext->mRequest->getRequest('team_cd');
        $this->topFg = $root->mContext->mRequest->getRequest('top_fg');
        $playerCdList = explode(",", $root->mContext->mRequest->getRequest('player_cd'));
        $pitcherOrderList = $root->mContext->mRequest->getRequest('pitcher_order');
        $resultCdList = $root->mContext->mRequest->getRequest('result_cd');
        $IPList = $root->mContext->mRequest->getRequest('IP');
        $IPOutList = $root->mContext->mRequest->getRequest('IP_out');
        $NPList = $root->mContext->mRequest->getRequest('NP');
        $BFList = $root->mContext->mRequest->getRequest('BF');
        $OBAList = $root->mContext->mRequest->getRequest('OBA');
        $HRList = $root->mContext->mRequest->getRequest('HR');
        $KList = $root->mContext->mRequest->getRequest('K');
        $BBList = $root->mContext->mRequest->getRequest('BB');
        $HBPList = $root->mContext->mRequest->getRequest('HBP');
        $WPList = $root->mContext->mRequest->getRequest('WP');
        $RList = $root->mContext->mRequest->getRequest('R');
        $ERList = $root->mContext->mRequest->getRequest('ER');
        $this->unbrokenFg = $root->mContext->mRequest->getRequest('unbrokenFg');

        /* 桼å */
        $acl->setTeamCd($this->teamCd);
        if (!$acl->isEditTeam() && !$acl->isEditGame()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        for ($i = 0; $i <= count($playerCdList); $i++) {
            if (!empty($pitcherOrderList[$i])) {
                $this->playerResultPitcherList[$i]['player_cd'] = $playerCdList[$i];
                $this->playerResultPitcherList[$i]['pitcher_order'] = $pitcherOrderList[$i];
                @$this->playerResultPitcherList[$i]['result_cd'] = $resultCdList[$i];
                $this->playerResultPitcherList[$i]['IP'] = $IPList[$i];
                $this->playerResultPitcherList[$i]['IP_out'] = $IPOutList[$i];
                $this->playerResultPitcherList[$i]['NP'] = $NPList[$i];
                $this->playerResultPitcherList[$i]['BF'] = $BFList[$i];
                $this->playerResultPitcherList[$i]['OBA'] = $OBAList[$i];
                $this->playerResultPitcherList[$i]['HR'] = $HRList[$i];
                $this->playerResultPitcherList[$i]['K'] = $KList[$i];
                $this->playerResultPitcherList[$i]['BB'] = $BBList[$i];
                $this->playerResultPitcherList[$i]['HBP'] = $HBPList[$i];
                $this->playerResultPitcherList[$i]['WP'] = $WPList[$i];
                $this->playerResultPitcherList[$i]['R'] = $RList[$i];
                $this->playerResultPitcherList[$i]['ER'] = $ERList[$i];
            }
        }

        /* ͥå */
        $validate =& new validateRegiPlayerResultPitcherFormAction();
        $validate->prepare();
        $validate->fetch();
        $validate->validate();
        if ($validate->hasError()) {
            /* ͺ */
            $this->actionForm = $validate;
            $this->validateFg = true;

            /* 󥹥 */
            $team =& new Team();
            $game =& new Game();
            $player =& new Player();

            /*  */
            $team->setTeamCd($this->teamCd);
            $this->detailTeam = $team->getTeam();

            /*  */
            $player->setTeamCd($this->teamCd);
            $this->playerList = $player->getPlayerList();

            /*  */
            $game->setGameCd($this->gameCd);
            $gameResult = $game->getGame();
            setGameScore($gameResult);
            $this->detailGame = $gameResult;
            for ($i = 1; $i <= _SB_MODULE_MAXINING; $i++) {
                $this->detailGame['topList'][$i] = $gameResult['top_' . $i];
                $this->detailGame['bottomList'][$i] = $gameResult['bottom_' . $i];
            }

            $this->errFg = true;
            return;
        }

        /* 󥹥󥹤 */
        $playerResult =& new PlayerResultPitcher();

        /* () */
        $playerResult->setDataList($this->topFg, 'top_fg', _SB_MODULE_DB_SET_INTEGER, true);
        $playerResult->setDataList($this->gameCd, 'game_cd', _SB_MODULE_DB_SET_INTEGER, true);
        if ($playerResult->delete()) {
            foreach ($this->playerResultPitcherList as $playerResultPitcher) {
                if (!empty($playerResultPitcher['pitcher_order'])) {
                    $playerResult->setDataList($playerResultPitcher['player_cd'], 'player_cd',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['pitcher_order'],
                        'pitcher_order', _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['result_cd'], 'result_cd',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['IP'] * 3 + $playerResultPitcher
                        ['IP_out'], 'IP', _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['NP'], 'NP',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['BF'], 'BF',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['OBA'], 'OBA',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['HR'], 'HR',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['K'], 'K',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['BB'], 'BB',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['HBP'], 'HBP',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['WP'], 'WP',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['R'], 'R',
                        _SB_MODULE_DB_SET_INTEGER);
                    $playerResult->setDataList($playerResultPitcher['ER'], 'ER',
                        _SB_MODULE_DB_SET_INTEGER);

                    /* ()ɲ */
                    if (!$playerResult->insert()) {
                        $this->errFg = true;
                        $this->errMsg = _MD_SB_FAILE_REGIST;
                    }
                }
            }
        }
        else {
            $this->errFg = true;
            $this->errMsg = _MD_SB_FAILE_REGIST;
        }
    }

    /**
     * ̡̲⤷()Խ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        /* ()Խ */
        if ($this->unbrokenFg) {
            $root->mController->executeRedirect(_SB_MODULE_URL .
                "index.php?action=editPlayerResultPitcher&team_cd=" . $this->teamCd . "&game_cd=" .
                $this->gameCd . "&top_fg=" . $this->topFg, _SB_MODULE_REDIRECT_TIME,
                _MD_SB_SUCCESS_REGIST);
        }
        /* ̲ */
        else {
            $root->mController->executeRedirect(_SB_MODULE_URL .
                "index.php?action=detailGame&game_cd=&game_cd=" . $this->gameCd,
                _SB_MODULE_REDIRECT_TIME, _MD_SB_SUCCESS_REGIST);
        }
    }

    /**
     * ͥ顼ɽ
     *
     */
    function errorView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();

        $render->setTemplateName('sb_edit_player_result_pitcher.html');
        $render->setAttribute('action', 'regiPlayerResultPitcher');
        $render->setAttribute('playerResultPitcherList', $this->playerResultPitcherList);
        $render->setAttribute('playerList', $this->playerList);
        $render->setAttribute('detailTeam', $this->detailTeam);
        $render->setAttribute('detailGame', $this->detailGame);
        $render->setAttribute('topFg', $this->topFg);
        $render->setAttribute('validateFg', $this->validateFg);
        $render->setAttribute('unbrokenFg', $this->unbrokenFg);
        $render->setAttribute('actionForm', $this->actionForm);
        $render->setAttribute('title', _MD_SB_TITLE_EDIT_PLAYER_RESULT_HITTER);
        define('XOOPS_FOOTER_INCLUDED', 1);
    }
}
?>