<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * ̾ܺ٥饹
 *
 * @since 0.0.4
 * @author saitoh-y
 */
class detailGameAction extends ActionAbstract {

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailGame = array();

    /**
     * ꥹ
     *
     * @access private
     * @var Array
     */
    private $playerList = array();

    /**
     * 蹶(Ǽ)ꥹ
     *
     * @access private
     * @var Array
     */
    private $topResultHitterList = array();

    /**
     * 蹶()ꥹ
     *
     * @access private
     * @var Array
     */
    private $topResultPitcherList = array();

    /**
     * 并(Ǽ)ꥹ
     *
     * @access private
     * @var Array
     */
    private $bottomResultHitterList = array();

    /**
     * 并()ꥹ
     *
     * @access private
     * @var Array
     */
    private $bottomResultPitcherList = array();

    /**
     * ̾ܺɽμ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();

        /* ͼ */
        $gameCd = $root->mContext->mRequest->getRequest('game_cd');

        /* 󥹥󥹤 */
        $game =& new Game();
        $playerResultHitter =& new PlayerResultHitter();
        $playerResultPitcher =& new PlayerResultPitcher();

        /* ̾μ */
        $game->setGameCd($gameCd);
        $gameResult = $game->getGame();

        /* ¸ߥå */
        if (empty($gameResult)) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NODATA;
            return;
        }

        /* ׻ */
        setGameScore($gameResult);
        $this->detailGame = $gameResult;
        for ($i = 1; $i <= _SB_MODULE_MAXINING; $i++) {
            $this->detailGame['topList'][$i] = $gameResult['top_' . $i];
            $this->detailGame['bottomList'][$i] = $gameResult['bottom_' . $i];
        }

        /* (Ǽ)μ */
        $playerResultHitter->setGameCd($gameCd);
        $playerResultHitter->setTopFg(1);
        $this->topResultHitterList = $playerResultHitter->getPlayerResultHitterList();
        setStartFg($this->topResultHitterList);
        $playerResultHitter->setTopFg(0);
        $this->bottomResultHitterList = $playerResultHitter->getPlayerResultHitterList();
        setStartFg($this->bottomResultHitterList);

        /* ()μ */
        $playerResultPitcher->setGameCd($gameCd);
        $playerResultPitcher->setTopFg(1);
        $this->topResultPitcherList = $playerResultPitcher->getPlayerResultPitcherList();
        setOut2Ining4List($this->topResultPitcherList);
        $playerResultPitcher->setTopFg(0);
        $this->bottomResultPitcherList = $playerResultPitcher->getPlayerResultPitcherList();
        setOut2Ining4List($this->bottomResultPitcherList);

    }

    /**
     * ܺٲ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();
        $actionForm =& new validateDeleteGameFormAction();
        $acl =& new Acl();
        $acl->setTeamCd($this->detailGame['top_team_cd']);
        $topEditFg = $acl->isEditGame();
        $acl->setTeamCd($this->detailGame['bottom_team_cd']);
        $bottomEditFg = $acl->isEditGame();
        $editFg = false;
        if ($topEditFg || $bottomEditFg) {
            $editFg = true;
        }

        $render->setTemplateName('sb_detail_game.html');
        $render->setAttribute('detailGame', $this->detailGame);
        $render->setAttribute('topResultHitterList', $this->topResultHitterList);
        $render->setAttribute('topResultPitcherList', $this->topResultPitcherList);
        $render->setAttribute('bottomResultHitterList', $this->bottomResultHitterList);
        $render->setAttribute('bottomResultPitcherList', $this->bottomResultPitcherList);
        $render->setAttribute('actionForm', $actionForm);
        $render->setAttribute('admin', $editFg);
        $render->setAttribute('topEdit', $topEditFg);
        $render->setAttribute('bottomEdit', $bottomEditFg);
        $render->setAttribute('title', _MD_SB_TITLE_DETAIL_GAME);
    }
}
?>