<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * 饹
 *
 * @since 0.0.4
 * @author saitoh-y
 */
class deletePlayerAction extends ActionAbstract {

    /**
     * ॳ
     *
     * @access private
     * @var Integer
     */
    private $teamCd;

    /**
     * μ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $acl =& new Acl();

        /* ͼ */
        $playerCd = $root->mContext->mRequest->getRequest('player_cd');
        $this->teamCd = $root->mContext->mRequest->getRequest('team_cd');

        /* 桼å */
        $acl->setTeamCd($this->teamCd);
        if (!$acl->isEditPlayer()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        /* 󥹥󥹤 */
        $player =& new Player();

        /* ͥå */
        $player->setPlayerCd($playerCd);
        $detailPlayer = $player->getPlayer();
        $validate =& new validateDeletePlayerFormAction();
        $validate->prepare();
        $validate->fetch();
        $validate->validate();
        if ($validate->hasError() || empty($detailPlayer)) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_BADDATA;
            return;
        }

        /* 򥻥å */
        $player->setDataList($playerCd, 'player_cd', _SB_MODULE_DB_SET_INTEGER, true);

        /* 󹹿 */
        if (!$player->delete()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_FAILE_DELETE;
        }
        else {
            /* ¾ơ֥Υ쥳ɤ */
            $playerResultHitter =& new PlayerResultHitter();
            $playerResultPitcher =& new PlayerResultPitcher();

            /* (Ǽ)κ */
            $playerResultHitter->setDataList($playerCd, 'player_cd', _SB_MODULE_DB_SET_INTEGER, true
                );
            $playerResultHitter->delete();

            /* ()κ */
            $playerResultPitcher->setDataList($playerCd, 'player_cd', _SB_MODULE_DB_SET_INTEGER,
                true);
            $playerResultPitcher->delete();
        }
    }

    /**
     * ȥåץڡ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $root->mController->executeRedirect(_SB_MODULE_URL . "index.php?action=detailTeam&team_cd="
            . $this->teamCd, _SB_MODULE_REDIRECT_TIME, _MD_SB_SUCCESS_DELETE);
    }
}
?>