<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}

if (!defined('_SB_DIRNAME')) {
    define('_SB_DIRNAME', basename(dirname(dirname(__FILE__))));
}
require_once XOOPS_MODULE_PATH . "/" . _SB_DIRNAME . '/inc/inc.php';
require_once _SB_MODULE_PATH . 'inc/util.php';
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * ǿ̰֥å饹
 *
 */
class scorebook_ViewLastRankHitterBlock extends Legacy_BlockProcedure {
    var $options = array();

    /**
     * 󥹥ȥ饯
     *
     * @param object $block
     * @return scorebook_ViewLastRankHitterBlock
     */
    function scorebook_ViewLastRankHitterBlock(&$block) {

        parent::Legacy_BlockProcedure($block);
        $this->options = explode('|', $this->_mBlock->get('options'));

        if (empty($this->options[0])) {
            $this->options[0] = 'AVG';
        }
        if (empty($this->options[1])) {
            $this->options[1] = '3';
        }
    }

    /**
     * ֥åɽ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $root->mLanguageManager->loadBlockMessageCatalog($this->_mBlock->get('dirname'));

        /* ͼ */
        $year = date('Y');
        $column = $this->options[0];
        $sort = 'DESC';
        $limit = $this->options[1];

        /* 󥹥󥹤 */
        $playerResultHitter =& new PlayerResultHitter();
        $team =& new Team();
        $game =& new Game();

        /* ꥹȤμ */
        $teamList = $team->getAllList();
        /* (Ǥ⥲¿Υ*)ǿȤƼ */
        $maxGameCount = 0;
        foreach ($teamList as $teamItem) {
            $game->setTeamCd($teamItem['team_cd']);
            $gameCount = $game->getGameCount($year);
            if ($gameCount > $maxGameCount) {
                $maxGameCount = $gameCount;
            }
        }
        $baseAtbats = $maxGameCount * _SB_MODULE_BASE_ATBAT_NUM;

        /* 󥭥󥰥ꥹȤμ */
        $playerResultHitter->setYear($year);
        $playerResultHitter->setBaseAtbats($baseAtbats);
        $playerResultHitter->setRankSortCond($column, $sort);
        $playerResultHitter->setLimit($limit);
        $rankList = $playerResultHitter->getRankList();

        $render =& $this->getRenderTarget();
        $render->setTemplateName($this->_mBlock->get('template'));
        $render->setAttribute('mid', $this->_mBlock->get('mid'));
        $render->setAttribute('bid', $this->_mBlock->get('bid'));
        $render->setAttribute('rankList', $rankList);
        $render->setAttribute('_TEXT_PLAYER_NAME', _MB_SB_TEXT_PLAYER_NAME);
        $render->setAttribute('_TEXT_AVG', _MB_SB_TEXT_AVG);
        $render->setAttribute('_TEXT_ATBATS', _MB_SB_TEXT_ATBATS);
        $render->setAttribute('_TEXT_HITS', _MB_SB_TEXT_HITS);
        $render->setAttribute('_TEXT_HR', _MB_SB_TEXT_HR);
        $render->setAttribute('_TEXT_RBI', _MB_SB_TEXT_RBI);
        $render->setAttribute('_TEXT_SB', _MB_SB_TEXT_SB);
        $render->setAttribute('sb_url', _SB_MODULE_URL);
        $render->setAttribute('column', $column);
        $renderSystem =& $root->getRenderSystem($this->getRenderSystemName());
        $renderSystem->renderBlock($render);
    }

    /**
     * ֥åԽ᥽å
     *
     * @return unknown
     */
    function getOptionForm() {
        $options = explode('|', $this->_mBlock->get('options'));
        $options[1] = (int) $options[1];
        $mydirname = $this->_mBlock->get('dirname');

        if (preg_match('/[^0-9a-zA-Z_-]/', $mydirname)) {
            die('Invalid dirname');
        }
        $root =& XCube_Root::getSingleton();
        $root->mLanguageManager->loadBlockMessageCatalog($mydirname);

        $AVG = "";
        $hits = "";
        $HR = "";
        $RBI = "";
        $SB = "";
        if ($options[0] == 'AVG') {
            $AVG = ' selected';
        }
        elseif ($options[0] == 'hits') {
            $hits = ' selected';
        }
        elseif ($options[0] == 'HR') {
            $HR = ' selected';
        }
        elseif ($options[0] == 'RBI') {
            $RBI = ' selected';
        }
        elseif ($options[0] == 'SB') {
            $SB = ' selected';
        }
        $select = '<select name="options[]">';
        $select .= '<option value="AVG"' . $AVG . '>' . _MB_SB_TEXT_AVG;
        $select .= '<option value="hits"' . $hits . '>' . _MB_SB_TEXT_HITS;
        $select .= '<option value="HR"' . $HR . '>' . _MB_SB_TEXT_HR;
        $select .= '<option value="RBI"' . $RBI . '>' . _MB_SB_TEXT_RBI;
        $select .= '<option value="SB"' . $SB . '>' . _MB_SB_TEXT_SB;
        $select .= '</select>';
        $form = '<table>';
        $form .= '<tr><td>' . _MB_SB_TEXT_LAST_HITTER_COLUMN . '</td><td>' . $select . '</td></tr>';
        $form .= sprintf(
            '<tr><td>%s:</td><td><input type="text" name="options[]" value="%d" /></td></tr>',
            _MB_SB_TEXT_LAST_HITTER_LIMIT, intval($options[1]));
        $form .= '</table>';
        return $form;
    }

}
?>