<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * <>ƥɲå饹
 *
 * @since 1.0.0
 * @author saitoh-y
 */
class insertCategoryAction extends ActionAbstract {

    /**
     * ƥ
     *
     * @access private
     * @var Array
     */
    private $detailcategory = Array();
    
    /**
     * ƥɲäμ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $acl =& new Acl();

        /* 桼å */
        if (!$acl->isAdmin()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        /* ͼ */
        $categoryName = $root->mContext->mRequest->getRequest('category_name');
        $categoryContent = $root->mContext->mRequest->getRequest('category_content');
        $sortNum = $root->mContext->mRequest->getRequest('sort_num');
        $actFg = $root->mContext->mRequest->getRequest('act_fg');

        /* ͥå */
        $validate =& new validateInsertCategoryFormAction();
        $validate->prepare();
        $validate->fetch();
        $validate->validate();
        if ($validate->hasError()) {
            $this->detailcategory['category_name'] = $categoryName;
            $this->detailcategory['category_content'] = $categoryContent;
            $this->detailcategory['sort_num'] = $sortNum;
            $this->detailcategory['act_fg'] = $actFg;
            $this->actionForm = $validate;
            $this->errFg = true;
            return;
        }

        /* 󥹥󥹤 */
        $category =& new Category();

        /* ƥ򥻥å */
        $category->setDataList($categoryName, 'category_name', _SB_MODULE_DB_SET_STRING);
        $category->setDataList($categoryContent, 'category_content', _SB_MODULE_DB_SET_STRING);
        $category->setDataList($sortNum, 'sort_num', _SB_MODULE_DB_SET_INTEGER);
        $category->setDataList($actFg, 'act_fg', _SB_MODULE_DB_SET_INTEGER);

        /* ƥɲ */
        if (!$category->insert()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_FAILE_INSERT;
        }
    }

    /**
     * ƥ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $root->mController->executeRedirect(_SB_MODULE_URL . "admin/index.php?action=viewCategory",
            _SB_MODULE_REDIRECT_TIME, _MD_SB_SUCCESS_INSERT);
    }

    /**
     * ͥ顼ɽ
     *
     */
    function errorView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();

        $render->setTemplateName(_SB_MODULE_PATH . 'templates/admin_editCategory.html');
        $render->setAttribute('moduleName', $root->mContext->mModule->mXoopsModule->getVar('name'));
        $render->setAttribute('category', $this->detailcategory);
        $render->setAttribute('actionForm', $this->actionForm);
        $render->setAttribute('action', "insertCategory");
    }
}
?>