package net.souko105.flashserver.javaee.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.souko105.flashserver.HttpHeaderConst;
import net.souko105.flashserver.util.IOUtils;

import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

/**
 * t@Co̓T[ubg
 * XGXgpXt@CAԂ܂B
 * @author AKatayama
 */
public class FileSavingServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	
    public static final String PARAM_APP_ROOT = "appRootPath";
    
    private String appRootPath;
    private Map mimeTypeMap = new HashMap();
    
    public FileSavingServlet()
    {
        super();

    }
    public void init() throws ServletException
    {
        this.appRootPath = getInitParameter(PARAM_APP_ROOT);
        if(appRootPath == null)
            throw new ServletException("InitParameter [appRootPath] not found.");
        
        //load mimetype
        initMime();
    }
    /**
     * mimeType܂B
     * @throws ServletException
     */
    protected void initMime() throws ServletException
    {
    	InputStream is = getClass().getResourceAsStream("mime.xml");
    	if(is == null)
    		throw new ServletException("mime.xml not found.");
    	
    	Digester digester = new Digester();
    	
        digester.addCallMethod("mime/mime-mapping","addMimeType", 2);
		digester.addCallParam("mime/mime-mapping/extension",0);
		digester.addCallParam("mime/mime-mapping/mime-type",1);
		
		digester.push(this);
		try
		{
			digester.parse(is);
		}
		catch(IOException ioe)
		{
			throw new ServletException("Mime digest fail. "+ioe.getMessage());
		}
		catch(SAXException se)
		{
			throw new ServletException("Mime parse fail. "+se.getMessage());
		}
    }    
    public void addMimeType(String ext,String type)
    {
    	this.mimeTypeMap.put(ext,type);    	
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException
    {
        doIt(req,res);
    }
    protected void doPost(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException
    {
        doIt(req,res);
    }
    protected void doIt(HttpServletRequest req, HttpServletResponse res) throws ServletException,IOException
    {
        String uri = req.getRequestURI();
        String realPath = this.appRootPath + uri;
        
        File fileOrDir = new File(realPath);
        if(!fileOrDir.exists())
        {
        	res.setStatus(HttpServletResponse.SC_NOT_FOUND);
        	return;
        }
        
        if(fileOrDir.isFile())
        {
        	File file = fileOrDir;
        	Date lastModifyDate = new Date(file.lastModified());
        	res.setHeader(HttpHeaderConst.LASTMODIFIED,IOUtils.HEADER_DATE_FORMAT.format(lastModifyDate));
        	String ifModified = req.getHeader(HttpHeaderConst.IFMODIFIEDSINCE);
        	//ύXǂ
            if(!isModifiedSince(lastModifyDate,ifModified))
            {
            	res.setStatus(HttpServletResponse.SC_NOT_MODIFIED);
            	return ;
            }       	
        	
            FileInputStream fin = new FileInputStream(file);
            ServletOutputStream sout = res.getOutputStream();
            try
            {
	            int size = IOUtils.copyStream(fin,sout);
	            setContentType(res,file);
	            res.setContentLength(size);
	            res.setStatus(HttpServletResponse.SC_OK);
            }
            finally
            {
	            fin.close();
	            sout.flush();
	            sout.close();
            }
            return;
        }
        else
        {
            //TODO welcomefile set
            res.setStatus(HttpServletResponse.SC_NOT_FOUND);
            return;
        }
    }    
    /**
     * t@CύXǂ
     * @param fileLastModify
     * @param ifModifiedSince
     * @return ύXĂꍇtrue,ĂȂꍇfalse
     */
    protected boolean isModifiedSince(Date fileLastModify,String ifModifiedSince)
    {
    	if(ifModifiedSince == null)
    		return true;
    	try
        {
            long ifModifiedTime = IOUtils.HEADER_DATE_FORMAT.parse(ifModifiedSince.trim()).getTime();
            long lastModifyTime = fileLastModify.getTime();
            if(lastModifyTime <= ifModifiedTime)
                return false;
            else
            	return true;
        }
    	catch(NumberFormatException ne)
    	{
    		return true;
    	}
        catch(ParseException e){
            return true;
        }
    }
    protected void setContentType(HttpServletResponse res,File file)
    {
        String name = file.getName();
        int dotIndex = name.lastIndexOf(".");
        if(dotIndex >= 0)
        {
        	try
        	{
	        	String ext = name.substring(dotIndex+1);
	        	String type = (String)mimeTypeMap.get(ext);
	        	if(type == null)
	        		type = (String)mimeTypeMap.get(ext.toLowerCase());
	        	if(type == null)
	        		type = (String)mimeTypeMap.get(ext.toUpperCase());
	        	
	        	if(type != null)
	        	{
	        		res.setContentType(type);
	        		return ;
	        	}
        	}
        	catch(Exception e)
        	{
        		//ignore
        	}
        }
        //default
        res.setContentType("text/html");
    }
}
