package net.souko105.flashserver.javaee.imp;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

import org.apache.commons.collections.iterators.IteratorEnumeration;

/**
 * FilterConfigNX
 * @author AKatayama
 */
public class FilterConfigImp implements FilterConfig {

    private Map initParameter = new HashMap();
    private String filterName;
    private ServletContext servletContext;
	
	public String getFilterName()
	{
		return filterName;
	}
	public ServletContext getServletContext()
	{
		return servletContext;
	}
	public String getInitParameter(String key)
	{
		return (String)initParameter.get(key);
	}
	public Enumeration getInitParameterNames()
	{
		return new IteratorEnumeration(initParameter.keySet().iterator());
	}

	//non interface method
    public void addInitParameter(String key,String value)
    {
        initParameter.put(key,value);
    }    
    public void setServletContext(ServletContext servletContext)
    {
        this.servletContext = servletContext;
    }
    public void setFilterName(String filterName)
    {
        this.filterName = filterName;
    }
}
