/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.util.Vector;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.MemberDefinition;

public class ImplementationType
extends ClassType {
    public String getTypeDescription() {
        return "Implementation";
    }

    private boolean initialize(ContextStack contextStack, boolean bl) {
        boolean bl2 = false;
        ClassDefinition classDefinition = this.getClassDefinition();
        if (this.initParents(contextStack)) {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            try {
                if (this.addRemoteInterfaces(vector, true, contextStack) != null) {
                    boolean bl3 = false;
                    for (int i = 0; i < vector.size(); ++i) {
                        InterfaceType interfaceType = (InterfaceType)vector.elementAt(i);
                        if (interfaceType.isType(4096) || interfaceType.isType(524288)) {
                            bl3 = true;
                        }
                        ImplementationType.copyRemoteMethods(interfaceType, vector2);
                    }
                    if (!bl3) {
                        ImplementationType.failedConstraint(8, bl, contextStack, this.getQualifiedName());
                        return false;
                    }
                    if (this.checkMethods(classDefinition, vector2, contextStack, bl)) {
                        bl2 = this.initialize(vector, vector2, null, contextStack, bl);
                    }
                }
            }
            catch (ClassNotFound classNotFound) {
                ImplementationType.classNotFound(contextStack, classNotFound);
            }
        }
        return bl2;
    }

    private static void copyRemoteMethods(InterfaceType interfaceType, Vector vector) {
        if (interfaceType.isType(4096)) {
            CompoundType.Method[] methodArray = interfaceType.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                CompoundType.Method method = methodArray[i];
                if (vector.contains(method)) continue;
                vector.addElement(method);
            }
            InterfaceType[] interfaceTypeArray = interfaceType.getInterfaces();
            for (int i = 0; i < interfaceTypeArray.length; ++i) {
                ImplementationType.copyRemoteMethods(interfaceTypeArray[i], vector);
            }
        }
    }

    private ImplementationType(ContextStack contextStack, ClassDefinition classDefinition) {
        super(0x6010000, classDefinition, contextStack);
    }

    private static boolean couldBeImplementation(boolean bl, ContextStack contextStack, ClassDefinition classDefinition) {
        boolean bl2 = false;
        BatchEnvironment batchEnvironment = contextStack.getEnv();
        try {
            if (!classDefinition.isClass()) {
                ImplementationType.failedConstraint(17, bl, contextStack, classDefinition.getName());
            } else {
                bl2 = batchEnvironment.defRemote.implementedBy(batchEnvironment, classDefinition.getClassDeclaration());
                if (!bl2) {
                    ImplementationType.failedConstraint(8, bl, contextStack, classDefinition.getName());
                }
            }
        }
        catch (ClassNotFound classNotFound) {
            ImplementationType.classNotFound(contextStack, classNotFound);
        }
        return bl2;
    }

    private boolean checkMethods(ClassDefinition classDefinition, Vector vector, ContextStack contextStack, boolean bl) {
        Object[] objectArray = new CompoundType.Method[vector.size()];
        vector.copyInto(objectArray);
        for (MemberDefinition memberDefinition = classDefinition.getFirstMember(); memberDefinition != null; memberDefinition = memberDefinition.getNextMember()) {
            if (!memberDefinition.isMethod() || memberDefinition.isConstructor() || memberDefinition.isInitializer() || this.updateExceptions(memberDefinition, (CompoundType.Method[])objectArray, contextStack, bl)) continue;
            return false;
        }
        return true;
    }

    private boolean updateExceptions(MemberDefinition memberDefinition, CompoundType.Method[] methodArray, ContextStack contextStack, boolean bl) {
        int n = methodArray.length;
        String string = memberDefinition.toString();
        for (int i = 0; i < n; ++i) {
            CompoundType.Method method = methodArray[i];
            MemberDefinition memberDefinition2 = method.getMemberDefinition();
            if (!string.equals(memberDefinition2.toString())) continue;
            try {
                ValueType[] valueTypeArray = this.getMethodExceptions(memberDefinition, bl, contextStack);
                method.setImplExceptions(valueTypeArray);
                continue;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public static ImplementationType forImplementation(ClassDefinition classDefinition, ContextStack contextStack, boolean bl) {
        ImplementationType implementationType;
        block8: {
            if (contextStack.anyErrors()) {
                return null;
            }
            boolean bl2 = false;
            implementationType = null;
            try {
                sun.tools.java.Type type = classDefinition.getType();
                Type type2 = ImplementationType.getType(type, contextStack);
                if (type2 != null) {
                    if (!(type2 instanceof ImplementationType)) {
                        return null;
                    }
                    return (ImplementationType)type2;
                }
                if (ImplementationType.couldBeImplementation(bl, contextStack, classDefinition)) {
                    ImplementationType implementationType2 = new ImplementationType(contextStack, classDefinition);
                    ImplementationType.putType(type, (Type)implementationType2, contextStack);
                    contextStack.push(implementationType2);
                    bl2 = true;
                    if (implementationType2.initialize(contextStack, bl)) {
                        contextStack.pop(true);
                        implementationType = implementationType2;
                    } else {
                        ImplementationType.removeType(type, contextStack);
                        contextStack.pop(false);
                    }
                }
            }
            catch (CompilerError compilerError) {
                if (!bl2) break block8;
                contextStack.pop(false);
            }
        }
        return implementationType;
    }
}

