/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.tools.jdi.AbstractLauncher;
import com.sun.tools.jdi.TransportService;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.IOException;
import java.util.Map;

class RawCommandLineLauncher
extends AbstractLauncher
implements LaunchingConnector {
    private static final String ARG_COMMAND = "command";
    private static final String ARG_ADDRESS = "address";
    private static final String ARG_QUOTE = "quote";

    public String description() {
        return this.getString("raw.description");
    }

    public String name() {
        return "com.sun.jdi.RawCommandLineLaunch";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine launch(Map map) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        String string = this.argument(ARG_COMMAND, map).value();
        String string2 = this.argument(ARG_ADDRESS, map).value();
        String string3 = this.argument(ARG_QUOTE, map).value();
        if (string3.length() > 1) {
            throw new IllegalConnectorArgumentsException("Invalid length", ARG_QUOTE);
        }
        string2 = this.transportService().startListening(string2);
        try {
            VirtualMachine virtualMachine = this.launch(this.tokenizeCommand(string, string3.charAt(0)), string2);
            return virtualMachine;
        }
        finally {
            this.transportService().stopListening(string2);
        }
    }

    RawCommandLineLauncher(VirtualMachineManagerService virtualMachineManagerService, TransportService transportService) {
        super(virtualMachineManagerService, transportService);
        this.addStringArgument(ARG_COMMAND, this.getString("raw.command.label"), this.getString("raw.command"), "", true);
        this.addStringArgument(ARG_ADDRESS, this.getString("raw.address.label"), this.getString("raw.address"), "", true);
        this.addStringArgument(ARG_QUOTE, this.getString("raw.quote.label"), this.getString("raw.quote"), "\"", true);
    }
}

