/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver.javaee.imp;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.souko105.flashserver.javaee.imp.RequestDispatcherImp;
import net.souko105.flashserver.javaee.imp.WebApp;
import net.souko105.flashserver.javaee.imp.WebAppManager;
import net.souko105.flashserver.log.FlashServerLog;
import net.souko105.flashserver.log.FlashServerLogFactory;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public class ServletContextImp
implements ServletContext {
    private static final FlashServerLog log;
    private String servletContextName;
    private String absoluteContextPath;
    private Map servletMap;
    private Map attributeMap = new HashMap();
    private Map initParamMap = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.souko105.flashserver.javaee.imp.ServletConfigImp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = FlashServerLogFactory.getLog(clazz);
    }

    ServletContextImp() {
    }

    public ServletContext getContext(String contextPath) {
        WebApp webapp = WebAppManager.getInstance().findWebApp(contextPath);
        if (webapp != null) {
            return webapp.getServletContext();
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        String absPath;
        File targetResource;
        if (path == null) {
            return null;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((targetResource = new File(absPath = String.valueOf(this.absoluteContextPath) + path)).exists()) {
            HashSet<String> set = new HashSet<String>();
            if (targetResource.isDirectory()) {
                File[] resources = targetResource.listFiles();
                if (resources != null) {
                    int i = 0;
                    while (i < resources.length) {
                        File resource = resources[i];
                        String name = String.valueOf(path) + "/" + resource.getName();
                        if (resource.isDirectory()) {
                            name = String.valueOf(name) + "/";
                        }
                        set.add(name);
                        ++i;
                    }
                }
            } else {
                String name = String.valueOf(path) + "/" + targetResource.getName();
                set.add(name);
            }
            if (!set.isEmpty()) {
                return set;
            }
        }
        return null;
    }

    public URL getResource(String resource) throws MalformedURLException {
        return new URL("file", null, this.createResourcePath(resource));
    }

    public InputStream getResourceAsStream(String resource) {
        try {
            return new FileInputStream(this.createResourcePath(resource));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Servlet getServlet(String name) throws ServletException {
        if (this.servletMap == null) {
            return null;
        }
        return (Servlet)this.servletMap.get(name);
    }

    public Enumeration getServlets() {
        if (this.servletMap == null) {
            return new IteratorEnumeration();
        }
        return new IteratorEnumeration(this.servletMap.values().iterator());
    }

    public Enumeration getServletNames() {
        if (this.servletMap == null) {
            return new IteratorEnumeration();
        }
        return new IteratorEnumeration(this.servletMap.keySet().iterator());
    }

    public String getRealPath(String resource) {
        return this.createResourcePath(resource);
    }

    public String getInitParameter(String key) {
        return (String)this.initParamMap.get(key);
    }

    public Enumeration getInitParameterNames() {
        return new IteratorEnumeration(this.initParamMap.keySet().iterator());
    }

    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    public Enumeration getAttributeNames() {
        return new IteratorEnumeration(this.attributeMap.keySet().iterator());
    }

    public void setAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
    }

    public void removeAttribute(String key) {
        this.attributeMap.remove(key);
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public void log(String logValue) {
        log.info(logValue);
    }

    public void log(Exception ex, String logValue) {
        log.info(logValue, ex);
    }

    public void log(String logValue, Throwable t) {
        log.info(logValue, t);
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getMimeType(String arg0) {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String requestURI) {
        try {
            WebApp webapp = WebAppManager.getInstance().findWebApp(this.servletContextName);
            Servlet servlet = webapp.findServlet(requestURI);
            RequestDispatcherImp rd = new RequestDispatcherImp(servlet, requestURI);
            return rd;
        }
        catch (ServletException e) {
            return null;
        }
    }

    public RequestDispatcher getNamedDispatcher(String arg0) {
        return null;
    }

    public String getServerInfo() {
        return null;
    }

    public void setServletMap(Map servletMap) {
        this.servletMap = servletMap;
    }

    public void addInitParameter(String paramName, String paramValue) {
        this.initParamMap.put(paramName, paramValue);
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public void setAbsoluteContextPath(String absoluteContextPath) {
        this.absoluteContextPath = absoluteContextPath;
    }

    private String createResourcePath(String resource) {
        if (resource.startsWith("/") || resource.startsWith("\\")) {
            String path = String.valueOf(this.absoluteContextPath) + resource;
            return path;
        }
        String path = String.valueOf(this.absoluteContextPath) + "/" + resource;
        return path;
    }
}

