/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver;

import java.io.IOException;
import java.io.InputStream;

public class HttpInputStream
extends InputStream {
    private InputStream isImp;
    private boolean skipFirstLF = false;
    private Object lock = new Object();

    public HttpInputStream(InputStream is) {
        this.isImp = is;
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    public String readLine(boolean ignoreLF) throws IOException {
        StringBuffer s = new StringBuffer();
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                int readChar;
                if ((readChar = this.read()) < 0) {
                    return s.length() > 0 ? s.toString() : null;
                }
                char c = (char)readChar;
                if (ignoreLF && c == '\n') continue;
                if (c == '\n' || c == '\r') {
                    if (c == '\r') {
                        this.skipFirstLF = true;
                    }
                    return s.toString();
                }
                s.append(c);
            }
        }
    }

    public int read() throws IOException {
        int c = this.isImp.read();
        if (this.skipFirstLF && c == 10) {
            this.skipFirstLF = false;
            c = this.isImp.read();
        }
        return c;
    }
}

