/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import net.souko105.flashserver.FlashServerConfig;
import net.souko105.flashserver.FlashServerException;
import net.souko105.flashserver.SocketProcessor;
import net.souko105.flashserver.SocketProcessorPool;
import net.souko105.flashserver.javaee.imp.WebApp;
import net.souko105.flashserver.javaee.imp.WebAppInitializeException;
import net.souko105.flashserver.javaee.imp.WebAppManager;
import net.souko105.flashserver.log.FlashServerLog;
import net.souko105.flashserver.log.FlashServerLogFactory;
import net.souko105.flashserver.util.IOUtils;

public class FlashServer {
    private static final FlashServerLog log;
    public static final int DEFAULT_PORT = 10100;
    public static final int DEFAULT_THREAD_NUM = 4;
    public static final String DEFAULT_SERVER_NAME = "FlashServer";
    public static final String FLASHSERVER_JSP_LIBPATH = "flashserver.jsp.libpath";
    private int maxThreadPoolNum = 4;
    private int port;
    private String serverName = "FlashServer";
    private SocketProcessorPool socketProcessorPool;
    private ServerThread serverThread;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.souko105.flashserver.FlashServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = FlashServerLogFactory.getLog(clazz);
    }

    public FlashServer() {
        this(DEFAULT_SERVER_NAME, 10100);
    }

    public FlashServer(int port) {
        this(DEFAULT_SERVER_NAME, port);
    }

    public FlashServer(String serverName, int port) {
        this.serverName = serverName;
        this.port = port;
    }

    public int getMaxThreadPoolNum() {
        return this.maxThreadPoolNum;
    }

    public void setMaxThreadPoolNum(int maxThreadPoolNum) {
        this.maxThreadPoolNum = maxThreadPoolNum;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void open() throws FlashServerException {
        ServerSocket initSocket = null;
        log.info("Try to bind socket port=" + this.port);
        try {
            initSocket = new ServerSocket(this.port, 1, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException ioe) {
            log.error("Bind fail port=" + this.port, ioe);
            throw new FlashServerException(ioe);
        }
        log.info("Bind success port=" + this.port);
        this.init();
        this.serverThread = new ServerThread(initSocket);
        this.serverThread.start();
        log.info("Server open success. Server start.");
    }

    public void close() throws FlashServerException {
        List webAppList = WebAppManager.getInstance().getWebAppList();
        Iterator itr = webAppList.iterator();
        while (itr.hasNext()) {
            List filterList;
            WebApp webapp = (WebApp)itr.next();
            List servletList = webapp.getServletList();
            if (servletList != null) {
                Iterator servletItr = servletList.iterator();
                while (servletItr.hasNext()) {
                    Servlet servlet = (Servlet)servletItr.next();
                    try {
                        servlet.destroy();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((filterList = webapp.getFilterList()) == null) continue;
            Iterator filterItr = filterList.iterator();
            while (filterItr.hasNext()) {
                Filter filter = (Filter)filterItr.next();
                try {
                    filter.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.serverThread.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void init() throws FlashServerException {
        this.initConfig();
        this.initWebApp();
        this.initSocketProcessor();
        this.initShutdown();
    }

    protected void initConfig() throws FlashServerException {
        String homeDir = System.getProperty("FS_HOME");
        if (homeDir == null) {
            homeDir = System.getProperty("user.dir");
        }
        if ((homeDir = IOUtils.replaceFileSeparator(homeDir)).endsWith("/")) {
            homeDir = homeDir.substring(0, homeDir.length() - 1);
        }
        log.info("FS_HOME=" + homeDir);
        FlashServerConfig.setConfig("FS_HOME", homeDir);
    }

    protected void initWebApp() throws FlashServerException {
        try {
            log.info("WebApp init start.");
            WebAppManager.init();
            log.info("WebApp init success.");
        }
        catch (WebAppInitializeException e) {
            log.error("WebApp init fail.", e);
            throw new FlashServerException(e);
        }
    }

    protected void initSocketProcessor() throws FlashServerException {
        this.socketProcessorPool = new SocketProcessorPool(this.maxThreadPoolNum);
    }

    protected void initShutdown() throws FlashServerException {
        final FlashServer fs = this;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    fs.close();
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
        });
    }

    void returnProcessor(SocketProcessor processor) {
        this.socketProcessorPool.returnProcessor(processor);
    }

    class ServerThread
    extends Thread {
        private boolean shutdown = false;
        private ServerSocket serverSocket;

        ServerThread(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        public void run() {
            while (!this.shutdown) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                }
                catch (AccessControlException ace) {
                    log.warn("Socket accept security exception " + ace.getMessage(), ace);
                    continue;
                }
                catch (IOException ioe) {
                    if (this.shutdown) break;
                    log.error("Socket accept error.", ioe);
                    continue;
                }
                SocketProcessor con = FlashServer.this.socketProcessorPool.getProcessor();
                con.process(socket, FlashServer.this);
            }
        }

        public void close() throws IOException {
            this.shutdown = true;
            this.serverSocket.close();
            this.serverSocket = null;
        }
    }
}

