package net.souko105.flashserver.util;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * @author AKatayama
 */
public class WrapRuntimeException extends RuntimeException
{
	private static final long serialVersionUID = 1L;
	
	private Throwable cause;

	private String message;

	/**
	 * @param cause
	 */
	public WrapRuntimeException(String message) {
		this(message, null);
	}

	/**
	 * @param cause
	 */
	public WrapRuntimeException(Throwable cause) {
		this(null, cause);
	}

	/**
	 * @param message
	 * @param cause
	 */
	public WrapRuntimeException(String aMessage, Throwable aCause) {
		this.cause = aCause;
		this.message = aMessage;
		if (aMessage == null && aCause != null)
			this.message = aCause.getMessage();
	}

	/**
	 * @see java.lang.Throwable#getCause()
	 */
	public Throwable getCause() {
		if (cause != null)
			return cause.getCause();
		else
			return super.getCause();
	}

	/**
	 * @see java.lang.Throwable#getMessage()
	 */
	public String getMessage() {
		if (message != null)
			return message;
		else
			return super.getMessage();
	}

	/**
	 * @see java.lang.Throwable#printStackTrace()
	 */
	public void printStackTrace() {
		if (cause != null)
			cause.printStackTrace();
		else
			super.printStackTrace();
	}

	/**
	 * @see java.lang.Throwable#printStackTrace(java.io.PrintStream)
	 */
	public void printStackTrace(PrintStream s) {
		if (cause != null)
			cause.printStackTrace(s);
		else
			super.printStackTrace(s);
	}

	/**
	 * @see java.lang.Throwable#printStackTrace(java.io.PrintWriter)
	 */
	public void printStackTrace(PrintWriter s) {
		if (cause != null)
			cause.printStackTrace(s);
		else
			super.printStackTrace(s);

	}

}
