package net.souko105.flashserver.javaee.webxml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

/**
 * web.xmlǂݍ݁AWebXml̃CX^X𐶐܂B
 * @author AKatayama
 */
public class WebXmlFactory
{
	//lbg[NڑȂꍇAPUBLICDTDǂނƃG[ƂȂ邽߁A
	//[JDTDǂނ悤ɓւsB
    protected static String registrations[] = {
        "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN",
        "/net/souko105/flashserver/resource/web-app_2_2.dtd",
        "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN",
        "/net/souko105/flashserver/resource/web-app_2_3.dtd"
    };
    
    public static WebXml createWebXml(InputStream is) throws IOException, SAXException
    {
        Digester digester = new Digester();
        digester.setNamespaceAware(true);
        digester.setValidating(false);
        digester.setUseContextClassLoader(true);

        for (int i = 0; i < registrations.length; i += 2) {
            URL url = WebXml.class.getResource(registrations[i+1]);
            if (url != null) {
                digester.register(registrations[i], url.toString());
            }
        }
        
        WebXml webxml = new WebXml();
        digester.push(webxml);
        
        digester.addObjectCreate("web-app",WebAppTag.class);
        digester.addSetNext("web-app","setWebApp");

        digester.addObjectCreate("web-app/filter",FilterTag.class);
        digester.addSetNext("web-app/filter","addFilter");
        digester.addCallMethod("web-app/filter/filter-name","setFilterName",0);
        digester.addCallMethod("web-app/filter/filter-class","setFilterClass",0);
        
        digester.addCallMethod("web-app/filter/init-param","addInitParam", 2);
		digester.addCallParam("web-app/filter/init-param/param-name",0);
		digester.addCallParam("web-app/filter/init-param/param-value",1);

        digester.addObjectCreate("web-app/filter-mapping",FilterMappingTag.class);
        digester.addSetNext("web-app/filter-mapping","addFilterMapping");
		digester.addCallMethod("web-app/filter-mapping/filter-name","setFilterName",0);
		digester.addCallMethod("web-app/filter-mapping/url-pattern","addUrlPattern", 0);
		digester.addCallMethod("web-app/filter-mapping/servlet-name","addServletName", 0);

        
        digester.addObjectCreate("web-app/servlet",ServletTag.class);
        digester.addSetNext("web-app/servlet","addServlet");
        digester.addCallMethod("web-app/servlet/servlet-name","setServletName",0);
        digester.addCallMethod("web-app/servlet/display-name","setDisplayName",0);
        digester.addCallMethod("web-app/servlet/servlet-class","setServletClass",0);
        
        digester.addCallMethod("web-app/servlet/init-param","addInitParam", 2);
		digester.addCallParam("web-app/servlet/init-param/param-name",0);
		digester.addCallParam("web-app/servlet/init-param/param-value",1);

        digester.addObjectCreate("web-app/servlet-mapping",ServletMappingTag.class);
        digester.addSetNext("web-app/servlet-mapping","addServletMapping");
		digester.addCallMethod("web-app/servlet-mapping/servlet-name","setServletName",0);
		digester.addCallMethod("web-app/servlet-mapping/url-pattern","addUrlPattern", 0);
		
		digester.setValidating(false);
        digester.parse(is);
        
        return webxml;
    }
}
