package net.souko105.flashserver;

import java.util.LinkedList;
import java.util.List;

import net.souko105.flashserver.log.FlashServerLog;
import net.souko105.flashserver.log.FlashServerLogFactory;

/**
 * SocketProcessor̃v[ONX
 * őv[܂SocketProcessorv[Aėp܂B
 * @author AKatayama
 */
class SocketProcessorPool
{
	private static final FlashServerLog log = FlashServerLogFactory.getLog(SocketProcessor.class);
			
    private int maxThreadPoolNum;
    private List threadList = new LinkedList();

    SocketProcessorPool(int maxThreadPoolNum)
    {
        this.maxThreadPoolNum = maxThreadPoolNum;
        init();
    }

	private void init()
	{
		for (int i = 0; i < maxThreadPoolNum; ++i) {
			SocketProcessor processor = new SocketProcessor("socketprocessor:init"+i);
			processor.start();
			threadList.add(processor);
		}
	}
	
	SocketProcessor getProcessor()
	{		
	    synchronized(threadList){
	        if(threadList.isEmpty()){
				SocketProcessor processor = new SocketProcessor("socketprocessor:"+System.currentTimeMillis());
				processor.start();
				log.debug("crate processor " + processor.getName());
				return processor;
	        }else{
	        	SocketProcessor processor = (SocketProcessor)threadList.remove(0);
	        	log.debug("get processor " + processor.getName());
	            return processor;
	        }
	    }
	}
	void returnProcessor(SocketProcessor processor) {
		
	    synchronized(threadList){
			if (threadList.size() < maxThreadPoolNum)
			{
				log.debug("return processor" +processor.getName());
				threadList.add(processor);
			}
			else
			{
				log.debug("stop processor "+processor.getName());
				processor.stopProcessor();
			}
	    }
	}
}
