/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver.javaee.imp;

import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;

public class WebAppClassLoader
extends URLClassLoader {
    private ClassLoader parentClassLoader;

    public WebAppClassLoader(URL[] urls) {
        super(urls);
    }

    public WebAppClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.parentClassLoader = parent;
    }

    public WebAppClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.parentClassLoader = parent;
    }

    public void setParentClassLoader(ClassLoader loader) {
        this.parentClassLoader = loader;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        boolean preDelegateLoad = this.preDelegateLoad(name);
        if (preDelegateLoad) {
            try {
                c = this.parentClassLoader.loadClass(name);
                if (c != null) {
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            c = this.findClass(name);
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        c = this.parentClassLoader.loadClass(name);
        if (c != null) {
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        throw new ClassNotFoundException("Class not found.classname=" + name);
    }

    private boolean preDelegateLoad(String name) {
        if (name.startsWith("java.")) {
            return true;
        }
        if (name.startsWith("javax.")) {
            return true;
        }
        if (name.startsWith("org.apache.commons.logging")) {
            return true;
        }
        return name.startsWith("org.xml");
    }
}

