/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassDocCatalog {
    private Set packageSet;
    private Map allClasses;
    private Map ordinaryClasses;
    private Map exceptions;
    private Map errors;
    private Map interfaces;

    public ClassDocCatalog() {
        this.init();
    }

    private void init() {
        this.allClasses = new HashMap();
        this.ordinaryClasses = new HashMap();
        this.exceptions = new HashMap();
        this.errors = new HashMap();
        this.interfaces = new HashMap();
        this.packageSet = new HashSet();
    }

    public void addClassDoc(ClassDoc classDoc) {
        if (classDoc == null) {
            return;
        }
        this.addClass(classDoc, this.allClasses);
        if (classDoc.isOrdinaryClass()) {
            this.addClass(classDoc, this.ordinaryClasses);
        }
        if (classDoc.isException()) {
            this.addClass(classDoc, this.exceptions);
        }
        if (classDoc.isError()) {
            this.addClass(classDoc, this.errors);
        }
        if (classDoc.isInterface()) {
            this.addClass(classDoc, this.interfaces);
        }
    }

    public ClassDocCatalog(ClassDoc[] classDocArray) {
        this.init();
        for (int i = 0; i < classDocArray.length; ++i) {
            this.addClassDoc(classDocArray[i]);
        }
    }

    public String[] packageNames() {
        return this.packageSet.toArray(new String[0]);
    }

    public ClassDoc[] allClasses(String string) {
        return this.getArray(this.allClasses, string);
    }

    public ClassDoc[] errors(String string) {
        return this.getArray(this.errors, string);
    }

    public ClassDoc[] exceptions(String string) {
        return this.getArray(this.exceptions, string);
    }

    public ClassDoc[] interfaces(String string) {
        return this.getArray(this.interfaces, string);
    }

    public ClassDoc[] ordinaryClasses(String string) {
        return this.getArray(this.ordinaryClasses, string);
    }

    private void addClass(ClassDoc classDoc, Map map) {
        PackageDoc packageDoc = classDoc.containingPackage();
        if (packageDoc.isIncluded()) {
            return;
        }
        String string = packageDoc.name();
        HashSet<ClassDoc> hashSet = (HashSet<ClassDoc>)map.get(string);
        if (hashSet == null) {
            this.packageSet.add(string);
            hashSet = new HashSet<ClassDoc>();
        }
        hashSet.add(classDoc);
        map.put(string, hashSet);
    }

    private ClassDoc[] getArray(Map map, String string) {
        Set set = (Set)map.get(string);
        if (set == null) {
            return new ClassDoc[0];
        }
        return set.toArray(new ClassDoc[0]);
    }
}

