package net.souko105.flashserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Calendar;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

import net.souko105.flashserver.javaee.imp.FilterChainImp;
import net.souko105.flashserver.javaee.imp.HttpServletRequestImp;
import net.souko105.flashserver.javaee.imp.HttpServletResponseImp;
import net.souko105.flashserver.javaee.imp.WebApp;
import net.souko105.flashserver.javaee.imp.WebAppClassLoader;
import net.souko105.flashserver.javaee.imp.WebAppManager;
import net.souko105.flashserver.log.FlashServerLog;
import net.souko105.flashserver.log.FlashServerLogFactory;
import net.souko105.flashserver.util.IOUtils;
import net.souko105.flashserver.util.PathUtils;


/**
 * \Pbgڑɑ΂āAs܂B
 * NGXǵT[ubgĂяoX|X̏
 * s܂B
 * @author AKatayama
 */
public class SocketProcessor extends Thread
{
    private static final FlashServerLog log = FlashServerLogFactory.getLog(SocketProcessor.class);
    
    private static final int SOCKET_TIMEOUT = 120*1000;
    private static final int KEEPALIVE_TIMEOUT = 15*1000;
    private Socket socket;
    private FlashServer server;
    private boolean stop ;
    	
    public SocketProcessor(String name)
    {
        super(name);
    }

    public void process(Socket socket, FlashServer server)
    {
        synchronized (this)
        {
            this.socket = socket;
            this.server = server;
        	
            notify();
        }
    }

    public void run()
    {
        while(!stop)
        {
            while(socket == null)
            {
                try
                {
                    synchronized (this)
                    {
                        wait();
                    }
                }
                catch (InterruptedException e)
                {
                	log.error("SocketProcessor interrupetd",e);
                    return;
                }
                if(stop)
                	return ;
            }

            InputStream is = null;
            OutputStream os = null;
            boolean keepAlive = true;
            boolean firstRequest = true;//KeepAliveڑ̍ŏ̃NGXgǂ
            try
            {
            	socket.setTcpNoDelay(true);
            	socket.setSoTimeout(SOCKET_TIMEOUT);
                is = socket.getInputStream();
                os = socket.getOutputStream();
                while(keepAlive)
                {
                	keepAlive = processSocket(is,os,firstRequest);
                	firstRequest = false;
                }
            }
            catch(SocketTimeoutException e)
            {
            	if(firstRequest)
            		log.error(e.getMessage(),e);
            	//ignore
            }
            catch (Throwable t)
            {
                log.error(t.getMessage(), t);
            }
            finally
            {
                try
                {
	                is.close();
	                os.close();
	                is = null;
	                os = null;
                }
                catch(IOException ioe){}
                try
                {
	                socket.close();                	
                }
                catch(IOException ioe){}
            }
            socket = null;
            FlashServer tmpServer = this.server;
            server = null;
            tmpServer.returnProcessor(this);
        }
    }

    protected boolean processSocket(InputStream is,OutputStream os,boolean firstRequest) throws Throwable
    {
		HttpRequestHeader header = null;
		HttpRequestBody body = null;
    	try
    	{
    		if(!firstRequest)
    			socket.setSoTimeout(KEEPALIVE_TIMEOUT);
    		
    		log.debug("read start processor="+this.getName());
    		
	    	HttpInputStream reader = new HttpInputStream(is);
	        header = readHeader(reader,firstRequest);
	        if(header == null)
	        	return false;//empty request;
	
	        log.debug("HEADER" + header.toString());
	        body = readBody(header, reader);
    	}
    	catch(SocketException e)
    	{
			throw new SocketTimeoutException();
    	}
    	finally
    	{
    		if(socket.isClosed())
    			return false;
    		else
    			socket.setSoTimeout(SOCKET_TIMEOUT);
    	}

        String requestURI = header.getRequestURI();
        String contextPath = PathUtils.getContextPath(requestURI);
        String resourcePath = PathUtils.getResourcePath(requestURI);        

        //request
        HttpServletRequestImp request = new HttpServletRequestImp();
        //TODO create servlet path
        String servletPath = resourcePath;
        request.setHeader(header);
        request.setBody(body);
        request.setServletPath(servletPath);
        //response
        HttpServletResponseImp response = new HttpServletResponseImp();
        
        WebApp webapp = WebAppManager.getInstance().findWebApp(contextPath);
        Servlet servlet = webapp.findServlet(resourcePath);
        if(webapp == null || servlet == null)
        {
        	response.setStatus(HttpServletResponse.SC_NOT_FOUND);
        	setDefaultResponseHeader(request,response);
        	processOutputDataWrite(response,os);
        	return header.isKeepAlive();
        }
        request.setServlet(servlet);
        
        //class loader
        WebAppClassLoader webClassLoader = webapp.getWebAppClassLoader();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        webClassLoader.setParentClassLoader(oldLoader);
        Thread.currentThread().setContextClassLoader(webClassLoader);
        
        //service
        try
		{
        	List filterList = webapp.findFilters(resourcePath,servlet.getServletConfig().getServletName());
        	if(filterList.size() > 0)
        	{
        		Filter[] filters = (Filter[])filterList.toArray(new Filter[]{});
        		FilterChainImp filterChain = new FilterChainImp(filters,servlet);
        		filterChain.doFilter(request,response);
        	}
        	else
        		servlet.service(request, response);
		}
        catch(ServletException se)
        {
        	log.error(se.getMessage(), se);
        	response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
        }
        catch(IOException ioe)
        {
        	log.error(ioe.getMessage(), ioe);
        	response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
        }
        finally
		{
        	Thread.currentThread().setContextClassLoader(oldLoader);
		}

        //common header
        setDefaultResponseHeader(request,response);
        processOutputDataWrite(response,os);
        
        return header.isKeepAlive();
    }
    private void setDefaultResponseHeader(HttpServletRequestImp request,HttpServletResponseImp response) throws IOException
    {
        response.setHeader(HttpHeaderConst.DATE, IOUtils.HEADER_DATE_FORMAT.format(Calendar.getInstance().getTime()));
        response.setHeader(HttpHeaderConst.SERVER, server.getServerName());
        String sessionId = request.getRequestedSessionId();
        if (sessionId != null)
        {
            Cookie sessionCookie = new Cookie(HttpHeaderConst.SESSIONID_KEY, sessionId);
            response.addCookie(sessionCookie);
        }
        if(request.getHeader().isKeepAlive())
        {
        	response.addHeader(HttpHeaderConst.KEEPALIVE,"timeout="+(int)KEEPALIVE_TIMEOUT/1000 + ", max=100");
        	response.addHeader(HttpHeaderConst.CONNECTION,HttpHeaderConst.KEEPALIVE);
        }
        else
        	response.addHeader(HttpHeaderConst.CONNECTION,HttpHeaderConst.CLOSE);
        
        //Content-Length
        HttpResponseHeader resHeader = response.getResponseHeader();
        if(resHeader.getHeader(HttpHeaderConst.TRANSFERENCODING) == null && resHeader.getHeader(HttpHeaderConst.CONTENTLENGTH) == null)
        	response.setHeader(HttpHeaderConst.CONTENTLENGTH,String.valueOf(response.getBodyData().length));
    }
    private void processOutputDataWrite(HttpServletResponseImp response,OutputStream os) throws IOException
    {
        HttpResponseHeader resHeader = response.getResponseHeader();
        byte[] headerData = resHeader.getHeaderString().getBytes();
        byte[] bodyData = response.getBodyData();
        os.write(headerData);
        os.write(HttpHeaderConst.CRLF_STRING.getBytes());//Separator
        os.write(bodyData);
    	os.flush();
    	System.out.println("RES=" + new String(headerData));
    }
    
    void stopProcessor()
    {
    	synchronized (this) {
    		stop = true;
    		notifyAll();
		}
    }

    private HttpRequestHeader readHeader(HttpInputStream reader,boolean firstRequest)
            throws IOException
    {
        StringBuffer httpHeaderBuf = null;
        String line = null;
        boolean skipFirst = !firstRequest;//KeepAlive2xڈȍ~͍ŏ̋󔒃Cǂݔ΂
        boolean firstRead = true;
        
        while ((line = reader.readLine()) != null)
        {
        	line = line.trim();
        	
        	if(firstRead)
        	{
        		firstRead = false;
        		if(skipFirst && line.length() <= 0)
        			continue;
        	}
        	
            //󔒍sŏI
            if (line.length() <= 0)
                break;

            if(httpHeaderBuf == null)
                httpHeaderBuf = new StringBuffer();
            
            httpHeaderBuf.append(line);
            httpHeaderBuf.append(HttpHeaderConst.CRLF);
        }

        if(httpHeaderBuf == null)
            return null;
        
        HttpRequestHeader header = new HttpRequestHeader(new String(httpHeaderBuf));
        return header;
    }

    private HttpRequestBody readBody(HttpRequestHeader header,
            HttpInputStream is) throws IOException
    {
        String contentLengthHeader = header
                .getHeader(HttpHeaderConst.CONTENTLENGTH);
        byte[] b = null;
        if (contentLengthHeader != null)
        {
            int contentLength = Integer.parseInt(contentLengthHeader);
            long trueContentLength = Long.parseLong(contentLengthHeader);
            if (trueContentLength > contentLength)
                throw new IllegalArgumentException(
                        "ContentLenght too long.Max size = "
                                + Integer.MAX_VALUE);

            b = new byte[contentLength];
            is.read(b, 0, b.length);
        }
        HttpRequestBody body = new HttpRequestBody(header, b);
        return body;
    }
}
