package net.souko105.flashserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.List;

import javax.servlet.Servlet;

import net.souko105.flashserver.javaee.imp.WebApp;
import net.souko105.flashserver.javaee.imp.WebAppInitializeException;
import net.souko105.flashserver.javaee.imp.WebAppManager;
import net.souko105.flashserver.log.FlashServerLog;
import net.souko105.flashserver.log.FlashServerLogFactory;
import net.souko105.flashserver.util.IOUtils;

/**
 * [J̃T[o[NX
 * open\bhŋN܂B
 * @author AKatayama
 */
public class FlashServer
{
    private static final FlashServerLog log = FlashServerLogFactory.getLog(FlashServer.class);
    
    public static final int DEFAULT_PORT = 10100;
    public static final int DEFAULT_THREAD_NUM = 4;
    public static final String DEFAULT_SERVER_NAME = "FlashServer";
    //JSPRpCp̃CupX
    //FlashServerĂяoOSystem.setPropertyŃZbg
    public static final String FLASHSERVER_JSP_LIBPATH = "flashserver.jsp.libpath";
    
    private int maxThreadPoolNum = DEFAULT_THREAD_NUM;
    private int port;
    private String serverName = "FlashServer";
    
    private SocketProcessorPool socketProcessorPool;
    private ServerThread serverThread;
   
    public FlashServer()
    {
        this(DEFAULT_SERVER_NAME,DEFAULT_PORT);
    }
    public FlashServer(int port)
    {
    	this(DEFAULT_SERVER_NAME,port);
    }
    public FlashServer(String serverName,int port)
    {
    	this.serverName = serverName;
    	this.port = port;
    }
    /**
     * őv[XbhԂ܂B
     * @return
     */
    public int getMaxThreadPoolNum()
    {
        return maxThreadPoolNum;
    }
    /**
     * őXbhv[ݒ肵܂B
     * openOɃZbgĂB
     * @param maxThreadPoolNum
     */
    public void setMaxThreadPoolNum(int maxThreadPoolNum)
    {
        this.maxThreadPoolNum = maxThreadPoolNum;
    }
    /**
     * Listen|[gԍԂ܂B
     * @return
     */
    public int getPort()
    {
        return port;
    }
    /**
     * Listen|[gԍݒ肵܂B
     * openOɃZbgĂB
     * @param port
     */
    public void setPort(int port)
    {
        this.port = port;
    }
    /**
     * T[oԂ܂B
     * @return
     */
    public String getServerName()
    {
        return serverName;
    }
    /**
     * T[oݒ肵܂BX|XServerwb_[
     * ̖O܂B
     * @param serverName
     */
    public void setServerName(String serverName)
    {
        this.serverName = serverName;
    }
    /**
     * \PbgI[vAT[oJn܂B
     * @throws FlashServerException
     */
    public void open() throws FlashServerException
    {
        ServerSocket initSocket = null;
        
        log.info("Try to bind socket port=" + port);
        try
        {
            initSocket = new ServerSocket(port, 1, InetAddress.getByName("127.0.0.1"));
        }
        catch(IOException ioe)
        {
            log.error("Bind fail port="+port,ioe);
            throw new FlashServerException(ioe);
        }
        log.info("Bind success port=" + port);
        
        init();

        this.serverThread = new ServerThread(initSocket);
        
        serverThread.start();
        
        log.info("Server open success. Server start.");
    }
    /**
     * \PbgAT[oI܂B
     * @throws FlashServerException
     */
    public void close() throws FlashServerException
    {
    	//destroy servlet
    	List webAppList = WebAppManager.getInstance().getWebAppList();
    	for(Iterator itr = webAppList.iterator();itr.hasNext();)
    	{
    		WebApp webapp = (WebApp)itr.next();
    		List servletList = webapp.getServletList();
    		if(servletList != null)
    		{
    			for(Iterator servletItr = servletList.iterator();servletItr.hasNext();)
    			{
    				Servlet servlet = (Servlet)servletItr.next();
    				try
    				{
    					servlet.destroy();
    				}
    				catch(Exception e)
    				{
    					e.printStackTrace();
    				}
    			}	
    		}
    	}
    	//close socket
    	try
    	{
    		serverThread.close();
    	}
    	catch(IOException ioe)
    	{
    		ioe.printStackTrace();
    	}    	
    }
    protected void init() throws FlashServerException
    {
        initConfig();
        initWebApp();
        initSocketProcessor();
        initShutdown();
    }
    /**
     * T[oݒǂݍ݁A܂B  
     * @throws FlashServerException
     */
    protected void initConfig() throws FlashServerException
    {        
        //WebApp̃fBNg
        String homeDir = System.getProperty(FlashServerConst.KEY_FS_HOME);
        if(homeDir == null)
            homeDir = System.getProperty("user.dir");
        homeDir = IOUtils.replaceFileSeparator(homeDir);
        if(homeDir.endsWith("/"))
            homeDir = homeDir.substring(0,homeDir.length()-1);
        log.info("FS_HOME="+homeDir);
        
        FlashServerConfig.setConfig(FlashServerConst.KEY_FS_HOME,homeDir);
    }
    /**
     * WebAvP[V܂B
     * @throws FlashServerException
     */
    protected void initWebApp() throws FlashServerException
    {
        try
        {
        	log.info("WebApp init start.");
            WebAppManager.init();
            log.info("WebApp init success.");
        }
        catch(WebAppInitializeException e)
        {
        	log.error("WebApp init fail.",e);
            throw new FlashServerException(e);
        }
    }
    protected void initSocketProcessor() throws FlashServerException
    {
        socketProcessorPool = new SocketProcessorPool(this.maxThreadPoolNum);
    }
    protected void initShutdown() throws FlashServerException
    {
    	final FlashServer fs = this;
    	Runtime.getRuntime().addShutdownHook(new Thread(){
    		public void run() {
    			try{
    				fs.close();
    			}catch(Exception e){
    				log.error(e);
    			}
    		};
    	});
    }
    void returnProcessor(SocketProcessor processor)
    {
        socketProcessorPool.returnProcessor(processor);
    }
    
    class ServerThread extends Thread
    {
    	private boolean shutdown = false;
    	private ServerSocket serverSocket;
    	
    	ServerThread(ServerSocket serverSocket){
    		this.serverSocket = serverSocket;    		
    	}
        public void run()
        {
	        while(!shutdown)
	        {
	            Socket socket = null;
	            try
	            {
	               socket = serverSocket.accept();
	            }
	            catch(AccessControlException ace)
	            {
	                log.warn("Socket accept security exception " + ace.getMessage(),ace);
	                continue;
	            }
	            catch(IOException ioe)
	            {
	            	if(shutdown)
	            		break;
	            	
	                log.error("Socket accept error.",ioe);
	                continue;
	            }
	            SocketProcessor con = socketProcessorPool.getProcessor();
	            con.process(socket,FlashServer.this);
	        }
        }
        public void close() throws IOException
        {
        	shutdown = true;
        	serverSocket.close();
        	serverSocket = null;
        }
    }
}
