/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver.javaee.imp;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.souko105.flashserver.FlashServerConfig;
import net.souko105.flashserver.javaee.imp.WebApp;
import net.souko105.flashserver.javaee.imp.WebAppClassLoader;
import net.souko105.flashserver.javaee.imp.WebAppInitializeException;
import net.souko105.flashserver.javaee.webxml.ServletMappingTag;
import net.souko105.flashserver.javaee.webxml.ServletTag;
import net.souko105.flashserver.javaee.webxml.WebAppTag;
import net.souko105.flashserver.javaee.webxml.WebXml;
import net.souko105.flashserver.javaee.webxml.WebXmlFactory;
import net.souko105.flashserver.log.FlashServerLog;
import net.souko105.flashserver.log.FlashServerLogFactory;
import net.souko105.flashserver.util.IOUtils;
import net.souko105.flashserver.util.PathUtils;

public class WebAppManager {
    private static FlashServerLog log;
    private static WebAppManager manager;
    private String webappDirPath;
    private List contextPathList = new ArrayList();
    private List webAppList = new ArrayList();
    private static boolean init;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.souko105.flashserver.javaee.imp.WebAppManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = FlashServerLogFactory.getLog(clazz);
        init = false;
    }

    private WebAppManager() {
    }

    public static synchronized void init() throws WebAppInitializeException {
        if (!init) {
            try {
                manager = new WebAppManager();
                manager.initManager();
            }
            catch (Exception e) {
                throw new WebAppInitializeException(e);
            }
        }
    }

    private void initManager() throws Exception {
        String homeDirPath = FlashServerConfig.getConfig("FS_HOME");
        this.webappDirPath = String.valueOf(homeDirPath) + "/webapps";
        File webappDir = new File(this.webappDirPath);
        if (!webappDir.exists()) {
            return;
        }
        this.prepareWebAppDir();
        this.initWebAppContext();
    }

    private void prepareWebAppDir() throws IOException {
        int i;
        File webappDir = new File(this.webappDirPath);
        File[] dirs = webappDir.listFiles(new DirFileFilter());
        File[] warFiles = webappDir.listFiles(new WarFileFilter());
        if (warFiles != null) {
            i = 0;
            while (i < warFiles.length) {
                if (!WebAppManager.isExtracted(warFiles[i], dirs)) {
                    WebAppManager.extractWar(warFiles[i], webappDir);
                }
                ++i;
            }
        }
        this.contextPathList = new ArrayList();
        dirs = webappDir.listFiles(new DirFileFilter());
        if (dirs != null) {
            i = 0;
            while (i < dirs.length) {
                this.contextPathList.add("/" + dirs[i].getName());
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initWebAppContext() throws Exception {
        Iterator itr = this.contextPathList.iterator();
        while (true) {
            WebXml webxml;
            String contextPath;
            block6: {
                if (!itr.hasNext()) {
                    return;
                }
                contextPath = (String)itr.next();
                File webxmlFile = new File(String.valueOf(this.webappDirPath) + contextPath + "/WEB-INF/web.xml");
                webxml = null;
                if (webxmlFile.exists()) {
                    Object var6_6;
                    FileInputStream fin = null;
                    try {
                        fin = new FileInputStream(webxmlFile);
                        webxml = WebXmlFactory.createWebXml(fin);
                    }
                    catch (Throwable throwable) {
                        var6_6 = null;
                        fin.close();
                        fin = null;
                        throw throwable;
                    }
                    {
                        var6_6 = null;
                        fin.close();
                        fin = null;
                        break block6;
                    }
                }
                webxml = new WebXml();
                webxml.setWebApp(new WebAppTag());
            }
            this.setDefaultServlet(webxml, contextPath);
            String absoluteContextPath = String.valueOf(this.webappDirPath) + contextPath;
            WebAppClassLoader webAppClassLoader = this.createWebAppClassLoader(absoluteContextPath);
            webAppClassLoader.setParentClassLoader(Thread.currentThread().getContextClassLoader());
            WebApp webapp = new WebApp(webxml, absoluteContextPath, contextPath, webAppClassLoader);
            this.webAppList.add(webapp);
        }
    }

    private WebAppClassLoader createWebAppClassLoader(String absoluteContextPath) throws MalformedURLException {
        URL[] urls;
        String webinfLibDir;
        URL[] libs;
        ArrayList<URL> urlList = new ArrayList<URL>();
        File classesDir = new File(String.valueOf(absoluteContextPath) + "/WEB-INF/classes");
        if (classesDir.exists()) {
            String dirPath = classesDir.getAbsolutePath();
            dirPath = String.valueOf(IOUtils.replaceFileSeparator(dirPath)) + "/";
            urlList.add(new URL("file:///" + dirPath));
        }
        if ((libs = PathUtils.createArchiveClassPaths(webinfLibDir = String.valueOf(absoluteContextPath) + "/WEB-INF/lib")) != null) {
            int i = 0;
            while (i < libs.length) {
                urlList.add(libs[i]);
                ++i;
            }
        }
        if ((urls = urlList.toArray(new URL[0])) != null) {
            return new WebAppClassLoader(urls);
        }
        return null;
    }

    private void setDefaultServlet(WebXml webxml, String contextPath) {
        String jspServletName = "jsp";
        ServletTag jspServlet = new ServletTag();
        jspServlet.setLoadOnStartup(0);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.jasper.servlet.JspServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        jspServlet.setServletClass(clazz.getName());
        jspServlet.setServletName("jsp");
        jspServlet.addInitParam("logVerbosityLevel", "WARNING");
        jspServlet.addInitParam("validating", "false");
        jspServlet.addInitParam("fork", "false");
        jspServlet.addInitParam("scratchdir", "false");
        String jspWorkDirPath = String.valueOf(System.getProperty("java.io.tmpdir")) + "/flashserverjsp" + contextPath;
        File jspWorkDir = new File(jspWorkDirPath);
        jspWorkDir.mkdirs();
        jspServlet.addInitParam("scratchdir", jspWorkDirPath);
        String jspClassPath = System.getProperty("flashserver.jsp.libpath");
        if (jspClassPath != null) {
            jspServlet.addInitParam("classpath", jspClassPath);
        }
        ServletMappingTag jspMapping = new ServletMappingTag();
        jspMapping.setServletName("jsp");
        jspMapping.addUrlPattern("*.jsp");
        webxml.getWebApp().addServlet(jspServlet);
        webxml.getWebApp().addServletMapping(jspMapping);
        String servletName = "file";
        ServletTag fileServlet = new ServletTag();
        fileServlet.setLoadOnStartup(0);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("net.souko105.flashserver.javaee.servlet.FileSavingServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        fileServlet.setServletClass(clazz2.getName());
        fileServlet.setServletName("file");
        fileServlet.addInitParam("appRootPath", this.webappDirPath);
        ServletMappingTag mapping = new ServletMappingTag();
        mapping.setServletName("file");
        mapping.addUrlPattern("/*");
        webxml.getWebApp().addServlet(fileServlet);
        webxml.getWebApp().addServletMapping(mapping);
    }

    private static boolean isExtracted(File warFile, File[] dirs) {
        boolean extracted = false;
        if (dirs != null) {
            String archiveName = WebAppManager.getArchiveName(warFile.getName());
            int i = 0;
            while (i < dirs.length) {
                if (archiveName.equals(dirs[i].getName())) {
                    extracted = true;
                }
                ++i;
            }
        }
        return extracted;
    }

    private static String getArchiveName(String warFileName) {
        return warFileName.substring(0, warFileName.length() - ".war".length());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extractWar(File warFile, File directory) throws IOException {
        log.info("extract war start. filename=" + warFile.getName());
        try {
            JarInputStream jin = new JarInputStream(new FileInputStream(warFile));
            JarEntry entry = null;
            File webAppDir = new File(directory, WebAppManager.getArchiveName(warFile.getName()));
            webAppDir.mkdirs();
            while (true) {
                Object var8_9;
                if ((entry = jin.getNextJarEntry()) == null) {
                    log.info("extract success.");
                    return;
                }
                File file = new File(webAppDir, entry.getName());
                if (entry.isDirectory()) {
                    if (file.exists()) continue;
                    file.mkdirs();
                    continue;
                }
                File dir = new File(file.getParent());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                FileOutputStream fout = null;
                try {
                    fout = new FileOutputStream(file);
                    IOUtils.copyStream(jin, fout);
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    fout.flush();
                    fout.close();
                    fout = null;
                    throw throwable;
                }
                {
                    var8_9 = null;
                }
                fout.flush();
                fout.close();
                fout = null;
                if (entry.getTime() < 0L) continue;
                file.setLastModified(entry.getTime());
            }
        }
        catch (IOException ioe) {
            log.info("extract fail.");
            throw ioe;
        }
    }

    public static WebAppManager getInstance() {
        return manager;
    }

    public List getContextPathList() {
        return this.contextPathList;
    }

    public List getWebAppList() {
        return this.webAppList;
    }

    public WebApp findWebApp(String contextPath) {
        Iterator itr = this.getWebAppList().iterator();
        while (itr.hasNext()) {
            WebApp webapp = (WebApp)itr.next();
            if (!webapp.getContextPath().equals(contextPath)) continue;
            return webapp;
        }
        return null;
    }

    private class DirFileFilter
    implements FileFilter {
        DirFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    private class WarFileFilter
    implements FileFilter {
        WarFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".war");
        }
    }
}

