/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import net.souko105.flashserver.HttpHeaderConst;

public class HttpRequestHeader {
    private String method;
    private String version;
    private String requestURI;
    private String queryString;
    private Map headerFieldMap = new HashMap();
    private List headerFieldNameList = new LinkedList();
    private Map cookieMap = new HashMap();
    private List cookieNameList = new LinkedList();

    public HttpRequestHeader(String httpHeader) {
        if (httpHeader == null) {
            throw new IllegalArgumentException("Http header is null.");
        }
        this.parseHttpRequest(httpHeader);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseHttpRequest(String httpRequest) {
        StringTokenizer token = new StringTokenizer(httpRequest, HttpHeaderConst.CRLF_STRING, false);
        if (!token.hasMoreTokens()) throw new IllegalArgumentException("Invalid http request.");
        String requestLine = token.nextToken();
        this.parseRequestLine(requestLine);
        while (token.hasMoreTokens()) {
            String line = token.nextToken();
            if (line.trim().length() <= 0) {
                return;
            }
            int nameEnd = line.indexOf(HttpHeaderConst.COLON_STRING);
            String name = line.substring(0, nameEnd);
            String value = null;
            int valueStart = nameEnd + HttpHeaderConst.COLON_STRING.length();
            if (line.length() > valueStart) {
                value = line.substring(valueStart, line.length());
            }
            if (name.equals("Cookie")) {
                this.parseCookie(value);
                continue;
            }
            this.addHeader(name, value);
        }
    }

    private void parseRequestLine(String requestLine) {
        StringTokenizer token = new StringTokenizer(requestLine, " ", false);
        if (!token.hasMoreTokens()) {
            throw new IllegalArgumentException("Invalid http request. method not found.");
        }
        this.method = token.nextToken().trim();
        if (token.hasMoreTokens()) {
            String request = token.nextToken().trim();
            int paramDelim = request.indexOf("?");
            if (paramDelim > 0) {
                this.requestURI = request.substring(0, paramDelim);
                this.queryString = request.substring(paramDelim + 1, request.length());
            } else {
                this.requestURI = request;
            }
        } else {
            throw new IllegalArgumentException("Invalid http request. requestURI not found.");
        }
        if (!token.hasMoreTokens()) {
            throw new IllegalArgumentException("Invalid http request. version not found.");
        }
        this.version = token.nextToken().trim();
    }

    private void parseCookie(String cookieValue) {
        if (cookieValue == null || cookieValue.length() <= 0) {
            return;
        }
        StringTokenizer token = new StringTokenizer(cookieValue, new String(HttpHeaderConst.SEMI_COLON), false);
        while (token.hasMoreTokens()) {
            String keyValue = token.nextToken();
            int delimIndex = keyValue.indexOf("=");
            String key = keyValue.substring(0, delimIndex);
            String value = keyValue.substring(delimIndex + 1, keyValue.length());
            this.addCookie(key, value);
        }
    }

    public void addCookie(String key, String value) {
        if (!this.cookieMap.containsKey(key)) {
            this.cookieNameList.add(key);
        }
        Cookie cookie = new Cookie(key, value);
        this.cookieMap.put(key, cookie);
    }

    public List getHeaderName() {
        return this.headerFieldNameList;
    }

    public List getHeaders() {
        ArrayList list = new ArrayList();
        Iterator itr = this.headerFieldNameList.iterator();
        while (itr.hasNext()) {
            list.add(this.headerFieldMap.get(itr.next()));
        }
        return list;
    }

    public void addHeader(String paramName, String paramValue) {
        if (!this.headerFieldMap.containsKey(paramName)) {
            this.headerFieldNameList.add(paramName);
        }
        this.headerFieldMap.put(paramName, paramValue);
    }

    public void removeHeader(String paramName) {
        this.headerFieldMap.remove(paramName);
        this.headerFieldNameList.remove(paramName);
    }

    public String getHeader(String paramName) {
        return (String)this.headerFieldMap.get(paramName);
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getVersion() {
        return this.version;
    }

    public Cookie getCookie(String cookieName) {
        return (Cookie)this.cookieMap.get(cookieName);
    }

    public List getCookieList() {
        ArrayList cookieList = new ArrayList();
        Iterator itr = this.cookieNameList.iterator();
        while (itr.hasNext()) {
            cookieList.add(this.cookieMap.get(itr.next()));
        }
        return cookieList;
    }

    public boolean isKeepAlive() {
        String keepAliveHeader = this.getHeader("Keep-Alive");
        if (keepAliveHeader != null && keepAliveHeader.equalsIgnoreCase("close")) {
            return false;
        }
        if (this.version.endsWith("1.1")) {
            return true;
        }
        String connection = this.getHeader("Connection");
        return connection.equals("Keep-Alive");
    }

    public String toString() {
        String value;
        String name;
        StringBuffer buf = new StringBuffer();
        buf.append("method=" + this.method);
        buf.append(",version=" + this.version);
        buf.append(",requestURI=" + this.requestURI);
        buf.append(",queryString=" + this.queryString + "\n");
        buf.append("header[");
        Iterator itr = this.headerFieldNameList.iterator();
        while (itr.hasNext()) {
            name = (String)itr.next();
            value = (String)this.headerFieldMap.get(name);
            buf.append(String.valueOf(name) + "=" + value + ",");
        }
        buf.append("]\n");
        buf.append("cookie[");
        itr = this.cookieNameList.iterator();
        while (itr.hasNext()) {
            name = (String)itr.next();
            value = (Cookie)this.cookieMap.get(name);
            buf.append(String.valueOf(name) + "=" + value.getValue() + ",");
        }
        buf.append("]");
        return buf.toString();
    }
}

